/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.beans.Introspector;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.testing.MojoRule;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.TestHelper;

public class MojoTestRule<P extends AbstractPlugin>
extends MojoRule {
    private static final Log log = LogFactory.getLog(MojoTestRule.class);
    private File testDirectory;
    private String testMethodName;
    private File pomFile;
    private P mojo;
    private final Class<?> testClass;
    private final String goalName;

    public static <P extends AbstractPlugin> MojoTestRule<P> newRule(Class<?> testClass, String goalName) {
        return new MojoTestRule<P>(testClass, goalName);
    }

    protected MojoTestRule(Class<?> testClass, String goalName) {
        this.testClass = testClass;
        this.goalName = goalName;
    }

    public Statement apply(Statement base, Description description) {
        this.testMethodName = description.getMethodName();
        return super.apply(base, description);
    }

    protected P createMojo(File pomFile, String goalName) throws Exception {
        AbstractPlugin result = (AbstractPlugin)this.lookupMojo(goalName, pomFile);
        return (P)result;
    }

    protected void setUpMojo(P mojo, File pomFile) throws Exception {
        MavenProject project = mojo.getProject();
        if (project == null) {
            log.debug((Object)"init maven project");
            ProjectBuilder projectBuilder = (ProjectBuilder)this.lookup(ProjectBuilder.class);
            DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
            projectBuildingRequest.setRepositorySession((RepositorySystemSession)new DefaultRepositorySystemSession());
            ProjectBuildingResult projectBuildingResult = projectBuilder.build(pomFile, (ProjectBuildingRequest)projectBuildingRequest);
            project = projectBuildingResult.getProject();
            mojo.setProject(project);
        }
        mojo.getProject().setFile(pomFile);
    }

    public boolean initMojo(P mojo) {
        boolean canContinue;
        block2: {
            try {
                mojo.init();
                canContinue = true;
            }
            catch (Exception e) {
                canContinue = false;
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Could not init mojo ", (Throwable)e);
            }
        }
        return canContinue;
    }

    protected void tearDownMojo(P mojo) {
    }

    protected void before() throws Throwable {
        log.info((Object)("Starting test: " + this.testClass.getName() + "#" + this.testMethodName));
        this.testDirectory = this.getTestDir(this.testMethodName);
        this.pomFile = this.getPomFile(this.testDirectory, this.testMethodName);
        try {
            Assert.assertTrue((String)("could not find pom " + this.pomFile.getAbsoluteFile()), (boolean)this.pomFile.exists());
            this.mojo = this.createMojo(this.pomFile, this.goalName);
            this.setUpMojo(this.mojo, this.pomFile);
        }
        catch (Exception ex) {
            throw new IllegalStateException("could not init test " + this.testClass + "#" + this.testMethodName, ex);
        }
    }

    protected void after() {
        if (this.mojo != null) {
            this.tearDownMojo(this.mojo);
        }
        this.pomFile = null;
        this.mojo = null;
        this.testDirectory = null;
    }

    public P getMojo() {
        return this.mojo;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public File getTestDirectory() {
        return this.testDirectory;
    }

    protected File getTestDir(String methodName) {
        String rep = this.testClass.getPackage().getName() + "." + Introspector.decapitalize(this.testClass.getSimpleName());
        String[] paths = rep.split("\\.");
        File directory = TestHelper.getFile((File)TestHelper.getTestBasedir(), (String[])paths);
        if (TestHelper.isVerbose()) {
            log.info((Object)("test dir = " + this.getRelativePathFromBasedir(directory)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("test dir = " + this.getRelativePathFromBasedir(directory)));
        }
        return directory;
    }

    protected File getPomFile(File testDir, String methodName) {
        File pom = new File(testDir, methodName + ".xml");
        if (TestHelper.isVerbose()) {
            log.info((Object)("pom file = " + this.getRelativePathFromBasedir(pom)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("pom file = " + this.getRelativePathFromBasedir(pom)));
        }
        return pom;
    }

    public String getRelativePathFromBasedir(File f) {
        return TestHelper.getRelativePath((File)TestHelper.getBasedir(), (File)f);
    }
}

