/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.generator;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.nuiton.guix.model.GuixModelObject;
import org.xmlpull.v1.XmlSerializer;

/**
 * Interface of the generators
 *
 * @author kevin
 */
public interface Generator {

    public JavaFile generate();

    public File getSrcDir();

    public void setSrcDir(File srcDir);

    public File getDestDir();

    public void setDestDir(File destDir);

    public GuixModelObject getGmo();

    public void setGmo(GuixModelObject gmo);

    public Long getLastModification();

    public void setLastModification(Long lastModification);

    public boolean isMainClass();

    public void setMainClass(boolean mainClass);

    public XmlSerializer getSerializer();

    public void setSerializer(XmlSerializer serializer);

    public Map<String, JavaFile> getClasses();

    public void setClasses(Map<String, JavaFile> classes);

    public List<File> getCSSFiles();

    public void setCSSFiles(List<File> cssFiles);

    public String getLauncherName();

    public void setLauncherName(String launcherName);

    public List<JavaFile> getPropertyChangeListenerDependencies();

    public void setPropertyChangeListenerDependencies(List<JavaFile> propertyChangeListenerDependencies);

}
