/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix.generator;

import com.google.gwt.user.client.ui.Label;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.generator.GuixGenerator;
import org.nuiton.guix.generator.GwtAbstractClassGenerator;
import org.nuiton.guix.generator.GwtImplementationGenerator;
import org.nuiton.guix.generator.GwtInterfaceGenerator;
import org.nuiton.guix.generator.GwtJavaFileGenerator;
import org.nuiton.guix.generator.JavaField;
import org.nuiton.guix.generator.JavaFile;
import org.nuiton.guix.generator.JavaMethod;
import org.nuiton.guix.model.AttributeDescriptor;
import org.nuiton.guix.tags.TagHandler;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class GwtGenerator
extends GuixGenerator {
    private Log log = LogFactory.getLog(GwtGenerator.class);
    Map<GwtJavaFileGenerator, File> generators = new HashMap<GwtJavaFileGenerator, File>();
    List<String> modules = new ArrayList<String>();

    public JavaFile generate() {
        block25: {
            try {
                File webappOutDir;
                File resourcesOutDir;
                String gmoClassName = this.gmo.getClassDescriptor().getName();
                File javaOutDir = new File(this.destDir, "java/" + this.gmo.getClassDescriptor().getPackageName().replace('.', File.separatorChar));
                if (!javaOutDir.exists()) {
                    javaOutDir.mkdirs();
                }
                if (!(resourcesOutDir = new File(this.destDir, "resources/" + this.gmo.getClassDescriptor().getPackageName().replace('.', File.separatorChar))).exists()) {
                    resourcesOutDir.mkdirs();
                }
                if (!(webappOutDir = new File(this.destDir, "webapp")).exists()) {
                    webappOutDir.mkdirs();
                }
                File out = new File(javaOutDir, gmoClassName + ".java");
                File outAbstract = new File(javaOutDir, gmoClassName + "Abstract.java");
                File outImpl = new File(javaOutDir, gmoClassName + "Impl.java");
                if (this.lastModification > out.lastModified()) {
                    try {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("Generation of " + this.gmo.getClassDescriptor().getName()));
                        }
                        if (!out.exists()) {
                            try {
                                out.createNewFile();
                                outAbstract.createNewFile();
                                outImpl.createNewFile();
                            }
                            catch (IOException ex) {
                                this.log.error((Object)ex);
                            }
                        }
                        GwtInterfaceGenerator ging = new GwtInterfaceGenerator(this.gmo, this.classes);
                        GwtAbstractClassGenerator gacg = new GwtAbstractClassGenerator(this.gmo, this.classes);
                        gacg.setGwtGenerator(this);
                        GwtImplementationGenerator gimg = new GwtImplementationGenerator(this.gmo, this.classes);
                        if (this.mainClass) {
                            gimg.addMainMethod();
                            File javaClientDir = javaOutDir;
                            while (!javaClientDir.getPath().substring(javaClientDir.getPath().lastIndexOf(File.separatorChar) + 1).equals("client")) {
                                javaClientDir = javaClientDir.getParentFile();
                            }
                            File publicDir = new File(javaClientDir.getParentFile(), "public");
                            if (!publicDir.exists()) {
                                publicDir.mkdirs();
                            }
                            this.generateConfig(javaClientDir, publicDir);
                            for (File f : this.getCSSFiles()) {
                                try {
                                    int read;
                                    File fPublic = new File(publicDir, f.getName());
                                    fPublic.createNewFile();
                                    FileInputStream fis = new FileInputStream(f);
                                    FileOutputStream fos = new FileOutputStream(fPublic);
                                    byte[] buffer = new byte[524288];
                                    while ((read = fis.read(buffer)) != -1) {
                                        fos.write(buffer, 0, read);
                                    }
                                    fis.close();
                                    fos.close();
                                }
                                catch (IOException eee) {
                                    this.log.error((Object)eee);
                                }
                            }
                        }
                        ging.generate();
                        this.generators.put(ging, out);
                        JavaFile jf = gacg.generate();
                        this.generators.put(gacg, outAbstract);
                        gimg.generate();
                        this.generators.put(gimg, outImpl);
                        this.serializer.startTag("", "bean");
                        this.serializer.attribute("", "id", gmoClassName.replace(out.getName().charAt(0), Character.toLowerCase(out.getName().charAt(0)))).attribute("", "class", gmoClassName + "Impl").attribute("", "singleton", "false").endTag("", "bean");
                        this.setBindingsToGenerate(gacg.getBindings2Generate());
                        return jf;
                    }
                    catch (IllegalArgumentException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block25;
                    }
                    catch (IllegalStateException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block25;
                    }
                    catch (IOException eee) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)eee);
                        }
                        break block25;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)(this.gmo.getClassDescriptor().getName() + " has already been generated and is up to date."));
                }
            }
            catch (Exception eee) {
                if (!this.log.isErrorEnabled()) break block25;
                this.log.error((Object)eee);
            }
        }
        return null;
    }

    private void generateConfig(File javaClientDir, File publicDir) {
        try {
            int i;
            File webInfDir;
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            XmlSerializer serializer = factory.newSerializer();
            File webappDir = new File(this.destDir, "webapp");
            if (!webappDir.exists()) {
                webappDir.mkdirs();
            }
            if (!(webInfDir = new File(webappDir, "WEB-INF")).exists()) {
                webInfDir.mkdirs();
            }
            serializer.setOutput((Writer)new PrintWriter(new File(webInfDir, "web.xml")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
            serializer.startTag("", "web-app");
            serializer.startTag("", "welcome-file-list");
            serializer.startTag("", "welcome-file");
            serializer.text("index.html");
            serializer.endTag("", "welcome-file");
            serializer.endTag("", "welcome-file-list");
            serializer.endTag("", "web-app");
            serializer.endDocument();
            serializer = factory.newSerializer();
            serializer.setOutput((Writer)new PrintWriter(new File(webappDir, "index.html")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
            serializer.docdecl(" HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"");
            serializer.startTag("", "html");
            serializer.startTag("", "head");
            serializer.startTag("", "meta");
            serializer.attribute("", "http-equip", "REFRESH");
            serializer.attribute("", "content", "0;url=" + this.launcherName + File.separatorChar + this.launcherName.substring(this.launcherName.lastIndexOf(".") + 1) + ".html");
            serializer.endTag("", "meta");
            serializer.endTag("", "head");
            serializer.endTag("", "html");
            serializer.endDocument();
            serializer = factory.newSerializer();
            serializer.setOutput((Writer)new PrintWriter(new File(javaClientDir.getParentFile(), this.launcherName.substring(this.launcherName.lastIndexOf(46) + 1) + ".gwt.xml")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
            serializer.startTag("", "module");
            serializer.comment("Inherit the core Web Toolkit stuff.");
            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.google.gwt.user.User");
            serializer.endTag("", "inherits");
            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.googlecode.gwtx.Java");
            serializer.endTag("", "inherits");
            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.googlecode.gwt.math.Math");
            serializer.endTag("", "inherits");
            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "org.gwtwidgets.WidgetLibrary");
            serializer.endTag("", "inherits");
            serializer.startTag("", "inherits");
            for (i = 0; i < this.gmo.getAttributeDescriptors().size() && !((AttributeDescriptor)this.gmo.getAttributeDescriptors().get(i)).getName().equals("theme"); ++i) {
            }
            serializer.attribute("", "name", i < this.gmo.getAttributeDescriptors().size() ? ((AttributeDescriptor)this.gmo.getAttributeDescriptors().get(i)).getValue() : "com.google.gwt.user.theme.standard.Standard");
            serializer.endTag("", "inherits");
            serializer.comment("Specify the app entry point class.");
            serializer.startTag("", "entry-point");
            serializer.attribute("", "class", this.gmo.getClassDescriptor().getPackageName() + "." + this.gmo.getClassDescriptor().getName() + "Impl");
            serializer.endTag("", "entry-point");
            serializer.comment("Specify the application specific style sheet.");
            for (File f : this.cssFiles) {
                serializer.startTag("", "stylesheet");
                serializer.attribute("", "src", f.getName());
                serializer.endTag("", "stylesheet");
            }
            serializer.endTag("", "module");
            serializer.endDocument();
            serializer = factory.newSerializer();
            serializer.setOutput((Writer)new PrintWriter(new File(publicDir, this.launcherName.substring(this.launcherName.lastIndexOf(46) + 1) + ".html")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
            serializer.docdecl(" HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
            serializer.comment("The HTML 4.01 Transitional DOCTYPE declaration above set at the top of the file will set the browser's rendering engine into \"Quirks Mode\". Replacing this declaration with a \"Standards Mode\" doctype is supported, but may lead to some differences in layout.");
            serializer.startTag("", "html");
            serializer.startTag("", "head");
            serializer.startTag("", "meta");
            serializer.attribute("", "http-equiv", "content-type");
            serializer.attribute("", "content", "text/html; charset=UTF-8");
            serializer.endTag("", "meta");
            serializer.comment("This script loads your compiled module. If you add any GWT meta tags, they must be added before this line.");
            serializer.startTag("", "script");
            serializer.attribute("", "type", "text/javascript");
            serializer.attribute("", "language", "javascript");
            serializer.attribute("", "src", this.launcherName + ".nocache.js");
            serializer.text("\n");
            serializer.endTag("", "script");
            serializer.startTag("", "title");
            for (i = 0; i < this.gmo.getAttributeDescriptors().size() && !((AttributeDescriptor)this.gmo.getAttributeDescriptors().get(i)).getName().equals("title"); ++i) {
            }
            serializer.text(i < this.gmo.getAttributeDescriptors().size() ? ((AttributeDescriptor)this.gmo.getAttributeDescriptors().get(i)).getValue() : "My Application");
            serializer.endTag("", "title");
            serializer.endTag("", "head");
            serializer.comment("The body can have arbitrary html, or you can leave the body empty if you want to create a completely dynamic UI.");
            serializer.startTag("", "body");
            serializer.comment("OPTIONAL: include this if you want history support");
            serializer.startTag("", "iframe");
            serializer.attribute("", "src", "javascript:''");
            serializer.attribute("", "id", "__gwt_historyFrame");
            serializer.attribute("", "tabIndex", "-1");
            serializer.attribute("", "style", "position:absolute;width:0;height:0;border:0");
            serializer.endTag("", "iframe");
            serializer.endTag("", "body");
            serializer.endTag("", "html");
            serializer.endDocument();
        }
        catch (XmlPullParserException ex) {
            this.log.error((Object)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
        }
    }

    public void saveFiles() {
        for (GwtJavaFileGenerator gen : this.generators.keySet()) {
            gen.saveFile(this.generators.get((Object)gen));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Class> generateBindings(StringBuffer dbCreation, StringBuffer dbDeletion, TagHandler prevTh, JavaFile jf, Class clazz, String[] binding, int i, List<String> alreadyChecked, String methodToInvoke, Map<GuixGenerator, JavaFile> generatedFiles) {
        String realAttributename;
        ArrayList<Class> result;
        String removeMethod;
        String addMethod;
        Class<PropertyChangeListener> listener;
        String model;
        TagHandler th;
        Class<?> nextClazz;
        JavaFile nextFile;
        String getter;
        block61: {
            String getterWoBrackets;
            String returnType;
            boolean bindingExists;
            block65: {
                JavaField f;
                block62: {
                    String realMethodName;
                    block64: {
                        block63: {
                            if (dbCreation == null) return new ArrayList<Class>();
                            if (dbDeletion == null) return new ArrayList<Class>();
                            if (binding == null) return new ArrayList<Class>();
                            if (jf == null) {
                                if (clazz == null) return new ArrayList<Class>();
                            }
                            if (methodToInvoke == null) return new ArrayList<Class>();
                            if (generatedFiles == null) return new ArrayList<Class>();
                            if (i < 0) {
                                return new ArrayList<Class>();
                            }
                            bindingExists = false;
                            returnType = null;
                            getter = null;
                            nextFile = null;
                            nextClazz = null;
                            th = null;
                            model = null;
                            listener = null;
                            addMethod = null;
                            removeMethod = null;
                            result = new ArrayList<Class>();
                            realMethodName = null;
                            realAttributename = null;
                            if (Character.isUpperCase(binding[i].charAt(binding[i].lastIndexOf(".") + 1))) {
                                try {
                                    Label.class.getClassLoader().loadClass(binding[i]);
                                }
                                catch (ClassNotFoundException eee) {
                                    try {
                                        ClassLoader.getSystemClassLoader().loadClass(binding[i]);
                                    }
                                    catch (ClassNotFoundException eeee) {
                                        return null;
                                    }
                                }
                                bindingExists = false;
                                return result;
                            }
                            if (!binding[i].endsWith(")")) break block62;
                            realMethodName = binding[i].substring(0, binding[i].indexOf(40));
                            if (prevTh != null) {
                                if (binding[i].startsWith("get")) {
                                    realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf("(")));
                                    if (realAttributename != null) {
                                        realMethodName = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                                    }
                                } else if (binding[i].startsWith("is") && (realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf("(")))) != null) {
                                    realMethodName = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                                }
                            }
                            if (realAttributename == null) {
                                realAttributename = binding[i].startsWith("get") ? Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf(40)) : (binding[i].startsWith("is") ? Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf(40)) : binding[i].substring(0, binding[i].indexOf(40)));
                            }
                            if (jf == null) break block63;
                            boolean bl = bindingExists = jf.getMethod(realMethodName, null) != null;
                            if (bindingExists) {
                                returnType = jf.getMethod(realMethodName, null).getReturnType();
                                f = jf.getField(realAttributename);
                                if (f != null) {
                                    th = f.getTagHandler();
                                }
                            }
                            break block64;
                        }
                        try {
                            returnType = clazz.getMethod(realMethodName, null).getReturnType().getName();
                            bindingExists = true;
                        }
                        catch (NoSuchMethodException eee) {
                            bindingExists = false;
                        }
                    }
                    getter = realMethodName + binding[i].substring(binding[i].indexOf(40));
                    break block65;
                }
                if (prevTh != null) {
                    realAttributename = prevTh.getAttrToGenerate(binding[i]);
                }
                if (realAttributename == null) {
                    realAttributename = binding[i];
                }
                if (jf != null) {
                    boolean bl = bindingExists = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null || jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null;
                    if (bindingExists) {
                        returnType = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType() : jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType();
                    }
                    getter = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()" : "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                    f = jf.getField(realAttributename);
                    if (f != null) {
                        th = f.getTagHandler();
                    }
                } else {
                    try {
                        returnType = clazz.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType().getName();
                        getter = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                        bindingExists = true;
                    }
                    catch (NoSuchMethodException eee) {
                        try {
                            returnType = clazz.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType().getName();
                            getter = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                            bindingExists = true;
                        }
                        catch (NoSuchMethodException eeee) {
                            bindingExists = false;
                        }
                    }
                }
            }
            if (!bindingExists) {
                if (!this.log.isErrorEnabled()) return result;
                this.log.error((Object)("unable to bind " + binding[i]));
                return result;
            }
            binding[i] = getter;
            if (prevTh != null && prevTh.hasEventInfosAboutMethod(getterWoBrackets = getter.substring(0, getter.indexOf(40)))) {
                model = prevTh.getEventInfosModelName(getterWoBrackets);
                listener = prevTh.getEventInfosListenerClass(getterWoBrackets);
                addMethod = prevTh.getEventInfosAddListenerMethodName(getterWoBrackets);
                removeMethod = prevTh.getEventInfosRemoveListenerMethodName(getterWoBrackets);
            }
            try {
                nextClazz = Label.class.getClassLoader().loadClass(returnType);
            }
            catch (ClassNotFoundException eee) {
                try {
                    nextClazz = ClassLoader.getSystemClassLoader().loadClass(returnType);
                }
                catch (ClassNotFoundException eeee) {
                    for (JavaFile javaFile : generatedFiles.values()) {
                        if (!returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) continue;
                        nextFile = javaFile;
                        break;
                    }
                    if (nextFile != null) break block61;
                    for (JavaFile javaFile : this.propertyChangeListenerDependencies) {
                        if (!returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) continue;
                        nextFile = javaFile;
                        break;
                    }
                }
            }
        }
        if (listener == null && clazz != null) {
            try {
                clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                listener = PropertyChangeListener.class;
                addMethod = "addPropertyChangeListener";
                removeMethod = "removePropertyChangeListener";
            }
            catch (NoSuchMethodException eee) {}
        } else if (listener == null && jf != null) {
            for (JavaMethod method : jf.getAllMethods()) {
                if (!method.getName().equals("addPropertyChangeListener") || (method.getArguments().length != 1 || !method.getArguments()[0].getType().equals("java.beans.PropertyChangeListener")) && (method.getArguments().length != 2 || !method.getArguments()[1].getType().equals("java.beans.PropertyChangeListener"))) continue;
                listener = PropertyChangeListener.class;
                addMethod = "addPropertyChangeListener";
                removeMethod = "removePropertyChangeListener";
            }
        }
        boolean ifAdded = false;
        if (listener == null) return result;
        if (alreadyChecked == null || alreadyChecked.isEmpty()) {
            if (nextClazz != null && !nextClazz.isPrimitive()) {
                ifAdded = true;
                dbCreation.append("if(").append(getter).append(" != null").append(") {\n");
                dbDeletion.append("if(").append(getter).append(" != null").append(") {\n");
            }
        } else {
            int j;
            ifAdded = true;
            dbCreation.append("if(");
            dbDeletion.append("if(");
            for (j = 0; j < alreadyChecked.size(); ++j) {
                dbCreation.append(alreadyChecked.get(0));
                dbDeletion.append(alreadyChecked.get(0));
                for (int k = 1; k <= j; ++k) {
                    dbCreation.append(".").append(alreadyChecked.get(k));
                    dbDeletion.append(".").append(alreadyChecked.get(k));
                }
                dbCreation.append(" != null && ");
                dbDeletion.append(" != null && ");
            }
            if (binding.length > alreadyChecked.size() + 1 && nextClazz != null && !nextClazz.isPrimitive()) {
                for (j = 0; j < alreadyChecked.size(); ++j) {
                    dbCreation.append(alreadyChecked.get(j)).append(".");
                    dbDeletion.append(alreadyChecked.get(j)).append(".");
                }
                dbCreation.append(getter).append(" != null");
                dbDeletion.append(getter).append(" != null");
            } else {
                dbCreation.delete(dbCreation.length() - 4, dbCreation.length());
                dbDeletion.delete(dbDeletion.length() - 4, dbDeletion.length());
            }
            dbCreation.append(") {\n");
            dbDeletion.append(") {\n");
        }
        if (alreadyChecked != null) {
            for (int j = 0; j < alreadyChecked.size(); ++j) {
                dbCreation.append(alreadyChecked.get(j)).append(".");
                dbDeletion.append(alreadyChecked.get(j)).append(".");
            }
        }
        if (model != null) {
            dbCreation.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
            dbDeletion.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
        }
        dbCreation.append(addMethod).append("(");
        dbDeletion.append(removeMethod).append("(");
        if (listener == PropertyChangeListener.class) {
            dbCreation.append("\"").append(realAttributename).append("\", ");
            dbDeletion.append("\"").append(realAttributename).append("\", ");
        }
        dbCreation.append("new ").append(listener.getName()).append("() {\n");
        dbDeletion.append("new ").append(listener.getName()).append("() {\n");
        for (Method m : listener.getMethods()) {
            StringBuffer sb = new StringBuffer();
            for (Annotation a : m.getDeclaredAnnotations()) {
                dbCreation.append(((Object)a).toString()).append("\n");
            }
            sb.append("public ").append(m.getReturnType().getCanonicalName()).append(" ").append(m.getName()).append("(");
            for (int n = 0; n < m.getParameterTypes().length; ++n) {
                sb.append(m.getParameterTypes()[n].getCanonicalName()).append(" arg").append(n).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length()).append(")").append(" {\n").append("onChangeFrom").append(methodToInvoke).append("();\n}\n");
            dbCreation.append(sb);
            dbDeletion.append(sb);
        }
        dbCreation.append("});\n");
        dbDeletion.append("});\n");
        if (ifAdded) {
            dbCreation.append("}\n");
            dbDeletion.append("}\n");
        }
        if (alreadyChecked == null) {
            alreadyChecked = new ArrayList<String>();
        }
        alreadyChecked.add(getter);
        try {
            if (i + 1 < binding.length) {
                result.addAll(this.generateBindings(dbCreation, dbDeletion, th, nextFile, nextClazz, binding, i + 1, alreadyChecked, methodToInvoke, generatedFiles));
            }
            if (listener == null) return result;
            if (result.contains(listener)) return result;
            result.add(listener);
            return result;
        }
        catch (NullPointerException eee) {
            this.log.error((Object)i);
            eee.printStackTrace();
            return null;
        }
    }
}

