/**
 * *##% guix-compiler-gwt
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.generator;

import com.google.gwt.user.client.ui.Label;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.guix.tags.TagHandler;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

/**
 * Generates the interface, abstract class and implementation class
 * corresponding to the class described by the user,
 * as well as the configuation file and html file if this class is the main class.
 *
 * @author kmorin
 */
public class GwtGenerator extends GuixGenerator {

    /** log */
    private Log log = LogFactory.getLog(GwtGenerator.class);
    /** Maps the different generators with the file to save the generated JavaFile */
    Map<GwtJavaFileGenerator, File> generators = new HashMap<GwtJavaFileGenerator, File>();

    List<String> modules = new ArrayList<String>();

    @Override
    public JavaFile generate() {
        try {
            String gmoClassName = gmo.getClassDescriptor().getName();
            File javaOutDir = new File(destDir, "java/" + gmo.getClassDescriptor().getPackageName().replace('.', File.separatorChar));
            if (!javaOutDir.exists()) {
                javaOutDir.mkdirs();
            }
            File resourcesOutDir = new File(destDir, "resources/" + gmo.getClassDescriptor().getPackageName().replace('.', File.separatorChar));
            if (!resourcesOutDir.exists()) {
                resourcesOutDir.mkdirs();
            }
            File webappOutDir = new File(destDir, "webapp");
            if (!webappOutDir.exists()) {
                webappOutDir.mkdirs();
            }
            File out = new File(javaOutDir, gmoClassName + ".java");
            File outAbstract = new File(javaOutDir, gmoClassName + "Abstract.java");
            File outImpl = new File(javaOutDir, gmoClassName + "Impl.java");

            if (lastModification > out.lastModified()) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("Generation of " + gmo.getClassDescriptor().getName());
                    }
                    if (!out.exists()) {
                        try {
                            out.createNewFile();
                            outAbstract.createNewFile();
                            outImpl.createNewFile();
                        }
                        catch (IOException ex) {
                            log.error(ex);
                        }
                    }
                    GwtInterfaceGenerator ging = new GwtInterfaceGenerator(gmo, classes);
                    GwtAbstractClassGenerator gacg = new GwtAbstractClassGenerator(gmo, classes);
                    gacg.setGwtGenerator(this);
                    GwtImplementationGenerator gimg = new GwtImplementationGenerator(gmo, classes);

                    if (mainClass) {
                        gimg.addMainMethod();
                        File javaClientDir = javaOutDir;
                        while(!javaClientDir.getPath().substring(javaClientDir.getPath().lastIndexOf(File.separatorChar) + 1).equals("client")) {
                            javaClientDir = javaClientDir.getParentFile();
                        }
                        
                        File publicDir = new File(javaClientDir.getParentFile(), "public");
                        if (!publicDir.exists()) {
                            publicDir.mkdirs();
                        }

                        generateConfig(javaClientDir, publicDir);
                        
                        for(File f : getCSSFiles()) {
                            try {
                                File fPublic = new File(publicDir, f.getName());
                                fPublic.createNewFile();
                                FileInputStream fis = new FileInputStream(f);
                                FileOutputStream fos = new FileOutputStream(fPublic);
                                // segment size : 0.5Mo
                                byte buffer[] = new byte[512*1024];
                                int read;
                                while((read = fis.read(buffer)) != -1) {
                                    fos.write(buffer, 0, read);
                                }
                                fis.close();
                                fos.close();
                            }
                            catch(IOException eee) {
                                log.error(eee);
                            }
                        }
                    }

                    ging.generate();
                    generators.put(ging, out);
                    JavaFile jf = gacg.generate();
                    generators.put(gacg, outAbstract);
                    gimg.generate();
                    generators.put(gimg, outImpl);

                    serializer.startTag("", "bean");
                    serializer.attribute("", "id", gmoClassName.replace(out.getName().charAt(0),
                            Character.toLowerCase(out.getName().charAt(0)))).attribute("", "class", gmoClassName + "Impl").attribute("", "singleton", "false").endTag("", "bean");
                    setBindingsToGenerate(gacg.getBindings2Generate());
                    
                    return jf;
                }
                catch (IllegalArgumentException eee) {
                    if(log.isErrorEnabled()) {
                        log.error(eee);
                    }
                }
                catch (IllegalStateException eee) {
                    if(log.isErrorEnabled()) {
                        log.error(eee);
                    }
                }
                catch (IOException eee) {
                    if(log.isErrorEnabled()) {
                        log.error(eee);
                    }
                }
            }
            else if (log.isWarnEnabled()) {
                log.warn(gmo.getClassDescriptor().getName() + " has already been generated and is up to date.");
            }
        }
        catch(Exception eee) {
            if(log.isErrorEnabled()) {
                log.error(eee);
            }
        }

        return null;
    }

    private void generateConfig(File javaClientDir, File publicDir)  {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty(XmlPullParserFactory.PROPERTY_NAME), null);

            XmlSerializer serializer = factory.newSerializer();

            File webappDir = new File(destDir, "webapp");
            if(!webappDir.exists()) {
                webappDir.mkdirs();
            }
            File webInfDir = new File(webappDir, "WEB-INF");
            if(!webInfDir.exists()) {
                webInfDir.mkdirs();
            }

            //generates web.xml
            serializer.setOutput(new PrintWriter(new File(webInfDir, "web.xml")));

            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "\t");

            serializer.startTag("", "web-app");

            serializer.startTag("", "welcome-file-list");
            serializer.startTag("", "welcome-file");
            serializer.text("index.html");
            serializer.endTag("", "welcome-file");
            serializer.endTag("", "welcome-file-list");
            
            serializer.endTag("", "web-app");
            serializer.endDocument();

            //generates index.html
            serializer = factory.newSerializer();
            serializer.setOutput(new PrintWriter(new File(webappDir, "index.html")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "\t");

            serializer.docdecl(" HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"");

            serializer.startTag("", "html");

            serializer.startTag("", "head");
            serializer.startTag("", "meta");
            serializer.attribute("", "http-equip", "REFRESH");
            serializer.attribute("", "content", "0;url=" + launcherName + File.separatorChar + launcherName.substring(launcherName.lastIndexOf(".") + 1) + ".html");
            serializer.endTag("", "meta");
            serializer.endTag("", "head");

            serializer.endTag("", "html");
            serializer.endDocument();

            //generates the .gwt.xml file
            serializer = factory.newSerializer();

            serializer.setOutput(new PrintWriter(new File(javaClientDir.getParentFile(), launcherName.substring(launcherName.lastIndexOf('.') + 1) + ".gwt.xml")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "\t");

            serializer.startTag("", "module");
            serializer.comment("Inherit the core Web Toolkit stuff.");

            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.google.gwt.user.User");
            serializer.endTag("","inherits");

            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.googlecode.gwtx.Java");
            serializer.endTag("","inherits");

            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "com.googlecode.gwt.math.Math");
            serializer.endTag("","inherits");

            serializer.startTag("", "inherits");
            serializer.attribute("", "name", "org.gwtwidgets.WidgetLibrary");
            serializer.endTag("","inherits");

            serializer.startTag("", "inherits");
            int i = 0;
            while(i < gmo.getAttributeDescriptors().size()
                    && !gmo.getAttributeDescriptors().get(i).getName().equals("theme")) {
                i++;
            }
            serializer.attribute("", "name", i < gmo.getAttributeDescriptors().size() ?
                    gmo.getAttributeDescriptors().get(i).getValue()
                    : "com.google.gwt.user.theme.standard.Standard");
            serializer.endTag("","inherits");

            serializer.comment("Specify the app entry point class.");
            serializer.startTag("","entry-point");
            serializer.attribute("", "class", gmo.getClassDescriptor().getPackageName()
                    + "." + gmo.getClassDescriptor().getName() + "Impl");
            serializer.endTag("","entry-point");

            serializer.comment("Specify the application specific style sheet.");
            for(File f : cssFiles) {
                serializer.startTag("", "stylesheet");
                serializer.attribute("","src", f.getName());
                serializer.endTag("", "stylesheet");
            }

            serializer.endTag("", "module");
            serializer.endDocument();

            //generates the .html file
            serializer = factory.newSerializer();

            serializer.setOutput(new PrintWriter(new File(publicDir, launcherName.substring(launcherName.lastIndexOf('.') + 1) + ".html")));
            serializer.startDocument("UTF-8", null);
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
            serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "\t");

            serializer.docdecl(" HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
            serializer.comment("The HTML 4.01 Transitional DOCTYPE declaration above " +
                    "set at the top of the file will set the browser's rendering engine " +
                    "into \"Quirks Mode\". Replacing this declaration with a \"Standards Mode\" doctype is supported, " +
                    "but may lead to some differences in layout.");
            serializer.startTag("", "html");
            serializer.startTag("", "head");

                serializer.startTag("","meta");
                serializer.attribute("", "http-equiv", "content-type");
                serializer.attribute("", "content", "text/html; charset=UTF-8");
                serializer.endTag("","meta");

                serializer.comment("This script loads your compiled module. " +
                        "If you add any GWT meta tags, they must " +
                        "be added before this line.");
                serializer.startTag("","script");
                serializer.attribute("", "type", "text/javascript");
                serializer.attribute("", "language", "javascript");
                serializer.attribute("", "src", launcherName + ".nocache.js");
                serializer.text("\n");
                serializer.endTag("","script");

                serializer.startTag("","title");
                i = 0;
                while(i < gmo.getAttributeDescriptors().size()
                    && !gmo.getAttributeDescriptors().get(i).getName().equals("title"))
                i++;
                serializer.text(i < gmo.getAttributeDescriptors().size() ?
                        gmo.getAttributeDescriptors().get(i).getValue() :
                        "My Application");
                serializer.endTag("","title");



            serializer.endTag("", "head");

            serializer.comment("The body can have arbitrary html, or " +
                    "you can leave the body empty if you want " +
                    "to create a completely dynamic UI.");
            serializer.startTag("", "body");

                serializer.comment("OPTIONAL: include this if you want history support");
                serializer.startTag("", "iframe");
                serializer.attribute("", "src", "javascript:''");
                serializer.attribute("", "id", "__gwt_historyFrame");
                serializer.attribute("", "tabIndex", "-1");
                serializer.attribute("", "style", "position:absolute;width:0;height:0;border:0");
                serializer.endTag("", "iframe");

            serializer.endTag("", "body");
            serializer.endTag("", "html");
            serializer.endDocument();

        }
        catch (XmlPullParserException ex) {
            log.error(ex);
        }
        catch (IOException ex) {
            log.error(ex);
        }
    }

    @Override
    public void saveFiles() {
        for (JavaFileGenerator gen : generators.keySet()) {
            gen.saveFile(generators.get(gen));
        }
    }

    @Override
    public List<Class> generateBindings(StringBuffer dbCreation, StringBuffer dbDeletion, TagHandler prevTh, JavaFile jf, Class clazz,
            String[] binding, int i, List<String> alreadyChecked, String methodToInvoke, Map<GuixGenerator, JavaFile> generatedFiles) {
        if(dbCreation == null || dbDeletion == null || binding == null || (jf == null && clazz ==null)
                || methodToInvoke == null || generatedFiles == null || i < 0) {
            return new ArrayList();
        }

        //does the attribute or method to bind exists ?
        boolean bindingExists = false;
        //the return type of the binding
        String returnType = null;
        //the getter method for the binding
        String getter = null;
        //the JavaFile to pass as an argument to the next call of this method
        JavaFile nextFile = null;
        //the Class to pass as an argument to the next call of this method
        Class nextClazz = null;
        //the TagHandler of this binding
        TagHandler th = null;
        //ProxyEventInfo model of this binding
        String model = null;
        //Listener to add to the bound object
        Class listener = null;
        //the name of the listener adding method
        String addMethod = null;
        //the name of the listener removing method
        String removeMethod = null;
        //the Listener list result
        List<Class> result = new ArrayList<Class>();

        String realMethodName = null;
        String realAttributename = null;

        if(Character.isUpperCase(binding[i].charAt(binding[i].lastIndexOf(".") + 1))) {
            try {
                Label.class.getClassLoader().loadClass(binding[i]);
            }
            catch (ClassNotFoundException eee) {
                try {
                    ClassLoader.getSystemClassLoader().loadClass(binding[i]);
                }
                catch (ClassNotFoundException eeee) {
                    return null;
                }
            }
            bindingExists = false;
        }
        else {
            //if the part of the binding is a method
            if (binding[i].endsWith(")")) {
                //the method name is all what is before the first open bracket
                realMethodName = binding[i].substring(0, binding[i].indexOf('('));
                //if the parent of the method has a TagHandler, then check that the method is the generic method name for all the libraries
                //or if it is the right name, and then determine the corresponding attribute
                if(prevTh != null) {
                    if(binding[i].startsWith("get")) {
                        realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf("(")));
                        if(realAttributename != null) {
                            realMethodName = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                        }
                    }
                    else if(binding[i].startsWith("is")){
                        realAttributename = prevTh.getAttrToGenerate(Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf("(")));
                        if(realAttributename != null) {
                            realMethodName = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1);
                        }
                    }
                }
                //if the method name is the real one, get the corresponding attribute name
                if(realAttributename == null) {
                    if(binding[i].startsWith("get")) {
                        realAttributename = Character.toLowerCase(binding[i].charAt(3)) + binding[i].substring(4, binding[i].indexOf('('));
                    }
                    else if(binding[i].startsWith("is")){
                        realAttributename = Character.toLowerCase(binding[i].charAt(2)) + binding[i].substring(3, binding[i].indexOf('('));
                    }
                    else {
                        realAttributename = binding[i].substring(0, binding[i].indexOf('('));
                    }
                }
                //if the parent of the method is an instance of a generated class
                if (jf != null) {
                    bindingExists = jf.getMethod(realMethodName, null) != null;
                    if (bindingExists) {
                        returnType = jf.getMethod(realMethodName, null).getReturnType();
                        JavaField f = jf.getField(realAttributename);
                        if (f != null) {
                            th = f.getTagHandler();
                        }
                    }
                }
                else {
                    try {
                        returnType = clazz.getMethod(realMethodName, (Class[])null).getReturnType().getName();
                        bindingExists = true;
                    }
                    catch (NoSuchMethodException eee) {
                        bindingExists = false;
                    }
                }
                getter = realMethodName + binding[i].substring(binding[i].indexOf('('));
            }
            //if the part of the binding is an attribute
            else {
                //if the parent of the attribute has a TagHandler, then check that the attribute is the generic attribute name for all the libraries
                //or if it is the right name
                if(prevTh != null) {
                    realAttributename = prevTh.getAttrToGenerate(binding[i]);
                }
                //if it is its real name
                if(realAttributename == null) {
                    realAttributename = binding[i];
                }
                //if the parent of the attribute is an instance of a generated class
                if (jf != null) {
                    bindingExists = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null || jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null;
                    if (bindingExists) {
                        returnType = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType()
                                : jf.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null).getReturnType();
                    }

                    getter = jf.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), null) != null ? "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()"
                            : "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";

                    JavaField f = jf.getField(realAttributename);
                    if (f != null) {
                        th = f.getTagHandler();
                    }
                }
                else {
                    try {
                        returnType = clazz.getMethod("get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), (Class[])null).getReturnType().getName();
                        getter = "get" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                        bindingExists = true;
                    }
                    catch (NoSuchMethodException eee) {
                        try {
                            returnType = clazz.getMethod("is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1), (Class[])null).getReturnType().getName();
                            getter = "is" + Character.toUpperCase(realAttributename.charAt(0)) + realAttributename.substring(1) + "()";
                            bindingExists = true;
                        }
                        catch (NoSuchMethodException eeee) {
                            bindingExists = false;
                        }
                    }
                }
            }
            //if the binding binds an existing attribute or method
            if (bindingExists) {
                //replace the value of the binding by the getter method
                binding[i] = getter;
                //if the parent has a taghandler
                if (prevTh != null) {
                    String getterWoBrackets = getter.substring(0, getter.indexOf('('));
                    //for GWT the only objects that can be bound are the ones which have got a TagHandler that defines methods which can be bound
                    if (prevTh.hasEventInfosAboutMethod(getterWoBrackets)) {
                        model = prevTh.getEventInfosModelName(getterWoBrackets);
                        listener = prevTh.getEventInfosListenerClass(getterWoBrackets);
                        addMethod = prevTh.getEventInfosAddListenerMethodName(getterWoBrackets);
                        removeMethod = prevTh.getEventInfosRemoveListenerMethodName(getterWoBrackets);
                    }
                }
                //get the class of the current token or its JavaFile
                try {
                    nextClazz = Label.class.getClassLoader().loadClass(returnType);                    
                }
                catch (ClassNotFoundException eee) {
                    try {
                        nextClazz = ClassLoader.getSystemClassLoader().loadClass(returnType);
                    }
                    catch (ClassNotFoundException eeee) {
                        for(JavaFile javaFile : generatedFiles.values()) {
                            if(returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) {
                                nextFile = javaFile;
                                break;
                            }
                        }
                        if(nextFile == null) {
                            for(JavaFile javaFile : propertyChangeListenerDependencies) {
                                if(returnType.equals(javaFile.getPackageName() + "." + javaFile.getClassName())) {
                                    nextFile = javaFile;
                                    break;
                                }
                            }
                        }
                    }
                }

                if(listener == null && clazz != null) {
                    try {
                        clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                        listener = PropertyChangeListener.class;
                        addMethod = "addPropertyChangeListener";
                        removeMethod = "removePropertyChangeListener";
                    }
                    catch(NoSuchMethodException eee) {
                    }
                }
                else if(listener == null && jf != null) {
                    for(JavaMethod method : jf.getAllMethods()) {
                        if(method.getName().equals("addPropertyChangeListener")
                                && ((method.getArguments().length == 1 && method.getArguments()[0].getType().equals("java.beans.PropertyChangeListener"))
                                ||(method.getArguments().length == 2 && method.getArguments()[1].getType().equals("java.beans.PropertyChangeListener")))) {
                            listener = PropertyChangeListener.class;
                            addMethod = "addPropertyChangeListener";
                            removeMethod = "removePropertyChangeListener";
                        }
                    }
                }

                boolean ifAdded = false;
                if(listener != null) {
                    if (alreadyChecked != null && !alreadyChecked.isEmpty()) {
                        ifAdded = true;
                        //starts to generate the code
                        dbCreation.append("if(");
                        dbDeletion.append("if(");
                        //add not null parent condition
                        for (int j = 0; j < alreadyChecked.size(); j++) {
                            dbCreation.append(alreadyChecked.get(0));
                            dbDeletion.append(alreadyChecked.get(0));
                            for (int k = 1; k <= j; k++) {
                                dbCreation.append(".").append(alreadyChecked.get(k));
                                dbDeletion.append(".").append(alreadyChecked.get(k));
                            }
                            dbCreation.append(" != null && ");
                            dbDeletion.append(" != null && ");
                        }

                        if (binding.length > alreadyChecked.size() + 1 && nextClazz != null && !nextClazz.isPrimitive()) {
                            for (int j = 0; j < alreadyChecked.size(); j++) {
                                dbCreation.append(alreadyChecked.get(j)).append(".");
                                dbDeletion.append(alreadyChecked.get(j)).append(".");
                            }
                            dbCreation.append(getter).append(" != null");
                            dbDeletion.append(getter).append(" != null");
                        }
                        else {
                            dbCreation.delete(dbCreation.length() - 4, dbCreation.length());
                            dbDeletion.delete(dbDeletion.length() - 4, dbDeletion.length());
                        }
                        dbCreation.append(") {\n");
                        dbDeletion.append(") {\n");
                    }
                    else if(nextClazz != null && !nextClazz.isPrimitive()) {
                        ifAdded = true;
                        dbCreation.append("if(").append(getter).append(" != null").append(") {\n");
                        dbDeletion.append("if(").append(getter).append(" != null").append(") {\n");
                    }

                    if (alreadyChecked != null) {
                        for (int j = 0; j < alreadyChecked.size(); j++) {
                            dbCreation.append(alreadyChecked.get(j)).append(".");
                            dbDeletion.append(alreadyChecked.get(j)).append(".");
                        }
                    }
                    if (model != null) {
                        dbCreation.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
                        dbDeletion.append("get").append(Character.toUpperCase(model.charAt(0))).append(model.substring(1)).append("()").append(".");
                    }

                    dbCreation.append(addMethod).append("(");
                    dbDeletion.append(removeMethod).append("(");
                    if(listener == PropertyChangeListener.class) {
                        dbCreation.append("\"").append(realAttributename).append("\", ");
                        dbDeletion.append("\"").append(realAttributename).append("\", ");
                    }
                    dbCreation.append("new ").append(listener.getName()).append("() {\n");
                    dbDeletion.append("new ").append(listener.getName()).append("() {\n");
                    for(Method m : listener.getMethods()) {
                        StringBuffer sb = new StringBuffer();
                        for(Annotation a : m.getDeclaredAnnotations()) {
                            dbCreation.append(a.toString()).append("\n");
                        }
                        //add the method that handles the event
                        sb.append("public ")
                                .append(m.getReturnType().getCanonicalName())
                                .append(" ")
                                .append(m.getName())
                                .append("(");
                        for(int n = 0 ; n < m.getParameterTypes().length ; n++) {
                            sb.append(m.getParameterTypes()[n].getCanonicalName())
                                    .append(" arg")
                                    .append(n)
                                    .append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length())
                                .append(")")
                                .append(" {\n")
                                .append("onChangeFrom").append(methodToInvoke)
                                .append("();\n}\n");
                        dbCreation.append(sb);
                        dbDeletion.append(sb);
                    }
                    dbCreation.append("});\n");
                    dbDeletion.append("});\n");
                    if(ifAdded) {
                        dbCreation.append("}\n");
                        dbDeletion.append("}\n");
                    }
                
                    if (alreadyChecked == null) {
                        alreadyChecked = new ArrayList<String>();
                    }
                    alreadyChecked.add(getter);
                    try {
                        //if it is not the last element of the binding
                        if(i + 1 < binding.length) {
                           result.addAll(generateBindings(dbCreation, dbDeletion, th, nextFile, nextClazz, binding, i+1, alreadyChecked, methodToInvoke, generatedFiles));
                        }
                        if(listener != null && !result.contains(listener)) {
                            result.add(listener);
                        }
                    }
                    catch(NullPointerException eee) {
                        log.error(i);
                        eee.printStackTrace();
                        return null;
                    }
                }
            }
            else if (log.isErrorEnabled()) {
                log.error("unable to bind " + binding[i]);
            }
        }
        return result;
    }
}
