/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongPeekingIterator;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.LookupFilter;
import org.neo4j.kernel.impl.api.PropertyLookup;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyAndNodeIndexedCheck
implements RecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    private final IndexAccessors indexes;
    private final PropertyReader propertyReader;
    private final CacheAccess cacheAccess;

    public PropertyAndNodeIndexedCheck(IndexAccessors indexes, PropertyReader propertyReader, CacheAccess cacheAccess) {
        this.indexes = indexes;
        this.propertyReader = propertyReader;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
        Collection<PropertyRecord> properties = this.propertyReader.getPropertyRecordChain(record);
        this.cacheAccess.client().putPropertiesToCache(properties);
        if (this.indexes != null) {
            this.checkIndexToLabels(record, engine, records, properties);
        }
        this.checkProperty(record, engine, properties);
    }

    private void checkIndexToLabels(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, Collection<PropertyRecord> propertyRecs) {
        Set<Long> labels = NodeLabelReader.getListOfLabels(record, records, engine);
        List<PropertyBlock> properties = null;
        for (IndexRule indexRule : this.indexes.rules()) {
            PropertyBlock property;
            if (!labels.contains(indexRule.getLabel())) continue;
            if (properties == null) {
                properties = this.propertyReader.propertyBlocks(propertyRecs);
            }
            if ((property = this.propertyWithKey(properties, indexRule.getPropertyKey())) == null) continue;
            IndexReader reader = this.indexes.accessorFor(indexRule).newReader();
            Throwable throwable = null;
            try {
                Object propertyValue = this.propertyReader.propertyValue(property).value();
                long nodeId = record.getId();
                if (indexRule.isConstraintIndex()) {
                    this.verifyNodeCorrectlyIndexedUniquely(nodeId, property.getKeyIndexId(), propertyValue, engine, indexRule, reader);
                    continue;
                }
                this.verifyNodeCorrectlyIndexed(nodeId, propertyValue, engine, indexRule, reader);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    private void verifyNodeCorrectlyIndexedUniquely(long nodeId, int propertyKeyId, Object propertyValue, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexRule indexRule, IndexReader reader) {
        PrimitiveLongIterator indexedNodeIds = reader.seek(propertyValue);
        indexedNodeIds = this.filterIfMultipleValuesFound(indexedNodeIds, propertyKeyId, propertyValue);
        boolean found = false;
        while (indexedNodeIds.hasNext()) {
            long indexedNodeId = indexedNodeIds.next();
            if (nodeId == indexedNodeId) {
                found = true;
                continue;
            }
            engine.report().uniqueIndexNotUnique(indexRule, propertyValue, indexedNodeId);
        }
        if (!found) {
            engine.report().notIndexed(indexRule, propertyValue);
        }
    }

    private PrimitiveLongIterator filterIfMultipleValuesFound(PrimitiveLongIterator indexedNodeIds, int propertyKeyId, Object propertyValue) {
        PrimitiveLongPeekingIterator filteredIndexedNodeIds = new PrimitiveLongPeekingIterator(indexedNodeIds);
        if (filteredIndexedNodeIds.hasMultipleValues()) {
            filteredIndexedNodeIds = LookupFilter.exactIndexMatches((PropertyLookup)this.propertyReader, (PrimitiveLongIterator)filteredIndexedNodeIds, (int)propertyKeyId, (Object)propertyValue);
        }
        return filteredIndexedNodeIds;
    }

    private void verifyNodeCorrectlyIndexed(long nodeId, Object propertyValue, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, IndexRule indexRule, IndexReader reader) {
        int count = reader.countIndexedNodes(nodeId, propertyValue);
        if (count == 0) {
            engine.report().notIndexed(indexRule, propertyValue);
        } else if (count != 1) {
            engine.report().indexedMultipleTimes(indexRule, propertyValue, count);
        }
    }

    private PropertyBlock propertyWithKey(List<PropertyBlock> propertyBlocks, int propertyKey) {
        for (PropertyBlock propertyBlock : propertyBlocks) {
            if (propertyBlock.getKeyIndexId() != propertyKey) continue;
            return propertyBlock;
        }
        return null;
    }

    private void checkProperty(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, Collection<PropertyRecord> props) {
        if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
            PropertyRecord firstProp = props.iterator().next();
            if (!Record.NO_PREVIOUS_PROPERTY.is(firstProp.getPrevProp())) {
                engine.report().propertyNotFirstInChain(firstProp);
            }
            PrimitiveIntSet keys = Primitive.intSet();
            for (PropertyRecord property : props) {
                if (!property.inUse()) {
                    engine.report().propertyNotInUse(property);
                    continue;
                }
                for (int key : ChainCheck.keys(property)) {
                    if (keys.add(key)) continue;
                    engine.report().propertyKeyNotUniqueInChain();
                }
            }
        }
    }
}

