/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Iterator;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.consistency.checking.ChainCheck;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyChain<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
implements RecordField<RECORD, REPORT>,
ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
    private final Function<RECORD, MandatoryProperties.Check<RECORD, REPORT>> mandatoryProperties;

    public PropertyChain(Function<RECORD, MandatoryProperties.Check<RECORD, REPORT>> mandatoryProperties) {
        this.mandatoryProperties = mandatoryProperties;
    }

    @Override
    public void checkConsistency(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
            Iterator<PropertyRecord> props = records.rawPropertyChain(record.getNextProp());
            PropertyRecord firstProp = props.next();
            if (!Record.NO_PREVIOUS_PROPERTY.is(firstProp.getPrevProp())) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotFirstInChain(firstProp);
            }
            try (PrimitiveIntSet keys = Primitive.intSet();
                 MandatoryProperties.Check mandatory = (MandatoryProperties.Check)this.mandatoryProperties.apply(record);){
                this.checkChainItem(firstProp, engine, keys, mandatory);
                while (props.hasNext()) {
                    this.checkChainItem(props.next(), engine, keys, mandatory);
                }
            }
        }
    }

    private void checkChainItem(PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, PrimitiveIntSet keys, MandatoryProperties.Check<RECORD, REPORT> mandatory) {
        if (!property.inUse()) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotInUse(property);
        } else {
            int[] keysInRecord = ChainCheck.keys(property);
            if (mandatory != null) {
                mandatory.receive(keysInRecord);
            }
            for (int key : keysInRecord) {
                if (keys.add(key)) continue;
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyKeyNotUniqueInChain();
            }
        }
    }

    @Override
    public long valueFrom(RECORD record) {
        return record.getNextProp();
    }

    @Override
    public void checkReference(RECORD record, PropertyRecord property, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!property.inUse()) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotInUse(property);
        } else {
            if (!Record.NO_PREVIOUS_PROPERTY.is(property.getPrevProp())) {
                ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).propertyNotFirstInChain(property);
            }
            new ChainCheck<RECORD, REPORT>().checkReference(record, property, engine, records);
        }
    }
}

