/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.context;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nd4j.common.io.ClassPathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextHolder {
    private Map<String, Integer> threadNameToDeviceNumber = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> threads = new ConcurrentHashMap<String, Integer>();
    private List<Integer> bannedDevices;
    private int numDevices = 0;
    private static ContextHolder INSTANCE;
    public static final String DEVICES_TO_BAN = "org.nd4j.linalg.jcuda.jcublas.ban_devices";
    private static AtomicBoolean deviceSetup;
    private boolean confCalled = false;
    private static Logger log;
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public static synchronized ContextHolder getInstance() {
        if (INSTANCE == null) {
            Properties props = new Properties();
            try {
                props.load(new ClassPathResource("/cudafunctions.properties", ContextHolder.class.getClassLoader()).getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            INSTANCE = new ContextHolder();
            INSTANCE.configure();
            for (String pair : props.stringPropertyNames()) {
                System.getProperties().put(pair, props.getProperty(pair));
            }
        }
        return INSTANCE;
    }

    public Map<String, Integer> getThreads() {
        return this.threads;
    }

    public int deviceNum() {
        return this.numDevices;
    }

    public void configure() {
        if (this.confCalled) {
            return;
        }
        this.confCalled = true;
    }

    public void setNumDevices(int numDevices) {
        this.numDevices = numDevices;
    }

    public int getDeviceForThread() {
        return 0;
    }

    public Map<String, Integer> getThreadNameToDeviceNumber() {
        return this.threadNameToDeviceNumber;
    }

    public List<Integer> getBannedDevices() {
        return this.bannedDevices;
    }

    public int getNumDevices() {
        return this.numDevices;
    }

    public boolean isConfCalled() {
        return this.confCalled;
    }

    public AtomicBoolean getShutdown() {
        return this.shutdown;
    }

    public void setThreadNameToDeviceNumber(Map<String, Integer> threadNameToDeviceNumber) {
        this.threadNameToDeviceNumber = threadNameToDeviceNumber;
    }

    public void setThreads(Map<String, Integer> threads) {
        this.threads = threads;
    }

    public void setBannedDevices(List<Integer> bannedDevices) {
        this.bannedDevices = bannedDevices;
    }

    public void setConfCalled(boolean confCalled) {
        this.confCalled = confCalled;
    }

    public void setShutdown(AtomicBoolean shutdown) {
        this.shutdown = shutdown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextHolder)) {
            return false;
        }
        ContextHolder other = (ContextHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumDevices() != other.getNumDevices()) {
            return false;
        }
        if (this.isConfCalled() != other.isConfCalled()) {
            return false;
        }
        Map<String, Integer> this$threadNameToDeviceNumber = this.getThreadNameToDeviceNumber();
        Map<String, Integer> other$threadNameToDeviceNumber = other.getThreadNameToDeviceNumber();
        if (this$threadNameToDeviceNumber == null ? other$threadNameToDeviceNumber != null : !((Object)this$threadNameToDeviceNumber).equals(other$threadNameToDeviceNumber)) {
            return false;
        }
        Map<String, Integer> this$threads = this.getThreads();
        Map<String, Integer> other$threads = other.getThreads();
        if (this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads)) {
            return false;
        }
        List<Integer> this$bannedDevices = this.getBannedDevices();
        List<Integer> other$bannedDevices = other.getBannedDevices();
        if (this$bannedDevices == null ? other$bannedDevices != null : !((Object)this$bannedDevices).equals(other$bannedDevices)) {
            return false;
        }
        AtomicBoolean this$shutdown = this.getShutdown();
        AtomicBoolean other$shutdown = other.getShutdown();
        return !(this$shutdown == null ? other$shutdown != null : !this$shutdown.equals(other$shutdown));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumDevices();
        result = result * 59 + (this.isConfCalled() ? 79 : 97);
        Map<String, Integer> $threadNameToDeviceNumber = this.getThreadNameToDeviceNumber();
        result = result * 59 + ($threadNameToDeviceNumber == null ? 43 : ((Object)$threadNameToDeviceNumber).hashCode());
        Map<String, Integer> $threads = this.getThreads();
        result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
        List<Integer> $bannedDevices = this.getBannedDevices();
        result = result * 59 + ($bannedDevices == null ? 43 : ((Object)$bannedDevices).hashCode());
        AtomicBoolean $shutdown = this.getShutdown();
        result = result * 59 + ($shutdown == null ? 43 : $shutdown.hashCode());
        return result;
    }

    public String toString() {
        return "ContextHolder(threadNameToDeviceNumber=" + this.getThreadNameToDeviceNumber() + ", threads=" + this.getThreads() + ", bannedDevices=" + this.getBannedDevices() + ", numDevices=" + this.getNumDevices() + ", confCalled=" + this.isConfCalled() + ", shutdown=" + this.getShutdown() + ")";
    }

    static {
        deviceSetup = new AtomicBoolean(false);
        log = LoggerFactory.getLogger(ContextHolder.class);
    }
}

