/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBBinary;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRef;
import com.mongodb.DBTimestamp;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ObjectId;
import com.mongodb.util.SimplePool;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ByteDecoder
extends Bytes {
    static final SimplePool<ByteDecoder> _pool = new SimplePool<ByteDecoder>("ByteDecoders", NUM_ENCODERS * 3, NUM_ENCODERS * 6){

        @Override
        protected ByteDecoder createNew() {
            if (Bytes.D) {
                System.out.println("creating new ByteDecoder");
            }
            return new ByteDecoder();
        }
    };
    private final byte[] _namebuf = new byte[4193280];
    ByteBuffer _buf;
    private final boolean _private;
    DB _base;
    DBCollection _collection;

    protected static ByteDecoder get(DB base, DBCollection coll) {
        ByteDecoder bd = _pool.get();
        bd.reset();
        bd._base = base;
        bd._collection = coll;
        return bd;
    }

    protected void done() {
        _pool.done(this);
    }

    public ByteDecoder(ByteBuffer buf) {
        this.reset(buf);
        this._private = false;
    }

    private ByteDecoder() {
        this._buf = ByteBuffer.wrap(new byte[0x800400]);
        this._private = true;
        this.reset();
    }

    public void reset(ByteBuffer buf) {
        if (this._private) {
            throw new IllegalStateException("can't reset private ByteDecoder");
        }
        this._buf = buf;
        if (this._buf.order() != Bytes.ORDER) {
            throw new IllegalArgumentException("byte order of passed in buffer is not correct");
        }
    }

    void reset() {
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._buf.order(Bytes.ORDER);
    }

    public DBObject readObject() {
        if (this._buf.position() >= this._buf.limit()) {
            return null;
        }
        int start = this._buf.position();
        int len = this._buf.getInt();
        DBObject created = this._create("");
        while (this.decodeNext(created, "") > 1) {
        }
        if (this._buf.position() - start != len) {
            throw new MongoInternalException("lengths don't match " + (this._buf.position() - start) + " != " + len);
        }
        return created;
    }

    private DBObject _create(String path) {
        Class c = null;
        if (this._collection != null && this._collection._objectClass != null) {
            c = path.length() == 0 ? this._collection._objectClass : this._collection.getInternalClass(path);
        }
        if (c != null) {
            try {
                return (DBObject)c.newInstance();
            }
            catch (InstantiationException ie) {
                LOGGER.log(Level.FINE, "can't create a: " + c, ie);
                throw new MongoInternalException("can't instantiate a : " + c, ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.log(Level.FINE, "can't create a: " + c, iae);
                throw new MongoInternalException("can't instantiate a : " + c, iae);
            }
        }
        return new BasicDBObject();
    }

    protected int decodeNext(DBObject o, String path) {
        int start = this._buf.position();
        byte type = this._buf.get();
        if (type == 0) {
            return 1;
        }
        String name = this.readCStr();
        path = path.length() == 0 ? name : path + "." + name;
        Object created = null;
        switch (type) {
            case 6: 
            case 10: {
                break;
            }
            case 8: {
                created = this._buf.get() > 0;
                break;
            }
            case 1: {
                created = this._buf.getDouble();
                break;
            }
            case 16: {
                created = this._buf.getInt();
                break;
            }
            case 18: {
                created = this._buf.getLong();
                break;
            }
            case 2: 
            case 14: {
                int size = this._buf.getInt() - 1;
                if (size > this._buf.remaining()) {
                    throw new MongoException("invalid bson? size:" + size + " remaining: " + this._buf.remaining());
                }
                this._buf.get(this._namebuf, 0, size);
                try {
                    created = new String(this._namebuf, 0, size, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new MongoInternalException("impossible", uee);
                }
                this._buf.get();
                break;
            }
            case 7: {
                created = new ObjectId(this._buf.getInt(), this._buf.getInt(), this._buf.getInt());
                break;
            }
            case 12: {
                this._buf.getInt();
                String ns = this.readCStr();
                ObjectId theOID = new ObjectId(this._buf.getInt(), this._buf.getInt(), this._buf.getInt());
                if (theOID.equals(Bytes.COLLECTION_REF_ID)) {
                    created = this._base.getCollectionFromFull(ns);
                    break;
                }
                created = new DBPointer(o, name, this._base, ns, theOID);
                break;
            }
            case 9: {
                created = new Date(this._buf.getLong());
                break;
            }
            case 11: {
                created = Pattern.compile(this.readCStr(), Bytes.patternFlags(this.readCStr()));
                break;
            }
            case 5: {
                created = this.parseBinary();
                break;
            }
            case 13: {
                throw new UnsupportedOperationException("can't handle CODE yet");
            }
            case 4: {
                created = new BasicDBList();
                this._buf.getInt();
                while (this.decodeNext((DBObject)created, path) > 1) {
                }
                break;
            }
            case 3: {
                this._buf.getInt();
                if (created == null) {
                    Object foo = o.get(name);
                    if (foo instanceof DBObject) {
                        created = (DBObject)foo;
                    }
                    if (created == null) {
                        created = this._create(path);
                    }
                }
                while (this.decodeNext((DBObject)created, path) > 1) {
                }
                DBObject theObject = (DBObject)created;
                if (!theObject.containsKey("$ref") || !theObject.containsKey("$id")) break;
                created = new DBRef(this._base, theObject.get("$ref").toString(), theObject.get("$id"));
                break;
            }
            case 17: {
                int i = this._buf.getInt();
                int time = this._buf.getInt();
                created = new DBTimestamp(time, i);
                break;
            }
            case -1: {
                created = "MinKey";
                break;
            }
            case 127: {
                created = "MaxKey";
                break;
            }
            default: {
                throw new UnsupportedOperationException("ByteDecoder can't handle type : " + type);
            }
        }
        o.put(name, Bytes.applyDecodingHooks(type, created));
        return this._buf.position() - start;
    }

    Object parseBinary() {
        int totalLen = this._buf.getInt();
        byte bType = this._buf.get();
        switch (bType) {
            case 2: {
                int len = this._buf.getInt();
                if (len + 4 != totalLen) {
                    throw new MongoInternalException("bad data size got subtype 2 len: " + len + " totalLen: " + totalLen);
                }
                if (D) {
                    System.out.println("got binary of size : " + len);
                }
                byte[] data = new byte[len];
                this._buf.get(data);
                return data;
            }
        }
        byte[] data = new byte[totalLen];
        this._buf.get(data);
        return new DBBinary(bType, data);
    }

    private String readCStr() {
        byte b;
        int pos = 0;
        while ((b = this._buf.get()) != 0) {
            this._namebuf[pos++] = b;
        }
        try {
            return new String(this._namebuf, 0, pos, "UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            throw new MongoInternalException("impossible");
        }
    }

    int getInt() {
        return this._buf.getInt();
    }

    long getLong() {
        return this._buf.getLong();
    }

    boolean more() {
        return this._buf.position() < this._buf.limit();
    }

    long remaining() {
        return this._buf.remaining();
    }

    void doneReading(int len) {
        this._buf.position(len);
        this._buf.flip();
    }
}

