/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.util.ClassUtil;

public class URIResourceLocator
implements ContainerResourceLocator {
    private static final Log logger = LogFactory.getLog(URIResourceLocator.class);
    public static String SCHEME_CLASSPATH = "classpath";
    public static final String BASE_URI_SYSKEY = "org.milyn.resource.baseuri";
    public static final URI DEFAULT_BASE_URI = URI.create("./");
    private URI baseURI = URIResourceLocator.getSystemBaseURI();

    public InputStream getResource(String configName, String defaultUri) throws IllegalArgumentException, IOException {
        return this.getResource(defaultUri);
    }

    public InputStream getResource(String uri) throws IllegalArgumentException, IOException {
        ResolvedURI resolvedURI = new ResolvedURI(uri, this.resolveURI(uri));
        return this.getResource(resolvedURI);
    }

    private InputStream getResource(ResolvedURI uri) throws IllegalArgumentException, IOException {
        InputStream stream;
        String scheme = uri.resolvedURI.getScheme();
        File fileUnresolved = new File(uri.inputURI);
        File fileResolved = null;
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append("\tFile System: " + fileUnresolved.getAbsolutePath() + "\n");
        if (scheme == null) {
            fileResolved = new File(uri.resolvedURI.getPath());
            errorBuilder.append("\tFile System: " + fileResolved.getAbsolutePath() + "\n");
        }
        boolean unresolvedExists = false;
        boolean resolvedExists = false;
        try {
            unresolvedExists = fileUnresolved.exists();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            resolvedExists = fileResolved.exists();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (unresolvedExists) {
            stream = new FileInputStream(fileUnresolved);
        } else if (fileResolved != null && resolvedExists) {
            stream = new FileInputStream(fileResolved);
        } else if (scheme == null || scheme.equals(SCHEME_CLASSPATH)) {
            String path = uri.resolvedURI.getPath();
            if (path == null || path.trim().equals("")) {
                throw new IllegalArgumentException("Unable to locate resource [" + uri + "].  Resource path not specified in URI.");
            }
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            errorBuilder.append("\tClasspath: " + path + "\n");
            stream = ClassUtil.getResourceAsStream(path, this.getClass());
        } else {
            URL url = uri.resolvedURI.toURL();
            URLConnection connection = url.openConnection();
            errorBuilder.append("\tURL: " + url + "\n");
            stream = connection.getInputStream();
        }
        if (stream == null) {
            throw new IOException("Failed to access data stream for resource [" + uri.inputURI + "]. Tried (in order):\n" + errorBuilder);
        }
        return stream;
    }

    public URI resolveURI(String uri) {
        if (uri == null || uri.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'uri' paramater in method call.");
        }
        if (uri.charAt(0) == '\\' || uri.charAt(0) == '/') {
            uri = uri.substring(1);
            return URI.create(uri);
        }
        URI uriObj = URI.create(uri);
        if (!uriObj.isAbsolute()) {
            uriObj = this.baseURI.resolve(uriObj);
        }
        return uriObj;
    }

    public void setBaseURI(URI baseURI) {
        if (baseURI == null) {
            throw new IllegalArgumentException("null 'baseURI' arg in method call.");
        }
        String baseURIString = baseURI.toString();
        char lastChar = baseURIString.charAt(baseURIString.length() - 1);
        this.baseURI = lastChar != '/' && lastChar != '\\' ? URI.create(baseURIString + '/') : baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public static URI getSystemBaseURI() {
        return URI.create(System.getProperty(BASE_URI_SYSKEY, "./"));
    }

    public static URI extractBaseURI(String resourceURI) {
        URI uri = URI.create(resourceURI);
        return URIResourceLocator.extractBaseURI(uri);
    }

    public static URI extractBaseURI(URI resourceURI) {
        File resFile = new File(resourceURI.getPath());
        try {
            File configFolder = resFile.getParentFile();
            if (configFolder != null) {
                return new URI(resourceURI.getScheme(), resourceURI.getUserInfo(), resourceURI.getHost(), resourceURI.getPort(), configFolder.getPath().replace('\\', '/'), resourceURI.getQuery(), resourceURI.getFragment());
            }
        }
        catch (URISyntaxException e) {
            logger.debug((Object)"Error extracting base URI.", (Throwable)e);
        }
        return DEFAULT_BASE_URI;
    }

    private static class ResolvedURI {
        private String inputURI;
        private URI resolvedURI;

        private ResolvedURI(String inputURI, URI resolvedURI) {
            this.inputURI = inputURI;
            this.resolvedURI = resolvedURI;
        }
    }
}

