/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.mapstruct.ap.internal.gem.ConditionGem;
import org.mapstruct.ap.internal.gem.ObjectFactoryGem;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.EnumMappingOptions;
import org.mapstruct.ap.internal.model.source.IterableMappingOptions;
import org.mapstruct.ap.internal.model.source.MapMappingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingMethodOptions;
import org.mapstruct.ap.internal.model.source.MappingMethodUtils;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.MethodMatcher;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SubclassMappingOptions;
import org.mapstruct.ap.internal.model.source.SubclassValidator;
import org.mapstruct.ap.internal.model.source.ValueMappingOptions;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.TypeUtils;

public class SourceMethod
implements Method {
    private final TypeUtils typeUtils;
    private final TypeFactory typeFactory;
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final List<Parameter> parameters;
    private final Parameter mappingTargetParameter;
    private final Parameter targetTypeParameter;
    private final boolean isObjectFactory;
    private final boolean isPresenceCheck;
    private final Type returnType;
    private final Accessibility accessibility;
    private final List<Type> exceptionTypes;
    private final MappingMethodOptions mappingMethodOptions;
    private final List<SourceMethod> prototypeMethods;
    private final Type mapperToImplement;
    private final List<Parameter> sourceParameters;
    private final List<Parameter> contextParameters;
    private final ParameterProvidedMethods contextProvidedMethods;
    private final List<Type> typeParameters;
    private List<String> parameterNames;
    private List<SourceMethod> applicablePrototypeMethods;
    private List<SourceMethod> applicableReversePrototypeMethods;
    private Boolean isValueMapping;
    private Boolean isIterableMapping;
    private Boolean isMapMapping;
    private Boolean isStreamMapping;
    private final boolean hasObjectFactoryAnnotation;
    private final boolean verboseLogging;

    private SourceMethod(Builder builder, MappingMethodOptions mappingMethodOptions) {
        this.declaringMapper = builder.declaringMapper;
        this.executable = builder.executable;
        this.parameters = builder.parameters;
        this.returnType = builder.returnType;
        this.exceptionTypes = builder.exceptionTypes;
        this.accessibility = Accessibility.fromModifiers(builder.executable.getModifiers());
        this.mappingMethodOptions = mappingMethodOptions;
        this.sourceParameters = Parameter.getSourceParameters(this.parameters);
        this.contextParameters = Parameter.getContextParameters(this.parameters);
        this.contextProvidedMethods = builder.contextProvidedMethods;
        this.typeParameters = builder.typeParameters;
        this.mappingTargetParameter = Parameter.getMappingTargetParameter(this.parameters);
        this.targetTypeParameter = Parameter.getTargetTypeParameter(this.parameters);
        this.hasObjectFactoryAnnotation = ObjectFactoryGem.instanceOn(this.executable) != null;
        this.isObjectFactory = this.determineIfIsObjectFactory();
        this.isPresenceCheck = this.determineIfIsPresenceCheck();
        this.typeUtils = builder.typeUtils;
        this.typeFactory = builder.typeFactory;
        this.prototypeMethods = builder.prototypeMethods;
        this.mapperToImplement = builder.definingType;
        this.verboseLogging = builder.verboseLogging;
    }

    private boolean determineIfIsObjectFactory() {
        boolean hasNoSourceParameters = this.getSourceParameters().isEmpty();
        boolean hasNoMappingTargetParam = this.getMappingTargetParameter() == null;
        return !this.isLifecycleCallbackMethod() && !this.returnType.isVoid() && hasNoMappingTargetParam && (this.hasObjectFactoryAnnotation || hasNoSourceParameters);
    }

    private boolean determineIfIsPresenceCheck() {
        if (this.returnType.isPrimitive() ? !this.returnType.getName().equals("boolean") : !this.returnType.getFullyQualifiedName().equals(Boolean.class.getCanonicalName())) {
            return false;
        }
        return ConditionGem.instanceOn(this.executable) != null;
    }

    @Override
    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    @Override
    public ExecutableElement getExecutable() {
        return this.executable;
    }

    @Override
    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    @Override
    public List<Parameter> getContextParameters() {
        return this.contextParameters;
    }

    @Override
    public ParameterProvidedMethods getContextProvidedMethods() {
        return this.contextProvidedMethods;
    }

    @Override
    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            ArrayList<String> names = new ArrayList<String>(this.parameters.size());
            for (Parameter parameter : this.parameters) {
                names.add(parameter.getName());
            }
            this.parameterNames = java.util.Collections.unmodifiableList(names);
        }
        return this.parameterNames;
    }

    @Override
    public Type getResultType() {
        return this.mappingTargetParameter != null ? this.mappingTargetParameter.getType() : this.returnType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public boolean inverses(SourceMethod method) {
        return method.getDeclaringMapper() == null && method.isAbstract() && this.getSourceParameters().size() == 1 && method.getSourceParameters().size() == 1 && this.getMappingSourceType().isAssignableTo(method.getResultType()) && this.getResultType().isAssignableTo(Collections.first(method.getSourceParameters()).getType());
    }

    public boolean canInheritFrom(SourceMethod method) {
        return method.getDeclaringMapper() == null && method.isAbstract() && this.isMapMapping() == method.isMapMapping() && this.isIterableMapping() == method.isIterableMapping() && MappingMethodUtils.isEnumMapping(this) == MappingMethodUtils.isEnumMapping(method) && this.getResultType().isAssignableTo(method.getResultType()) && SourceMethod.allParametersAreAssignable(this.getSourceParameters(), method.getSourceParameters());
    }

    @Override
    public Parameter getMappingTargetParameter() {
        return this.mappingTargetParameter;
    }

    @Override
    public boolean isObjectFactory() {
        return this.isObjectFactory;
    }

    @Override
    public Parameter getTargetTypeParameter() {
        return this.targetTypeParameter;
    }

    public boolean isIterableMapping() {
        if (this.isIterableMapping == null) {
            this.isIterableMapping = this.getSourceParameters().size() == 1 && this.getMappingSourceType().isIterableType() && this.getResultType().isIterableType();
        }
        return this.isIterableMapping;
    }

    public boolean isStreamMapping() {
        if (this.isStreamMapping == null) {
            this.isStreamMapping = this.getSourceParameters().size() == 1 && (this.getMappingSourceType().isIterableType() && this.getResultType().isStreamType() || this.getMappingSourceType().isStreamType() && this.getResultType().isIterableType() || this.getMappingSourceType().isStreamType() && this.getResultType().isStreamType());
        }
        return this.isStreamMapping;
    }

    public boolean isMapMapping() {
        if (this.isMapMapping == null) {
            this.isMapMapping = this.getSourceParameters().size() == 1 && this.getMappingSourceType().isMapType() && this.getResultType().isMapType();
        }
        return this.isMapMapping;
    }

    public boolean isRemovedEnumMapping() {
        return MappingMethodUtils.isEnumMapping(this);
    }

    public boolean isValueMapping() {
        if (this.isValueMapping == null) {
            this.isValueMapping = MappingMethodUtils.isEnumMapping(this) && this.mappingMethodOptions.getMappings().isEmpty();
        }
        return this.isValueMapping;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.returnType.toString());
        sb.append(" ");
        if (this.declaringMapper != null) {
            sb.append(this.declaringMapper).append(".");
        }
        sb.append(this.getName()).append("(").append(Strings.join(this.parameters, ", ")).append(")");
        return sb.toString();
    }

    public List<SourceMethod> getApplicablePrototypeMethods() {
        if (this.applicablePrototypeMethods == null) {
            this.applicablePrototypeMethods = new ArrayList<SourceMethod>();
            for (SourceMethod prototype : this.prototypeMethods) {
                if (!this.canInheritFrom(prototype)) continue;
                this.applicablePrototypeMethods.add(prototype);
            }
        }
        return this.applicablePrototypeMethods;
    }

    public List<SourceMethod> getApplicableReversePrototypeMethods() {
        if (this.applicableReversePrototypeMethods == null) {
            this.applicableReversePrototypeMethods = new ArrayList<SourceMethod>();
            for (SourceMethod prototype : this.prototypeMethods) {
                if (!this.inverses(prototype)) continue;
                this.applicableReversePrototypeMethods.add(prototype);
            }
        }
        return this.applicableReversePrototypeMethods;
    }

    private static boolean allParametersAreAssignable(List<Parameter> fromParams, List<Parameter> toParams) {
        if (fromParams.size() == toParams.size()) {
            HashSet<Parameter> unaccountedToParams = new HashSet<Parameter>(toParams);
            for (Parameter fromParam : fromParams) {
                boolean hasMatch = false;
                for (Parameter toParam : toParams) {
                    if (!fromParam.getType().isAssignableTo(toParam.getType())) continue;
                    unaccountedToParams.remove(toParam);
                    hasMatch = true;
                }
                if (hasMatch) continue;
                return false;
            }
            return unaccountedToParams.isEmpty();
        }
        return false;
    }

    @Override
    public boolean overridesMethod() {
        return this.declaringMapper == null && this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean matches(List<Type> sourceTypes, Type targetType) {
        MethodMatcher matcher = new MethodMatcher(this.typeUtils, this.typeFactory, this);
        return matcher.matches(sourceTypes, targetType);
    }

    public static boolean containsTargetTypeParameter(List<Parameter> parameters) {
        return parameters.stream().anyMatch(Parameter::isTargetType);
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.exceptionTypes;
    }

    @Override
    public MappingMethodOptions getOptions() {
        return this.mappingMethodOptions;
    }

    @Override
    public boolean isStatic() {
        return this.executable.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isDefault() {
        return Executables.isDefaultMethod(this.executable);
    }

    @Override
    public Type getDefiningType() {
        return this.mapperToImplement;
    }

    @Override
    public boolean isLifecycleCallbackMethod() {
        return Executables.isLifecycleCallbackMethod(this.getExecutable());
    }

    @Override
    public boolean isPresenceCheck() {
        return this.isPresenceCheck;
    }

    public boolean isAfterMappingMethod() {
        return Executables.isAfterMappingMethod(this.getExecutable());
    }

    public boolean isBeforeMappingMethod() {
        return Executables.isBeforeMappingMethod(this.getExecutable());
    }

    public boolean isAbstract() {
        return this.executable.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public boolean isUpdateMethod() {
        return this.getMappingTargetParameter() != null;
    }

    public boolean hasObjectFactoryAnnotation() {
        return this.hasObjectFactoryAnnotation;
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public String describe() {
        if (this.verboseLogging) {
            return this.toString();
        }
        String mapper = this.declaringMapper != null ? this.declaringMapper.getName() + "." : "";
        String sourceTypes = this.getParameters().stream().map(Parameter::describe).collect(Collectors.joining(", "));
        return this.getResultType().describe() + " " + mapper + this.getName() + "(" + sourceTypes + ")";
    }

    public static class Builder {
        private Type declaringMapper = null;
        private Type definingType = null;
        private ExecutableElement executable;
        private List<Parameter> parameters;
        private Type returnType = null;
        private List<Type> exceptionTypes;
        private Set<MappingOptions> mappings;
        private IterableMappingOptions iterableMapping = null;
        private MapMappingOptions mapMapping = null;
        private BeanMappingOptions beanMapping = null;
        private TypeUtils typeUtils;
        private TypeFactory typeFactory = null;
        private MapperOptions mapper = null;
        private List<SourceMethod> prototypeMethods = java.util.Collections.emptyList();
        private List<ValueMappingOptions> valueMappings;
        private EnumMappingOptions enumMappingOptions;
        private ParameterProvidedMethods contextProvidedMethods;
        private List<Type> typeParameters;
        private Set<SubclassMappingOptions> subclassMappings;
        private boolean verboseLogging;
        private SubclassValidator subclassValidator;

        public Builder setDeclaringMapper(Type declaringMapper) {
            this.declaringMapper = declaringMapper;
            return this;
        }

        public Builder setExecutable(ExecutableElement executable) {
            this.executable = executable;
            return this;
        }

        public Builder setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setReturnType(Type returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder setExceptionTypes(List<Type> exceptionTypes) {
            this.exceptionTypes = exceptionTypes;
            return this;
        }

        public Builder setMappingOptions(Set<MappingOptions> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setIterableMappingOptions(IterableMappingOptions iterableMapping) {
            this.iterableMapping = iterableMapping;
            return this;
        }

        public Builder setMapMappingOptions(MapMappingOptions mapMapping) {
            this.mapMapping = mapMapping;
            return this;
        }

        public Builder setBeanMappingOptions(BeanMappingOptions beanMapping) {
            this.beanMapping = beanMapping;
            return this;
        }

        public Builder setValueMappingOptionss(List<ValueMappingOptions> valueMappings) {
            this.valueMappings = valueMappings;
            return this;
        }

        public Builder setEnumMappingOptions(EnumMappingOptions enumMappingOptions) {
            this.enumMappingOptions = enumMappingOptions;
            return this;
        }

        public Builder setSubclassMappings(Set<SubclassMappingOptions> subclassMappings) {
            this.subclassMappings = subclassMappings;
            return this;
        }

        public Builder setSubclassValidator(SubclassValidator subclassValidator) {
            this.subclassValidator = subclassValidator;
            return this;
        }

        public Builder setTypeUtils(TypeUtils typeUtils) {
            this.typeUtils = typeUtils;
            return this;
        }

        public Builder setTypeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder setMapper(MapperOptions mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setPrototypeMethods(List<SourceMethod> prototypeMethods) {
            this.prototypeMethods = prototypeMethods;
            return this;
        }

        public Builder setDefininingType(Type definingType) {
            this.definingType = definingType;
            return this;
        }

        public Builder setContextProvidedMethods(ParameterProvidedMethods contextProvidedMethods) {
            this.contextProvidedMethods = contextProvidedMethods;
            return this;
        }

        public Builder setVerboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public SourceMethod build() {
            if (this.mappings == null) {
                this.mappings = java.util.Collections.emptySet();
            }
            if (this.subclassMappings == null) {
                this.subclassMappings = java.util.Collections.emptySet();
            }
            MappingMethodOptions mappingMethodOptions = new MappingMethodOptions(this.mapper, this.mappings, this.iterableMapping, this.mapMapping, this.beanMapping, this.enumMappingOptions, this.valueMappings, this.subclassMappings, this.subclassValidator);
            this.typeParameters = this.executable.getTypeParameters().stream().map(Element::asType).map(this.typeFactory::getType).collect(Collectors.toList());
            return new SourceMethod(this, mappingMethodOptions);
        }
    }
}

