/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.keycloak.provider.ProviderConfigProperty;

public enum SigningProperties {
    ISSUER_DID("issuerDid", "Did of the issuer.", "Provide the DID of the issuer. Needs to match the provided key material.", "String", null),
    KEY_ID("keyId", "Id of the signing key.", "The id of the key to be used for signing credentials. The key needs to be provided as a realm key.", "String", null),
    KID_HEADER("kidHeader", "Kid to be set for the JWT.", "The kid to be set in the jwt-header. Depending on the did-schema, the pure key-id might not be enough and can be overwritten here.", "String", null),
    PROOF_TYPE("proofType", "Type of the LD-Proof.", "The type of LD-Proofs to be created. Needs to fit the provided signing key.", "String", null),
    ALGORITHM_TYPE("algorithmType", "Type of the signing algorithm.", "The type of the algorithm to be used for signing. Needs to fit the provided signing key.", "String", "RS256"),
    TOKEN_TYPE("tokenType", "Type of the token.", "The type of the token to be created.  Will be used as `typ` claim in the JWT-Header.", "String", "JWT"),
    DECOYS("decoys", "Number of decoys to be added.", "The number of decoys to be added to the SD-JWT.", "String", 0),
    HASH_ALGORITHM("hashAlgorithm", "Hash algorithm for SD-JWTs.", "The hash algorithm to be used for the SD-JWTs.", "String", "sha-256"),
    VISIBLE_CLAIMS("visibleClaims", "Visible claims of the SD-JWT.", "List of claims to stay disclosed in the SD-JWT.", "MultivaluedString", null),
    VC_CONFIG_ID("vcConfigId", "Credential configuration identifier", "The identifier of this credential configuration", "String", null),
    VC_VCT("vct", "Credential Type", "The type of this credential", "String", null);

    private final String key;
    private final String label;
    private final String helpText;
    private final String type;
    private final Object defaultValue;

    private SigningProperties(String key, String label, String helpText, String type, Object defaultValue) {
        this.key = key;
        this.label = label;
        this.helpText = helpText;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public ProviderConfigProperty asConfigProperty() {
        return new ProviderConfigProperty(this.key, this.label, this.helpText, this.type, this.defaultValue);
    }

    public String getKey() {
        return this.key;
    }
}

