/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.FileUtils;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jvnet.jaxb2.maven2.AbstractXJC2Mojo;
import org.jvnet.jaxb2.maven2.LoggingCodeWriter;
import org.jvnet.jaxb2.maven2.LoggingErrorReceiver;
import org.jvnet.jaxb2.maven2.ParentFirstClassLoader;
import org.jvnet.jaxb2.maven2.util.ArtifactUtils;
import org.jvnet.jaxb2.maven2.util.CollectionUtils;
import org.jvnet.jaxb2.maven2.util.IOUtils;
import org.jvnet.jaxb2.maven2.util.StringUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="generate")
@MojoPhase(value="generate-sources")
public class RawXJC2Mojo
extends AbstractXJC2Mojo {
    private Collection<Artifact> xjcPluginArtifacts;
    private Collection<File> xjcPluginFiles;
    private Collection<URL> xjcPluginURLs;
    private Collection<Artifact> episodeArtifacts;
    private Collection<File> episodeFiles;
    private List<File> schemaFiles;
    private List<File> bindingFiles;
    private List<File> dependsFiles;
    private List<File> producesFiles;

    public Collection<Artifact> getXjcPluginArtifacts() {
        return this.xjcPluginArtifacts;
    }

    public Collection<File> getXjcPluginFiles() {
        return this.xjcPluginFiles;
    }

    public Collection<URL> getXjcPluginURLs() {
        return this.xjcPluginURLs;
    }

    public Collection<Artifact> getEpisodeArtifacts() {
        return this.episodeArtifacts;
    }

    public Collection<File> getEpisodeFiles() {
        return this.episodeFiles;
    }

    public List<File> getSchemaFiles() {
        return this.schemaFiles;
    }

    public List<File> getBindingFiles() {
        return this.bindingFiles;
    }

    public List<File> getDependsFiles() {
        return this.dependsFiles;
    }

    public List<File> getProducesFiles() {
        return this.producesFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.injectDependencyDefaults();
        this.resolveArtifacts();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.createClassLoader(currentClassLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.doExecute();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected void injectDependencyDefaults() {
        this.injectDependencyDefaults(this.getPlugins());
        this.injectDependencyDefaults(this.getEpisodes());
    }

    protected void injectDependencyDefaults(Dependency[] dependencies) {
        if (dependencies != null) {
            TreeMap<String, Dependency> dependencyMap = new TreeMap<String, Dependency>();
            for (Dependency dependency : dependencies) {
                dependencyMap.put(dependency.getManagementKey(), dependency);
            }
            DependencyManagement dependencyManagement = this.getProject().getDependencyManagement();
            if (dependencyManagement != null) {
                this.merge(dependencyMap, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null) {
                this.merge(dependencyMap, this.getProject().getDependencies());
            }
        }
    }

    private void merge(Map<String, Dependency> dependencyMap, List<Dependency> managedDependencies) {
        for (Dependency managedDependency : managedDependencies) {
            String key = managedDependency.getManagementKey();
            Dependency dependency = dependencyMap.get(key);
            if (dependency == null) continue;
            ArtifactUtils.mergeDependencyWithDefaults(dependency, managedDependency);
        }
    }

    protected void resolveArtifacts() throws MojoExecutionException {
        try {
            this.resolveXJCPluginArtifacts();
            this.resolveEpisodeArtifacts();
        }
        catch (ArtifactResolutionException arex) {
            throw new MojoExecutionException("Could not resolve the artifact.", (Exception)((Object)arex));
        }
        catch (ArtifactNotFoundException anfex) {
            throw new MojoExecutionException("Artifact not found.", (Exception)((Object)anfex));
        }
        catch (InvalidDependencyVersionException idvex) {
            throw new MojoExecutionException("Invalid dependency version.", (Exception)((Object)idvex));
        }
    }

    protected void resolveXJCPluginArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.xjcPluginArtifacts = ArtifactUtils.resolveTransitively(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getPlugins(), this.getProject());
        this.xjcPluginFiles = ArtifactUtils.getFiles(this.xjcPluginArtifacts);
        this.xjcPluginURLs = CollectionUtils.apply(this.xjcPluginFiles, IOUtils.GET_URL);
    }

    protected void resolveEpisodeArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        this.episodeArtifacts = ArtifactUtils.resolve(this.getArtifactFactory(), this.getArtifactResolver(), this.getLocalRepository(), this.getArtifactMetadataSource(), this.getEpisodes(), this.getProject());
        this.episodeFiles = ArtifactUtils.getFiles(this.episodeArtifacts);
    }

    protected ClassLoader createClassLoader(ClassLoader parent) throws MojoExecutionException {
        Collection<URL> xjcPluginURLs = this.getXjcPluginURLs();
        return new ParentFirstClassLoader(xjcPluginURLs.toArray(new URL[xjcPluginURLs.size()]), parent);
    }

    protected void doExecute() throws MojoExecutionException {
        this.setupLogging();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Started execution.");
        }
        this.setupMavenPaths();
        this.setupDirectories();
        this.setupFiles();
        if (this.getVerbose()) {
            this.logConfiguration();
        }
        Options options = this.setupOptions();
        if (!this.getForceRegenerate() && this.isUpToDate()) {
            this.getLog().info((CharSequence)"Skipped XJC execution.  Generated sources were up-to-date.");
            return;
        }
        Model model = this.loadModel(options);
        Outline outline = this.generateCode(model);
        this.writeCode(outline);
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Finished execution.");
        }
    }

    protected void setupLogging() {
        this.setVerbose(this.getVerbose() || this.getLog().isDebugEnabled());
        if (this.getVerbose()) {
            System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        }
    }

    protected void setupMavenPaths() {
        String generatedDirectoryPath;
        String episodeFilePath;
        this.getProject().addCompileSourceRoot(this.getGenerateDirectory().getPath());
        Resource generatedResource = new Resource();
        generatedResource.setDirectory(this.getGenerateDirectory().getPath());
        generatedResource.addInclude("**/jaxb.properties");
        generatedResource.addInclude("**/bgm.ser");
        this.getProject().addResource(generatedResource);
        if (this.getEpisode() && this.getEpisodeFile() != null && (episodeFilePath = this.getEpisodeFile().getAbsolutePath()).startsWith((generatedDirectoryPath = this.getGenerateDirectory().getAbsolutePath()) + File.separator)) {
            String path = episodeFilePath.substring(generatedDirectoryPath.length() + 1);
            Resource resource = new Resource();
            resource.setDirectory(generatedDirectoryPath);
            resource.addInclude(path);
            this.getProject().addResource(resource);
        }
    }

    protected void setupDirectories() {
        File generateDirectory = this.getGenerateDirectory();
        if (this.getRemoveOldOutput() && generateDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.getGenerateDirectory());
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)("Failed to remove old generateDirectory [" + generateDirectory + "]."), (Throwable)ex);
            }
        }
        if (generateDirectory != null && !generateDirectory.exists()) {
            generateDirectory.mkdirs();
        }
        File episodeFile = this.getEpisodeFile();
        if (this.getEpisode() && episodeFile != null) {
            File parentFile = episodeFile.getParentFile();
            parentFile.mkdirs();
        }
    }

    protected void setupFiles() throws MojoExecutionException {
        this.setupSchemaFiles();
        this.setupBindingFiles();
        this.setupDependsFiles();
        this.setupProducesFiles();
    }

    protected void setupSchemaFiles() throws MojoExecutionException {
        try {
            this.schemaFiles = IOUtils.scanDirectoryForFiles(this.getSchemaDirectory(), this.getSchemaIncludes(), this.getSchemaExcludes(), !this.getDisableDefaultExcludes());
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup schema files.", (Exception)ioex);
        }
    }

    protected void setupBindingFiles() throws MojoExecutionException {
        try {
            this.bindingFiles = IOUtils.scanDirectoryForFiles(this.getBindingDirectory(), this.getBindingIncludes(), this.getBindingExcludes(), !this.getDisableDefaultExcludes());
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup schema files.", (Exception)ioex);
        }
    }

    protected void setupDependsFiles() {
        ArrayList<File> dependsFiles = new ArrayList<File>();
        dependsFiles.addAll(this.getSchemaFiles());
        dependsFiles.addAll(this.getBindingFiles());
        File catalog = this.getCatalog();
        if (catalog != null) {
            dependsFiles.add(catalog);
        }
        dependsFiles.add(this.getProject().getFile());
        if (this.getOtherDepends() != null) {
            dependsFiles.addAll(Arrays.asList(this.getOtherDepends()));
        }
        this.dependsFiles = dependsFiles;
    }

    protected void setupProducesFiles() throws MojoExecutionException {
        try {
            this.producesFiles = IOUtils.scanDirectoryForFiles(this.getGenerateDirectory(), new String[]{"**/*.*", "**/*.java", "**/bgm.ser", "**/jaxb.properties"}, new String[]{}, !this.getDisableDefaultExcludes());
        }
        catch (IOException ioex) {
            throw new MojoExecutionException("Could not setup produced files.", (Exception)ioex);
        }
    }

    @Override
    protected void logConfiguration() throws MojoExecutionException {
        super.logConfiguration();
        this.getLog().info((CharSequence)("schemaFiles (calculated):" + this.getSchemaFiles()));
        this.getLog().info((CharSequence)("bindingFiles (calculated):" + this.getBindingFiles()));
        this.getLog().info((CharSequence)("xjcPluginArtifacts (resolved):" + this.getXjcPluginArtifacts()));
        this.getLog().info((CharSequence)("xjcPluginFiles (resolved):" + this.getXjcPluginFiles()));
        this.getLog().info((CharSequence)("xjcPluginURLs (resolved):" + this.getXjcPluginURLs()));
        this.getLog().info((CharSequence)("episodeArtifacts (resolved):" + this.getEpisodeArtifacts()));
        this.getLog().info((CharSequence)("episodeFiles (resolved):" + this.getEpisodeArtifacts()));
    }

    protected Options setupOptions() throws MojoExecutionException {
        File catalog;
        Options options = new Options();
        options.verbose = this.getVerbose();
        options.classpaths.addAll(this.getXjcPluginURLs());
        options.debugMode = this.getDebug();
        SpecVersion specVersion = SpecVersion.parse((String)this.getSpecVersion());
        options.target = specVersion == null ? SpecVersion.LATEST : specVersion;
        Language schemaLanguage = this.getLanguage();
        if (schemaLanguage != null) {
            options.setSchemaLanguage(schemaLanguage);
        }
        for (InputSource grammar : this.getGrammars()) {
            options.addGrammar(grammar);
        }
        for (InputSource bindFile : this.getBindFiles()) {
            options.addBindFile(bindFile);
        }
        CatalogResolver catalogResolver = this.getCatalogResolverInstance();
        if (catalogResolver != null) {
            options.entityResolver = catalogResolver;
        }
        if ((catalog = this.getCatalog()) != null) {
            try {
                if (options.entityResolver == null) {
                    CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
                    options.entityResolver = new CatalogResolver(true);
                }
                URL catalogURL = catalog.toURI().toURL();
                ((CatalogResolver)options.entityResolver).getCatalog().parseCatalog(catalogURL);
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Error while setting the catalog to [" + catalog.getAbsolutePath() + "].", (Exception)ioex);
            }
        }
        options.defaultPackage = this.getGeneratePackage();
        options.targetDir = this.getGenerateDirectory();
        options.strictCheck = this.getStrict();
        options.readOnly = this.getReadOnly();
        if (this.getExtension()) {
            options.compatibilityMode = 2;
        }
        String[] arguments = this.getArguments();
        try {
            options.parseArguments(arguments);
        }
        catch (BadCommandLineException bclex) {
            throw new MojoExecutionException("Error parsing the command line [" + arguments + "]", (Exception)((Object)bclex));
        }
        return options;
    }

    protected Language getLanguage() throws MojoExecutionException {
        String schemaLanguage = this.getSchemaLanguage();
        if (StringUtils.isEmpty(schemaLanguage)) {
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)"The schemaLanguage setting was not defined, assuming 'AUTODETECT'.");
            }
            return null;
        }
        if ("AUTODETECT".equalsIgnoreCase(schemaLanguage)) {
            return null;
        }
        if ("XMLSCHEMA".equalsIgnoreCase(schemaLanguage)) {
            return Language.XMLSCHEMA;
        }
        if ("DTD".equalsIgnoreCase(schemaLanguage)) {
            return Language.DTD;
        }
        if ("RELAXNG".equalsIgnoreCase(schemaLanguage)) {
            return Language.RELAXNG;
        }
        if ("RELAXNG_COMPACT".equalsIgnoreCase(schemaLanguage)) {
            return Language.RELAXNG_COMPACT;
        }
        if ("WSDL".equalsIgnoreCase(schemaLanguage)) {
            return Language.WSDL;
        }
        throw new MojoExecutionException("Unknown schemaLanguage [" + schemaLanguage + "]");
    }

    protected List<InputSource> getGrammars() throws MojoExecutionException {
        List<File> schemaFiles = this.getSchemaFiles();
        ArrayList<InputSource> grammars = new ArrayList<InputSource>(schemaFiles.size());
        for (File schemaFile : schemaFiles) {
            grammars.add(IOUtils.getInputSource(schemaFile));
        }
        return grammars;
    }

    protected List<InputSource> getBindFiles() throws MojoExecutionException {
        List<File> bindingFiles = this.getBindingFiles();
        ArrayList<InputSource> bindFiles = new ArrayList<InputSource>(bindingFiles.size());
        for (File bindingFile : bindingFiles) {
            bindFiles.add(IOUtils.getInputSource(bindingFile));
        }
        return bindFiles;
    }

    protected CatalogResolver getCatalogResolverInstance() throws MojoExecutionException {
        if (this.getCatalogResolver() == null) {
            return null;
        }
        try {
            String catalogResolverClassName = this.getCatalogResolver().trim();
            Class<?> draftCatalogResolverClass = Thread.currentThread().getContextClassLoader().loadClass(catalogResolverClassName);
            if (!CatalogResolver.class.isAssignableFrom(draftCatalogResolverClass)) {
                throw new MojoExecutionException("Specified catalog resolver class [" + this.catalogResolver + "] could not be casted to [" + CatalogResolver.class + "].");
            }
            Class<?> catalogResolverClass = draftCatalogResolverClass;
            CatalogResolver catalogResolverInstance = (CatalogResolver)catalogResolverClass.newInstance();
            return catalogResolverInstance;
        }
        catch (ClassNotFoundException cnfex) {
            throw new MojoExecutionException("Could not find specified catalog resolver class [" + this.catalogResolver + "].", (Exception)cnfex);
        }
        catch (InstantiationException iex) {
            throw new MojoExecutionException("Could not instantiate catalog resolver class [" + this.catalogResolver + "].", (Exception)iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MojoExecutionException("Could not instantiate catalog resolver class [" + this.catalogResolver + "].", (Exception)iaex);
        }
    }

    protected boolean isUpToDate() throws MojoExecutionException {
        List<File> dependsFiles = this.getDependsFiles();
        List<File> producesFiles = this.getProducesFiles();
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("Checking up-to-date depends [" + dependsFiles + "]."));
        }
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("Checking up-to-date produces [" + producesFiles + "]."));
        }
        Long dependsTimestamp = CollectionUtils.bestValue(dependsFiles, IOUtils.LAST_MODIFIED, CollectionUtils.gt());
        Long producesTimestamp = CollectionUtils.bestValue(producesFiles, IOUtils.LAST_MODIFIED, CollectionUtils.lt());
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)("Depends timestamp [" + dependsTimestamp + "], produces timestamp [" + producesTimestamp + "]."));
        }
        return producesTimestamp != null && CollectionUtils.lt().compare(dependsTimestamp, producesTimestamp) > 0;
    }

    protected Model loadModel(Options options) throws MojoExecutionException {
        Model model;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Parsing input schema(s)...");
        }
        if ((model = ModelLoader.load((Options)options, (JCodeModel)new JCodeModel(), (ErrorReceiver)new LoggingErrorReceiver("Error while parsing schema(s).", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Unable to parse input schema(s). Error messages should have been provided.");
        }
        return model;
    }

    protected Outline generateCode(Model model) throws MojoExecutionException {
        Outline outline;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Compiling input schema(s)...");
        }
        if ((outline = model.generateCode(model.options, (ErrorReceiver)new LoggingErrorReceiver("Error while generating code.", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Failed to compile input schema(s)!  Error messages should have been provided.");
        }
        return outline;
    }

    protected void writeCode(Outline outline) throws MojoExecutionException {
        if (this.getWriteCode()) {
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)("Writing output to [" + outline.getModel().options.targetDir.getAbsolutePath() + "]."));
            }
            try {
                LoggingCodeWriter codeWriter = new LoggingCodeWriter(outline.getModel().options.createCodeWriter(), this.getLog(), this.getVerbose());
                outline.getModel().codeModel.build((CodeWriter)codeWriter);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Code will not be written.");
        }
    }

    protected String[] getArguments() throws MojoExecutionException {
        ArrayList<String> arguments = new ArrayList<String>(this.getArgs());
        if (this.getEpisode() && this.getEpisodeFile() != null) {
            arguments.add("-episode");
            arguments.add(this.getEpisodeFile().getAbsolutePath());
        }
        for (File episodeFile : this.getEpisodeFiles()) {
            arguments.add(episodeFile.getAbsolutePath());
        }
        return arguments.toArray(new String[arguments.size()]);
    }
}

