/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;
import jodd.util.ClassUtil;

public class Fields {
    protected final ClassDescriptor classDescriptor;
    protected final Map<String, FieldDescriptor> fieldsMap;
    private FieldDescriptor[] allFields;

    public Fields(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.fieldsMap = this.inspectFields();
    }

    private Map<String, FieldDescriptor> inspectFields() {
        if (this.classDescriptor.isSystemClass()) {
            return this.emptyFields();
        }
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        Class type = this.classDescriptor.getType();
        Field[] fields = scanAccessible ? ClassUtil.getAccessibleFields(type) : ClassUtil.getSupportedFields(type);
        HashMap<String, FieldDescriptor> map = new HashMap<String, FieldDescriptor>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldName.equals("serialVersionUID")) continue;
            map.put(fieldName, this.createFieldDescriptor(field));
        }
        return map;
    }

    private Map<String, FieldDescriptor> emptyFields() {
        this.allFields = FieldDescriptor.EMPTY_ARRAY;
        return Collections.emptyMap();
    }

    protected FieldDescriptor createFieldDescriptor(Field field) {
        return new FieldDescriptor(this.classDescriptor, field);
    }

    public FieldDescriptor getFieldDescriptor(String name) {
        return this.fieldsMap.get(name);
    }

    public FieldDescriptor[] getAllFieldDescriptors() {
        if (this.allFields == null) {
            FieldDescriptor[] allFields = new FieldDescriptor[this.fieldsMap.size()];
            int index = 0;
            Iterator<FieldDescriptor> iterator = this.fieldsMap.values().iterator();
            while (iterator.hasNext()) {
                FieldDescriptor fieldDescriptor;
                allFields[index] = fieldDescriptor = iterator.next();
                ++index;
            }
            Arrays.sort(allFields, Comparator.comparing(fd -> fd.getField().getName()));
            this.allFields = allFields;
        }
        return this.allFields;
    }
}

