/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.persistence.EntityManagerFactory;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.util.StringUtils;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.runtime.manager.impl.DefaultRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilderFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.scanner.MavenRepository;

public class RuntimeEnvironmentBuilder
implements RuntimeEnvironmentBuilderFactory,
org.kie.api.runtime.manager.RuntimeEnvironmentBuilder {
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private SimpleRuntimeEnvironment runtimeEnvironment;

    public RuntimeEnvironmentBuilder() {
        this.runtimeEnvironment = new SimpleRuntimeEnvironment();
    }

    private RuntimeEnvironmentBuilder(SimpleRuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public static RuntimeEnvironmentBuilder getEmpty() {
        return new RuntimeEnvironmentBuilder();
    }

    public static RuntimeEnvironmentBuilder getDefault() {
        return new RuntimeEnvironmentBuilder(new DefaultRuntimeEnvironment());
    }

    public static RuntimeEnvironmentBuilder getDefaultInMemory() {
        RuntimeEnvironmentBuilder builder = new RuntimeEnvironmentBuilder(new DefaultRuntimeEnvironment(null, false));
        builder.addConfiguration("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName()).addConfiguration("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        return builder;
    }

    public static RuntimeEnvironmentBuilder getDefault(String groupId, String artifactId, String version) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version, null, null);
    }

    public static RuntimeEnvironmentBuilder getDefault(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        KieServices ks = KieServices.Factory.get();
        return RuntimeEnvironmentBuilder.getDefault(ks.newReleaseId(groupId, artifactId, version), kbaseName, ksessionName);
    }

    public static RuntimeEnvironmentBuilder getDefault(ReleaseId releaseId) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId, null, null);
    }

    public static RuntimeEnvironmentBuilder getDefault(ReleaseId releaseId, String kbaseName, String ksessionName) {
        InternalKieModule module;
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.resolveArtifact(releaseId.toExternalForm());
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        if (StringUtils.isEmpty((CharSequence)kbaseName)) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
            throw new IllegalStateException("Cannot find kbase with name " + kbaseName);
        }
        KieBase kbase = kieContainer.getKieBase(kbaseName);
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().knowledgeBase(kbase).classLoader(kieContainer.getClassLoader()).registerableItemsFactory(new KModuleRegisterableItemsFactory(kieContainer, ksessionName));
        return builder;
    }

    public static RuntimeEnvironmentBuilder getClasspathKmoduleDefault() {
        return RuntimeEnvironmentBuilder.getClasspathKmoduleDefault(null, null);
    }

    public static RuntimeEnvironmentBuilder getClasspathKmoduleDefault(String kbaseName, String ksessionName) {
        InternalKieModule module;
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.getKieClasspathContainer();
        if (StringUtils.isEmpty((CharSequence)kbaseName)) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
            throw new IllegalStateException("Cannot find kbase with name " + kbaseName);
        }
        KieBase kbase = kieContainer.getKieBase(kbaseName);
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().knowledgeBase(kbase).classLoader(kieContainer.getClassLoader()).registerableItemsFactory(new KModuleRegisterableItemsFactory(kieContainer, ksessionName));
        return builder;
    }

    public RuntimeEnvironmentBuilder persistence(boolean persistenceEnabled) {
        this.runtimeEnvironment.setUsePersistence(persistenceEnabled);
        return this;
    }

    public RuntimeEnvironmentBuilder entityManagerFactory(Object emf) {
        if (!(emf instanceof EntityManagerFactory)) {
            throw new IllegalArgumentException("Argument is not of type EntityManagerFactory");
        }
        this.runtimeEnvironment.setEmf((EntityManagerFactory)emf);
        return this;
    }

    public RuntimeEnvironmentBuilder addAsset(Resource asset, ResourceType type) {
        this.runtimeEnvironment.addAsset(asset, type);
        return this;
    }

    public RuntimeEnvironmentBuilder addEnvironmentEntry(String name, Object value) {
        this.runtimeEnvironment.addToEnvironment(name, value);
        return this;
    }

    public RuntimeEnvironmentBuilder addConfiguration(String name, String value) {
        this.runtimeEnvironment.addToConfiguration(name, value);
        return this;
    }

    public RuntimeEnvironmentBuilder knowledgeBase(KieBase kbase) {
        this.runtimeEnvironment.setKieBase(kbase);
        return this;
    }

    public RuntimeEnvironmentBuilder userGroupCallback(UserGroupCallback callback) {
        this.runtimeEnvironment.setUserGroupCallback(callback);
        return this;
    }

    public RuntimeEnvironmentBuilder mapper(Mapper mapper) {
        this.runtimeEnvironment.setMapper(mapper);
        return this;
    }

    public RuntimeEnvironmentBuilder registerableItemsFactory(RegisterableItemsFactory factory) {
        this.runtimeEnvironment.setRegisterableItemsFactory(factory);
        return this;
    }

    public RuntimeEnvironment get() {
        this.runtimeEnvironment.init();
        return this.runtimeEnvironment;
    }

    public RuntimeEnvironmentBuilder schedulerService(Object globalScheduler) {
        if (!(globalScheduler instanceof GlobalSchedulerService)) {
            throw new IllegalArgumentException("Argument is not of type GlobalSchedulerService");
        }
        this.runtimeEnvironment.setSchedulerService((GlobalSchedulerService)globalScheduler);
        return this;
    }

    public RuntimeEnvironmentBuilder classLoader(ClassLoader cl) {
        this.runtimeEnvironment.setClassLoader(cl);
        return this;
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newEmptyBuilder() {
        return RuntimeEnvironmentBuilder.getEmpty();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder() {
        return RuntimeEnvironmentBuilder.getDefault();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultInMemoryBuilder() {
        return RuntimeEnvironmentBuilder.getDefaultInMemory();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.getDefault(groupId, artifactId, version, kbaseName, ksessionName);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newDefaultBuilder(ReleaseId releaseId, String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.getDefault(releaseId, kbaseName, ksessionName);
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder() {
        return RuntimeEnvironmentBuilder.getClasspathKmoduleDefault();
    }

    public org.kie.api.runtime.manager.RuntimeEnvironmentBuilder newClasspathKmoduleDefaultBuilder(String kbaseName, String ksessionName) {
        return RuntimeEnvironmentBuilder.getClasspathKmoduleDefault(kbaseName, ksessionName);
    }
}

