/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.formatters.PatternFormatter;

public class DelayedHandler
extends ExtHandler {
    private final Map<Level, Deque<ExtLogRecord>> queues = new HashMap<Level, Deque<ExtLogRecord>>();
    private volatile boolean activated = false;
    private volatile boolean callerCalculationRequired = false;
    private final LogContext logContext;
    private final int queueLimit;
    private final Level warnThreshold;

    public DelayedHandler() {
        this(null);
    }

    public DelayedHandler(LogContext logContext) {
        this(logContext, 200);
    }

    public DelayedHandler(int queueLimit) {
        this(null, queueLimit);
    }

    public DelayedHandler(LogContext logContext, int queueLimit) {
        this(logContext, queueLimit, Level.INFO);
    }

    public DelayedHandler(int queueLimit, Level warnThreshold) {
        this(null, queueLimit, warnThreshold);
    }

    public DelayedHandler(LogContext logContext, int queueLimit, Level warnThreshold) {
        this.logContext = logContext;
        this.queueLimit = queueLimit;
        this.warnThreshold = warnThreshold;
    }

    private static <E> Deque<E> newDeque(Object ignored) {
        return new ArrayDeque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        if (this.activated) {
            this.publishToNestedHandlers(record);
            super.doPublish(record);
        } else {
            if (this.lock.isHeldByCurrentThread()) {
                return;
            }
            this.lock.lock();
            try {
                if (this.activated) {
                    this.publishToNestedHandlers(record);
                    super.doPublish(record);
                } else {
                    if (this.isCallerCalculationRequired()) {
                        record.copyAll();
                    } else {
                        record.disableCallerCalculation();
                        record.copyMdc();
                    }
                    Level level = record.getLevel();
                    Deque q = this.queues.computeIfAbsent(level, DelayedHandler::newDeque);
                    if (q.size() >= this.queueLimit && level.intValue() >= this.warnThreshold.intValue()) {
                        this.reportError("The delayed handler's queue was overrun and log record(s) were lost. Did you forget to configure logging?", null, 1);
                    }
                    this.enqueueOrdered(q, record);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueOrdered(Deque<ExtLogRecord> q, ExtLogRecord record) {
        assert (this.lock.isHeldByCurrentThread());
        ExtLogRecord last = q.peekLast();
        if (last != null && Long.compareUnsigned(last.getSequenceNumber(), record.getSequenceNumber()) > 0) {
            q.pollLast();
            try {
                this.enqueueOrdered(q, record);
            }
            finally {
                q.addLast(last);
            }
            return;
        }
        q.addLast(record);
    }

    private Supplier<ExtLogRecord> drain() {
        assert (this.lock.isHeldByCurrentThread());
        if (this.queues.isEmpty()) {
            return () -> null;
        }
        final List<Deque<ExtLogRecord>> values = List.copyOf(this.queues.values());
        this.queues.clear();
        final int size = values.size();
        final List<ExtLogRecord> current = Arrays.asList(new ExtLogRecord[size]);
        int i = 0;
        for (Deque<ExtLogRecord> value : values) {
            current.set(i++, value.removeFirst());
        }
        return new Supplier<ExtLogRecord>(){
            final /* synthetic */ DelayedHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ExtLogRecord get() {
                ExtLogRecord min = null;
                int minIdx = 0;
                for (int i = 0; i < size; ++i) {
                    ExtLogRecord item = (ExtLogRecord)current.get(i);
                    if (this.compareSeq(min, item) <= 0) continue;
                    min = item;
                    minIdx = i;
                }
                if (min == null) {
                    return null;
                }
                current.set(minIdx, (ExtLogRecord)((Deque)values.get(minIdx)).pollFirst());
                return min;
            }

            private int compareSeq(ExtLogRecord min, ExtLogRecord testItem) {
                if (min == null) {
                    return testItem == null ? 0 : 1;
                }
                if (testItem == null) {
                    return -1;
                }
                return Long.compareUnsigned(min.getSequenceNumber(), testItem.getSequenceNumber());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SecurityException {
        DelayedHandler.checkAccess();
        this.lock.lock();
        try {
            if (!this.queues.isEmpty()) {
                ExtLogRecord record;
                Formatter formatter = this.getFormatter();
                if (formatter == null) {
                    formatter = new PatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
                }
                StandardOutputStreams.printError("The DelayedHandler was closed before any children handlers were configured. Messages will be written to stderr.");
                Supplier<ExtLogRecord> drain = this.drain();
                while ((record = drain.get()) != null) {
                    StandardOutputStreams.printError(formatter.format(record));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.activated = false;
        super.close();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        this.activate();
    }

    @Override
    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        Handler[] result = super.setHandlers(newHandlers);
        this.activate();
        return result;
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
        this.activated = this.handlers.length != 0;
    }

    @Override
    public Handler[] clearHandlers() throws SecurityException {
        this.activated = false;
        return super.clearHandlers();
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired || super.isCallerCalculationRequired();
    }

    public void setCallerCalculationRequired(boolean callerCalculationRequired) {
        this.callerCalculationRequired = callerCalculationRequired;
    }

    public final boolean isActivated() {
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        this.lock.lock();
        try {
            ExtLogRecord record;
            LogContext logContext = this.logContext;
            Supplier<ExtLogRecord> drain = this.drain();
            while ((record = drain.get()) != null) {
                if (!this.isEnabled() || !this.isLoggable(record) || logContext != null && !logContext.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
                this.publishToNestedHandlers(record);
            }
            this.activated = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

