/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.formatters.ColorPrintf;
import org.jboss.logmanager.formatters.ColorUtil;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.formatters.Printf;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class ColorPatternFormatter
extends PatternFormatter {
    private final Printf printf;
    private final boolean darken;

    public ColorPatternFormatter() {
        this(false);
    }

    public ColorPatternFormatter(String pattern) {
        this(false, pattern);
    }

    public ColorPatternFormatter(int darken) {
        this(darken > 0);
    }

    public ColorPatternFormatter(boolean darken) {
        this.darken = darken;
        this.printf = new ColorPrintf(darken);
    }

    public ColorPatternFormatter(int darken, String pattern) {
        this(darken > 0, pattern);
    }

    public ColorPatternFormatter(boolean darken, String pattern) {
        this(darken);
        this.setPattern(pattern);
    }

    @Override
    public void setSteps(FormatStep[] steps) {
        FormatStep[] colorSteps = new FormatStep[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            colorSteps[i] = this.colorize(steps[i]);
        }
        super.setSteps(colorSteps);
    }

    private FormatStep colorize(FormatStep step) {
        return switch (step.getItemType()) {
            case FormatStep.ItemType.LEVEL -> new LevelColorStep(step, this.darken);
            case FormatStep.ItemType.SOURCE_CLASS_NAME, FormatStep.ItemType.SOURCE_METHOD_NAME, FormatStep.ItemType.SOURCE_LINE_NUMBER, FormatStep.ItemType.SOURCE_FILE_NAME -> new ColorStep(step, 60.0f, 1.0f, 0.8f, this.darken);
            case FormatStep.ItemType.DATE, FormatStep.ItemType.RELATIVE_TIME, FormatStep.ItemType.TEXT, FormatStep.ItemType.MESSAGE -> new ColorStep(step, 0.0f, 0.0f, 0.8f, this.darken);
            case FormatStep.ItemType.HOST_NAME, FormatStep.ItemType.RESOURCE_KEY, FormatStep.ItemType.SOURCE_MODULE_VERSION -> new ColorStep(step, 120.0f, 1.0f, 0.8f, this.darken);
            case FormatStep.ItemType.LINE_SEPARATOR -> step;
            case FormatStep.ItemType.CATEGORY -> new ColorStep(step, 220.0f, 0.9f, 0.8f, this.darken);
            case FormatStep.ItemType.MDC, FormatStep.ItemType.NDC -> new ColorStep(step, 153.0f, 1.0f, 0.7f, this.darken);
            case FormatStep.ItemType.EXCEPTION_TRACE -> new ColorStep(step, 0.0f, 1.0f, 0.6f, this.darken);
            case FormatStep.ItemType.SOURCE_MODULE_NAME -> new ColorStep(step, 100.0f, 1.0f, 0.8f, this.darken);
            case FormatStep.ItemType.PROCESS_ID -> new ColorStep(step, 40.0f, 0.6f, 0.7f, this.darken);
            case FormatStep.ItemType.PROCESS_NAME -> new ColorStep(step, 60.0f, 0.6f, 0.7f, this.darken);
            case FormatStep.ItemType.SYSTEM_PROPERTY -> new ColorStep(step, 60.0f, 1.0f, 0.6f, this.darken);
            case FormatStep.ItemType.THREAD_ID, FormatStep.ItemType.THREAD_NAME -> new ColorStep(step, 120.0f, 0.429f, 0.8f, this.darken);
            default -> new ColorStep(step, 120.0f, 0.254f, 0.8f, this.darken);
        };
    }

    private String colorizePlain(String str) {
        return str;
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        if (logRecord instanceof ExtLogRecord) {
            ExtLogRecord record = (ExtLogRecord)logRecord;
            if (record.getFormatStyle() != ExtLogRecord.FormatStyle.PRINTF || record.getParameters() == null || record.getParameters().length == 0) {
                return this.colorizePlain(super.formatMessage(record));
            }
            return this.printf.format(record.getMessage(), record.getParameters());
        }
        return this.colorizePlain(super.formatMessage(logRecord));
    }

    static final class LevelColorStep
    implements FormatStep {
        private static final int LARGEST_LEVEL = Level.ERROR.intValue();
        private static final int SMALLEST_LEVEL = Level.FINEST.intValue();
        private final FormatStep delegate;
        private final boolean darken;
        private final boolean trueColor = ConsoleHandler.isTrueColor();

        LevelColorStep(FormatStep delegate, boolean darken) {
            this.delegate = delegate;
            this.darken = darken;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            int level = LARGEST_LEVEL - Math.max(Math.min(record.getLevel().intValue(), LARGEST_LEVEL), SMALLEST_LEVEL);
            float hue = (float)level * 270.0f / ((float)LARGEST_LEVEL - (float)SMALLEST_LEVEL);
            float sat = 1.0f;
            float lite = 0.75f;
            ColorUtil.startFgColor(builder, this.trueColor, hue, 1.0f, 0.75f, this.darken);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }
    }

    static final class ColorStep
    implements FormatStep {
        private final FormatStep delegate;
        private final float hue;
        private final float sat;
        private final float lite;
        private final boolean darken;
        private final boolean trueColor = ConsoleHandler.isTrueColor();

        ColorStep(FormatStep delegate, float hue, float sat, float lite, boolean darken) {
            this.delegate = delegate;
            this.hue = hue;
            this.sat = sat;
            this.lite = lite;
            this.darken = darken;
        }

        @Override
        public void render(Formatter formatter, StringBuilder builder, ExtLogRecord record) {
            ColorUtil.startFgColor(builder, this.trueColor, this.hue, this.sat, this.lite, this.darken);
            this.delegate.render(formatter, builder, record);
            ColorUtil.endFgColor(builder);
        }

        @Override
        public void render(StringBuilder builder, ExtLogRecord record) {
            this.render(null, builder, record);
        }

        @Override
        public int estimateLength() {
            return this.delegate.estimateLength() + 30;
        }

        @Override
        public boolean isCallerInformationRequired() {
            return this.delegate.isCallerInformationRequired();
        }

        @Override
        public FormatStep.ItemType getItemType() {
            return this.delegate.getItemType();
        }
    }
}

