/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.guard;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.request.RequestGuard;
import org.jboss.arquillian.graphene.request.RequestGuardException;
import org.jboss.arquillian.graphene.request.RequestState;
import org.jboss.arquillian.graphene.request.RequestType;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;

public class RequestGuardFactory {
    private final RequestGuard guard;
    private final Document document;
    private final FluentWait<WebDriver, Void> waitGuard;
    private final GrapheneContext context;
    private final DocumentReady documentReady = new DocumentReady();
    private final RequestIsDone requestIsDone = new RequestIsDone();
    private final RequestChange requestChange = new RequestChange();

    public RequestGuardFactory(RequestGuard guard, Document document, GrapheneContext context) {
        this.guard = guard;
        this.document = document;
        this.context = context;
        this.waitGuard = Graphene.waitAjax().withTimeout(context.getConfiguration().getWaitGuardInterval(), TimeUnit.SECONDS).pollingEvery(Math.min(context.getConfiguration().getWaitGuardInterval() * 100L, 200L), TimeUnit.MILLISECONDS);
    }

    public <T> T guard(T target, final RequestType requestExpected, final boolean strict) {
        if (requestExpected == null) {
            throw new IllegalArgumentException("The paremeter [requestExpected] is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("The paremeter [target] is null.");
        }
        GrapheneProxyInstance proxy = GrapheneProxy.isProxyInstance(target) ? (GrapheneProxyInstance)((GrapheneProxyInstance)target).copy() : (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(this.context, target);
        proxy.registerInterceptor(new Interceptor(){

            @Override
            public Object intercept(InvocationContext context) throws Throwable {
                RequestGuardFactory.this.guard.clearRequestDone();
                Object result = context.invoke();
                RequestType requestType = strict ? this.waitForRequestChange() : this.waitForRequestType(requestExpected);
                if (!requestType.equals((Object)requestExpected)) {
                    throw new RequestGuardException(requestExpected, requestType);
                }
                this.waitForRequestFinished();
                return result;
            }

            @Override
            public int getPrecedence() {
                return 0;
            }

            private RequestType waitForRequestChange() {
                try {
                    return (RequestType)RequestGuardFactory.this.waitGuard.until((Function)RequestGuardFactory.this.requestChange);
                }
                catch (TimeoutException e) {
                    return RequestType.NONE;
                }
            }

            private RequestType waitForRequestType(RequestType requestType) {
                try {
                    return (RequestType)RequestGuardFactory.this.waitGuard.until((Function)new RequestTypeDone(requestExpected));
                }
                catch (TimeoutException e) {
                    return RequestGuardFactory.this.guard.getRequestType();
                }
            }

            private void waitForRequestFinished() {
                switch (requestExpected) {
                    case HTTP: {
                        RequestGuardFactory.this.waitGuard.withMessage("Document didn't become ready").until((Function)RequestGuardFactory.this.documentReady);
                        return;
                    }
                    case XHR: {
                        RequestGuardFactory.this.waitGuard.until((Function)RequestGuardFactory.this.requestIsDone);
                        return;
                    }
                    case NONE: {
                        return;
                    }
                }
            }
        });
        return (T)proxy;
    }

    private class DocumentReady
    implements Function<WebDriver, Boolean> {
        private DocumentReady() {
        }

        @Override
        public Boolean apply(WebDriver driver) {
            return "complete".equals(RequestGuardFactory.this.document.getReadyState());
        }
    }

    private class RequestIsDone
    implements Function<WebDriver, Boolean> {
        private RequestIsDone() {
        }

        @Override
        public Boolean apply(WebDriver driver) {
            RequestState state = RequestGuardFactory.this.guard.getRequestState();
            return RequestState.DONE.equals((Object)state);
        }
    }

    private class RequestChange
    implements Function<WebDriver, RequestType> {
        private RequestChange() {
        }

        @Override
        public RequestType apply(WebDriver driver) {
            RequestType type = RequestGuardFactory.this.guard.getRequestType();
            return RequestType.NONE.equals((Object)type) ? null : type;
        }
    }

    private class RequestTypeDone
    implements Function<WebDriver, RequestType> {
        private RequestType requestExpected;

        RequestTypeDone(RequestType requestExpected) {
            this.requestExpected = requestExpected;
        }

        @Override
        public RequestType apply(WebDriver driver) {
            RequestType type = RequestGuardFactory.this.guard.getRequestType();
            if (!this.requestExpected.equals((Object)type)) {
                return null;
            }
            return type;
        }
    }
}

