/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.metadata.MetadataTransientCacheValue;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.Metadata;

public class MetadataTransientCacheValueExternalizer
implements AdvancedExternalizer<MetadataTransientCacheValue> {
    public Set<Class<? extends MetadataTransientCacheValue>> getTypeClasses() {
        return Collections.singleton(MetadataTransientCacheValue.class);
    }

    public Integer getId() {
        return Ids.METADATA_TRANSIENT_VALUE;
    }

    public void writeObject(ObjectOutput output, MetadataTransientCacheValue icv) throws IOException {
        output.writeObject(icv.getValue());
        output.writeObject(icv.getMetadata());
        UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)icv.getLastUsed());
    }

    public MetadataTransientCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object value = input.readObject();
        Metadata metadata = (Metadata)input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong((DataInput)input);
        return new MetadataTransientCacheValue(value, metadata, lastUsed);
    }
}

