package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StyleInfo}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStyleInfo.of()}.
 */
@Generated(from = "StyleInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStyleInfo extends StyleInfo {
  private final String[] get;
  private final String init;
  private final String with;
  private final String withUnaryOperator;
  private final String add;
  private final String addAll;
  private final String put;
  private final String putAll;
  private final String copyOf;
  private final String of;
  private final String instance;
  private final String builder;
  private final String newBuilder;
  private final String from;
  private final String build;
  private final String buildOrThrow;
  private final String canBuild;
  private final String toBuilder;
  private final String underrideHashCode;
  private final String underrideEquals;
  private final String underrideToString;
  private final String delegateToString;
  private final String includeHashCode;
  private final String isInitialized;
  private final String isSet;
  private final String set;
  private final String unset;
  private final String clear;
  private final String create;
  private final String toImmutable;
  private final String typeBuilder;
  private final String typeInnerBuilder;
  private final String[] typeAbstract;
  private final String typeImmutable;
  private final String typeImmutableEnclosing;
  private final String typeImmutableNested;
  private final String typeModifiable;
  private final String typeInnerModifiable;
  private final String typeWith;
  private final String packageGenerated;
  private final ValueImmutableInfo defaults;
  private final boolean strictBuilder;
  private final boolean strictModifiable;
  private final ValueMirrors.Style.ValidationMethod validationMethod;
  private final boolean allParameters;
  private final boolean defaultAsDefault;
  private final boolean headerComments;
  private final boolean jdkOnly;
  private final boolean jdk9Collections;
  private final ImmutableSet<String> passAnnotationsNames;
  private final ImmutableSet<String> additionalJsonAnnotationsNames;
  private final ValueMirrors.Style.ImplementationVisibility visibility;
  private final String visibilityString;
  private final boolean optionalAcceptNullable;
  private final boolean generateSuppressAllWarnings;
  private final boolean privateNoargConstructor;
  private final boolean protectedNoargConstructor;
  private final boolean attributelessSingleton;
  private final boolean unsafeDefaultAndDerived;
  private final boolean clearBuilder;
  private final boolean isSetOnBuilder;
  private final boolean deferCollectionAllocation;
  private final boolean deepImmutablesDetection;
  private final boolean overshadowImplementation;
  private final boolean implementationNestedInBuilder;
  private final boolean forceJacksonPropertyNames;
  private final boolean setJacksonPropertyRequired;
  private final boolean forceJacksonIgnoreFields;
  private final boolean forceEqualsInWithers;
  private final boolean jacksonIntegration;
  private final boolean weakInterning;
  private final boolean alwaysPublicInitializers;
  private final ValueMirrors.Style.BuilderVisibility builderVisibility;
  private final String builderVisibilityString;
  private final String throwForInvalidImmutableStateName;
  private final String throwForNullPointerName;
  private final boolean depluralize;
  private final String[] depluralizeDictionary;
  private final ImmutableSet<String> immutableCopyOfRoutinesNames;
  private final boolean stagedBuilder;
  private final boolean builtinContainerAttributes;
  private final boolean beanFriendlyModifiables;
  private final boolean allMandatoryParameters;
  private final boolean transientDerivedFields;
  private final boolean finalInstanceFields;
  private final String redactedMask;
  private final boolean attributeBuilderDetection;
  private final String[] attributeBuilder;
  private final String getBuilder;
  private final String setBuilder;
  private final String addBuilder;
  private final String addAllBuilder;
  private final String getBuilders;
  private final String nullableAnnotation;
  private final ImmutableSet<String> allowedClasspathAnnotationsNames;
  private final String fallbackNullableAnnotationName;
  private final int limitStringLengthInToString;
  private final boolean jakarta;
  private final boolean legacyAccessorOrdering;
  private final boolean builderToString;
  private final boolean mergeFromSupertypesDynamically;

  private ImmutableStyleInfo(
      String[] get,
      String init,
      String with,
      String withUnaryOperator,
      String add,
      String addAll,
      String put,
      String putAll,
      String copyOf,
      String of,
      String instance,
      String builder,
      String newBuilder,
      String from,
      String build,
      String buildOrThrow,
      String canBuild,
      String toBuilder,
      String underrideHashCode,
      String underrideEquals,
      String underrideToString,
      String delegateToString,
      String includeHashCode,
      String isInitialized,
      String isSet,
      String set,
      String unset,
      String clear,
      String create,
      String toImmutable,
      String typeBuilder,
      String typeInnerBuilder,
      String[] typeAbstract,
      String typeImmutable,
      String typeImmutableEnclosing,
      String typeImmutableNested,
      String typeModifiable,
      String typeInnerModifiable,
      String typeWith,
      String packageGenerated,
      ValueImmutableInfo defaults,
      boolean strictBuilder,
      boolean strictModifiable,
      ValueMirrors.Style.ValidationMethod validationMethod,
      boolean allParameters,
      boolean defaultAsDefault,
      boolean headerComments,
      boolean jdkOnly,
      boolean jdk9Collections,
      Iterable<String> passAnnotationsNames,
      Iterable<String> additionalJsonAnnotationsNames,
      ValueMirrors.Style.ImplementationVisibility visibility,
      String visibilityString,
      boolean optionalAcceptNullable,
      boolean generateSuppressAllWarnings,
      boolean privateNoargConstructor,
      boolean protectedNoargConstructor,
      boolean attributelessSingleton,
      boolean unsafeDefaultAndDerived,
      boolean clearBuilder,
      boolean isSetOnBuilder,
      boolean deferCollectionAllocation,
      boolean deepImmutablesDetection,
      boolean overshadowImplementation,
      boolean implementationNestedInBuilder,
      boolean forceJacksonPropertyNames,
      boolean setJacksonPropertyRequired,
      boolean forceJacksonIgnoreFields,
      boolean forceEqualsInWithers,
      boolean jacksonIntegration,
      boolean weakInterning,
      boolean alwaysPublicInitializers,
      ValueMirrors.Style.BuilderVisibility builderVisibility,
      String builderVisibilityString,
      String throwForInvalidImmutableStateName,
      String throwForNullPointerName,
      boolean depluralize,
      String[] depluralizeDictionary,
      Iterable<String> immutableCopyOfRoutinesNames,
      boolean stagedBuilder,
      boolean builtinContainerAttributes,
      boolean beanFriendlyModifiables,
      boolean allMandatoryParameters,
      boolean transientDerivedFields,
      boolean finalInstanceFields,
      String redactedMask,
      boolean attributeBuilderDetection,
      String[] attributeBuilder,
      String getBuilder,
      String setBuilder,
      String addBuilder,
      String addAllBuilder,
      String getBuilders,
      String nullableAnnotation,
      Iterable<String> allowedClasspathAnnotationsNames,
      String fallbackNullableAnnotationName,
      int limitStringLengthInToString,
      boolean jakarta,
      boolean legacyAccessorOrdering,
      boolean builderToString,
      boolean mergeFromSupertypesDynamically) {
    this.get = get.clone();
    this.init = Objects.requireNonNull(init, "init");
    this.with = Objects.requireNonNull(with, "with");
    this.withUnaryOperator = Objects.requireNonNull(withUnaryOperator, "withUnaryOperator");
    this.add = Objects.requireNonNull(add, "add");
    this.addAll = Objects.requireNonNull(addAll, "addAll");
    this.put = Objects.requireNonNull(put, "put");
    this.putAll = Objects.requireNonNull(putAll, "putAll");
    this.copyOf = Objects.requireNonNull(copyOf, "copyOf");
    this.of = Objects.requireNonNull(of, "of");
    this.instance = Objects.requireNonNull(instance, "instance");
    this.builder = Objects.requireNonNull(builder, "builder");
    this.newBuilder = Objects.requireNonNull(newBuilder, "newBuilder");
    this.from = Objects.requireNonNull(from, "from");
    this.build = Objects.requireNonNull(build, "build");
    this.buildOrThrow = Objects.requireNonNull(buildOrThrow, "buildOrThrow");
    this.canBuild = Objects.requireNonNull(canBuild, "canBuild");
    this.toBuilder = Objects.requireNonNull(toBuilder, "toBuilder");
    this.underrideHashCode = Objects.requireNonNull(underrideHashCode, "underrideHashCode");
    this.underrideEquals = Objects.requireNonNull(underrideEquals, "underrideEquals");
    this.underrideToString = Objects.requireNonNull(underrideToString, "underrideToString");
    this.delegateToString = Objects.requireNonNull(delegateToString, "delegateToString");
    this.includeHashCode = Objects.requireNonNull(includeHashCode, "includeHashCode");
    this.isInitialized = Objects.requireNonNull(isInitialized, "isInitialized");
    this.isSet = Objects.requireNonNull(isSet, "isSet");
    this.set = Objects.requireNonNull(set, "set");
    this.unset = Objects.requireNonNull(unset, "unset");
    this.clear = Objects.requireNonNull(clear, "clear");
    this.create = Objects.requireNonNull(create, "create");
    this.toImmutable = Objects.requireNonNull(toImmutable, "toImmutable");
    this.typeBuilder = Objects.requireNonNull(typeBuilder, "typeBuilder");
    this.typeInnerBuilder = Objects.requireNonNull(typeInnerBuilder, "typeInnerBuilder");
    this.typeAbstract = typeAbstract.clone();
    this.typeImmutable = Objects.requireNonNull(typeImmutable, "typeImmutable");
    this.typeImmutableEnclosing = Objects.requireNonNull(typeImmutableEnclosing, "typeImmutableEnclosing");
    this.typeImmutableNested = Objects.requireNonNull(typeImmutableNested, "typeImmutableNested");
    this.typeModifiable = Objects.requireNonNull(typeModifiable, "typeModifiable");
    this.typeInnerModifiable = Objects.requireNonNull(typeInnerModifiable, "typeInnerModifiable");
    this.typeWith = Objects.requireNonNull(typeWith, "typeWith");
    this.packageGenerated = Objects.requireNonNull(packageGenerated, "packageGenerated");
    this.defaults = Objects.requireNonNull(defaults, "defaults");
    this.strictBuilder = strictBuilder;
    this.strictModifiable = strictModifiable;
    this.validationMethod = Objects.requireNonNull(validationMethod, "validationMethod");
    this.allParameters = allParameters;
    this.defaultAsDefault = defaultAsDefault;
    this.headerComments = headerComments;
    this.jdkOnly = jdkOnly;
    this.jdk9Collections = jdk9Collections;
    this.passAnnotationsNames = ImmutableSet.copyOf(passAnnotationsNames);
    this.additionalJsonAnnotationsNames = ImmutableSet.copyOf(additionalJsonAnnotationsNames);
    this.visibility = Objects.requireNonNull(visibility, "visibility");
    this.visibilityString = Objects.requireNonNull(visibilityString, "visibilityString");
    this.optionalAcceptNullable = optionalAcceptNullable;
    this.generateSuppressAllWarnings = generateSuppressAllWarnings;
    this.privateNoargConstructor = privateNoargConstructor;
    this.protectedNoargConstructor = protectedNoargConstructor;
    this.attributelessSingleton = attributelessSingleton;
    this.unsafeDefaultAndDerived = unsafeDefaultAndDerived;
    this.clearBuilder = clearBuilder;
    this.isSetOnBuilder = isSetOnBuilder;
    this.deferCollectionAllocation = deferCollectionAllocation;
    this.deepImmutablesDetection = deepImmutablesDetection;
    this.overshadowImplementation = overshadowImplementation;
    this.implementationNestedInBuilder = implementationNestedInBuilder;
    this.forceJacksonPropertyNames = forceJacksonPropertyNames;
    this.setJacksonPropertyRequired = setJacksonPropertyRequired;
    this.forceJacksonIgnoreFields = forceJacksonIgnoreFields;
    this.forceEqualsInWithers = forceEqualsInWithers;
    this.jacksonIntegration = jacksonIntegration;
    this.weakInterning = weakInterning;
    this.alwaysPublicInitializers = alwaysPublicInitializers;
    this.builderVisibility = Objects.requireNonNull(builderVisibility, "builderVisibility");
    this.builderVisibilityString = Objects.requireNonNull(builderVisibilityString, "builderVisibilityString");
    this.throwForInvalidImmutableStateName = Objects.requireNonNull(throwForInvalidImmutableStateName, "throwForInvalidImmutableStateName");
    this.throwForNullPointerName = Objects.requireNonNull(throwForNullPointerName, "throwForNullPointerName");
    this.depluralize = depluralize;
    this.depluralizeDictionary = depluralizeDictionary.clone();
    this.immutableCopyOfRoutinesNames = ImmutableSet.copyOf(immutableCopyOfRoutinesNames);
    this.stagedBuilder = stagedBuilder;
    this.builtinContainerAttributes = builtinContainerAttributes;
    this.beanFriendlyModifiables = beanFriendlyModifiables;
    this.allMandatoryParameters = allMandatoryParameters;
    this.transientDerivedFields = transientDerivedFields;
    this.finalInstanceFields = finalInstanceFields;
    this.redactedMask = Objects.requireNonNull(redactedMask, "redactedMask");
    this.attributeBuilderDetection = attributeBuilderDetection;
    this.attributeBuilder = attributeBuilder.clone();
    this.getBuilder = Objects.requireNonNull(getBuilder, "getBuilder");
    this.setBuilder = Objects.requireNonNull(setBuilder, "setBuilder");
    this.addBuilder = Objects.requireNonNull(addBuilder, "addBuilder");
    this.addAllBuilder = Objects.requireNonNull(addAllBuilder, "addAllBuilder");
    this.getBuilders = Objects.requireNonNull(getBuilders, "getBuilders");
    this.nullableAnnotation = Objects.requireNonNull(nullableAnnotation, "nullableAnnotation");
    this.allowedClasspathAnnotationsNames = ImmutableSet.copyOf(allowedClasspathAnnotationsNames);
    this.fallbackNullableAnnotationName = Objects.requireNonNull(fallbackNullableAnnotationName, "fallbackNullableAnnotationName");
    this.limitStringLengthInToString = limitStringLengthInToString;
    this.jakarta = jakarta;
    this.legacyAccessorOrdering = legacyAccessorOrdering;
    this.builderToString = builderToString;
    this.mergeFromSupertypesDynamically = mergeFromSupertypesDynamically;
  }

  private ImmutableStyleInfo(
      ImmutableStyleInfo original,
      String[] get,
      String init,
      String with,
      String withUnaryOperator,
      String add,
      String addAll,
      String put,
      String putAll,
      String copyOf,
      String of,
      String instance,
      String builder,
      String newBuilder,
      String from,
      String build,
      String buildOrThrow,
      String canBuild,
      String toBuilder,
      String underrideHashCode,
      String underrideEquals,
      String underrideToString,
      String delegateToString,
      String includeHashCode,
      String isInitialized,
      String isSet,
      String set,
      String unset,
      String clear,
      String create,
      String toImmutable,
      String typeBuilder,
      String typeInnerBuilder,
      String[] typeAbstract,
      String typeImmutable,
      String typeImmutableEnclosing,
      String typeImmutableNested,
      String typeModifiable,
      String typeInnerModifiable,
      String typeWith,
      String packageGenerated,
      ValueImmutableInfo defaults,
      boolean strictBuilder,
      boolean strictModifiable,
      ValueMirrors.Style.ValidationMethod validationMethod,
      boolean allParameters,
      boolean defaultAsDefault,
      boolean headerComments,
      boolean jdkOnly,
      boolean jdk9Collections,
      ImmutableSet<String> passAnnotationsNames,
      ImmutableSet<String> additionalJsonAnnotationsNames,
      ValueMirrors.Style.ImplementationVisibility visibility,
      String visibilityString,
      boolean optionalAcceptNullable,
      boolean generateSuppressAllWarnings,
      boolean privateNoargConstructor,
      boolean protectedNoargConstructor,
      boolean attributelessSingleton,
      boolean unsafeDefaultAndDerived,
      boolean clearBuilder,
      boolean isSetOnBuilder,
      boolean deferCollectionAllocation,
      boolean deepImmutablesDetection,
      boolean overshadowImplementation,
      boolean implementationNestedInBuilder,
      boolean forceJacksonPropertyNames,
      boolean setJacksonPropertyRequired,
      boolean forceJacksonIgnoreFields,
      boolean forceEqualsInWithers,
      boolean jacksonIntegration,
      boolean weakInterning,
      boolean alwaysPublicInitializers,
      ValueMirrors.Style.BuilderVisibility builderVisibility,
      String builderVisibilityString,
      String throwForInvalidImmutableStateName,
      String throwForNullPointerName,
      boolean depluralize,
      String[] depluralizeDictionary,
      ImmutableSet<String> immutableCopyOfRoutinesNames,
      boolean stagedBuilder,
      boolean builtinContainerAttributes,
      boolean beanFriendlyModifiables,
      boolean allMandatoryParameters,
      boolean transientDerivedFields,
      boolean finalInstanceFields,
      String redactedMask,
      boolean attributeBuilderDetection,
      String[] attributeBuilder,
      String getBuilder,
      String setBuilder,
      String addBuilder,
      String addAllBuilder,
      String getBuilders,
      String nullableAnnotation,
      ImmutableSet<String> allowedClasspathAnnotationsNames,
      String fallbackNullableAnnotationName,
      int limitStringLengthInToString,
      boolean jakarta,
      boolean legacyAccessorOrdering,
      boolean builderToString,
      boolean mergeFromSupertypesDynamically) {
    this.get = get;
    this.init = init;
    this.with = with;
    this.withUnaryOperator = withUnaryOperator;
    this.add = add;
    this.addAll = addAll;
    this.put = put;
    this.putAll = putAll;
    this.copyOf = copyOf;
    this.of = of;
    this.instance = instance;
    this.builder = builder;
    this.newBuilder = newBuilder;
    this.from = from;
    this.build = build;
    this.buildOrThrow = buildOrThrow;
    this.canBuild = canBuild;
    this.toBuilder = toBuilder;
    this.underrideHashCode = underrideHashCode;
    this.underrideEquals = underrideEquals;
    this.underrideToString = underrideToString;
    this.delegateToString = delegateToString;
    this.includeHashCode = includeHashCode;
    this.isInitialized = isInitialized;
    this.isSet = isSet;
    this.set = set;
    this.unset = unset;
    this.clear = clear;
    this.create = create;
    this.toImmutable = toImmutable;
    this.typeBuilder = typeBuilder;
    this.typeInnerBuilder = typeInnerBuilder;
    this.typeAbstract = typeAbstract;
    this.typeImmutable = typeImmutable;
    this.typeImmutableEnclosing = typeImmutableEnclosing;
    this.typeImmutableNested = typeImmutableNested;
    this.typeModifiable = typeModifiable;
    this.typeInnerModifiable = typeInnerModifiable;
    this.typeWith = typeWith;
    this.packageGenerated = packageGenerated;
    this.defaults = defaults;
    this.strictBuilder = strictBuilder;
    this.strictModifiable = strictModifiable;
    this.validationMethod = validationMethod;
    this.allParameters = allParameters;
    this.defaultAsDefault = defaultAsDefault;
    this.headerComments = headerComments;
    this.jdkOnly = jdkOnly;
    this.jdk9Collections = jdk9Collections;
    this.passAnnotationsNames = passAnnotationsNames;
    this.additionalJsonAnnotationsNames = additionalJsonAnnotationsNames;
    this.visibility = visibility;
    this.visibilityString = visibilityString;
    this.optionalAcceptNullable = optionalAcceptNullable;
    this.generateSuppressAllWarnings = generateSuppressAllWarnings;
    this.privateNoargConstructor = privateNoargConstructor;
    this.protectedNoargConstructor = protectedNoargConstructor;
    this.attributelessSingleton = attributelessSingleton;
    this.unsafeDefaultAndDerived = unsafeDefaultAndDerived;
    this.clearBuilder = clearBuilder;
    this.isSetOnBuilder = isSetOnBuilder;
    this.deferCollectionAllocation = deferCollectionAllocation;
    this.deepImmutablesDetection = deepImmutablesDetection;
    this.overshadowImplementation = overshadowImplementation;
    this.implementationNestedInBuilder = implementationNestedInBuilder;
    this.forceJacksonPropertyNames = forceJacksonPropertyNames;
    this.setJacksonPropertyRequired = setJacksonPropertyRequired;
    this.forceJacksonIgnoreFields = forceJacksonIgnoreFields;
    this.forceEqualsInWithers = forceEqualsInWithers;
    this.jacksonIntegration = jacksonIntegration;
    this.weakInterning = weakInterning;
    this.alwaysPublicInitializers = alwaysPublicInitializers;
    this.builderVisibility = builderVisibility;
    this.builderVisibilityString = builderVisibilityString;
    this.throwForInvalidImmutableStateName = throwForInvalidImmutableStateName;
    this.throwForNullPointerName = throwForNullPointerName;
    this.depluralize = depluralize;
    this.depluralizeDictionary = depluralizeDictionary;
    this.immutableCopyOfRoutinesNames = immutableCopyOfRoutinesNames;
    this.stagedBuilder = stagedBuilder;
    this.builtinContainerAttributes = builtinContainerAttributes;
    this.beanFriendlyModifiables = beanFriendlyModifiables;
    this.allMandatoryParameters = allMandatoryParameters;
    this.transientDerivedFields = transientDerivedFields;
    this.finalInstanceFields = finalInstanceFields;
    this.redactedMask = redactedMask;
    this.attributeBuilderDetection = attributeBuilderDetection;
    this.attributeBuilder = attributeBuilder;
    this.getBuilder = getBuilder;
    this.setBuilder = setBuilder;
    this.addBuilder = addBuilder;
    this.addAllBuilder = addAllBuilder;
    this.getBuilders = getBuilders;
    this.nullableAnnotation = nullableAnnotation;
    this.allowedClasspathAnnotationsNames = allowedClasspathAnnotationsNames;
    this.fallbackNullableAnnotationName = fallbackNullableAnnotationName;
    this.limitStringLengthInToString = limitStringLengthInToString;
    this.jakarta = jakarta;
    this.legacyAccessorOrdering = legacyAccessorOrdering;
    this.builderToString = builderToString;
    this.mergeFromSupertypesDynamically = mergeFromSupertypesDynamically;
  }

  /**
   * @return A cloned {@code get} array
   */
  @Override
  public String[] get() {
    return get.clone();
  }

  /**
   * @return The value of the {@code init} attribute
   */
  @Override
  public String init() {
    return init;
  }

  /**
   * @return The value of the {@code with} attribute
   */
  @Override
  public String with() {
    return with;
  }

  /**
   * @return The value of the {@code withUnaryOperator} attribute
   */
  @Override
  public String withUnaryOperator() {
    return withUnaryOperator;
  }

  /**
   * @return The value of the {@code add} attribute
   */
  @Override
  public String add() {
    return add;
  }

  /**
   * @return The value of the {@code addAll} attribute
   */
  @Override
  public String addAll() {
    return addAll;
  }

  /**
   * @return The value of the {@code put} attribute
   */
  @Override
  public String put() {
    return put;
  }

  /**
   * @return The value of the {@code putAll} attribute
   */
  @Override
  public String putAll() {
    return putAll;
  }

  /**
   * @return The value of the {@code copyOf} attribute
   */
  @Override
  public String copyOf() {
    return copyOf;
  }

  /**
   * @return The value of the {@code of} attribute
   */
  @Override
  public String of() {
    return of;
  }

  /**
   * @return The value of the {@code instance} attribute
   */
  @Override
  public String instance() {
    return instance;
  }

  /**
   * @return The value of the {@code builder} attribute
   */
  @Override
  public String builder() {
    return builder;
  }

  /**
   * @return The value of the {@code newBuilder} attribute
   */
  @Override
  public String newBuilder() {
    return newBuilder;
  }

  /**
   * @return The value of the {@code from} attribute
   */
  @Override
  public String from() {
    return from;
  }

  /**
   * @return The value of the {@code build} attribute
   */
  @Override
  public String build() {
    return build;
  }

  /**
   * @return The value of the {@code buildOrThrow} attribute
   */
  @Override
  public String buildOrThrow() {
    return buildOrThrow;
  }

  /**
   * @return The value of the {@code canBuild} attribute
   */
  @Override
  public String canBuild() {
    return canBuild;
  }

  /**
   * @return The value of the {@code toBuilder} attribute
   */
  @Override
  public String toBuilder() {
    return toBuilder;
  }

  /**
   * @return The value of the {@code underrideHashCode} attribute
   */
  @Override
  public String underrideHashCode() {
    return underrideHashCode;
  }

  /**
   * @return The value of the {@code underrideEquals} attribute
   */
  @Override
  public String underrideEquals() {
    return underrideEquals;
  }

  /**
   * @return The value of the {@code underrideToString} attribute
   */
  @Override
  public String underrideToString() {
    return underrideToString;
  }

  /**
   * @return The value of the {@code delegateToString} attribute
   */
  @Override
  public String delegateToString() {
    return delegateToString;
  }

  /**
   * @return The value of the {@code includeHashCode} attribute
   */
  @Override
  public String includeHashCode() {
    return includeHashCode;
  }

  /**
   * @return The value of the {@code isInitialized} attribute
   */
  @Override
  public String isInitialized() {
    return isInitialized;
  }

  /**
   * @return The value of the {@code isSet} attribute
   */
  @Override
  public String isSet() {
    return isSet;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public String set() {
    return set;
  }

  /**
   * @return The value of the {@code unset} attribute
   */
  @Override
  public String unset() {
    return unset;
  }

  /**
   * @return The value of the {@code clear} attribute
   */
  @Override
  public String clear() {
    return clear;
  }

  /**
   * @return The value of the {@code create} attribute
   */
  @Override
  public String create() {
    return create;
  }

  /**
   * @return The value of the {@code toImmutable} attribute
   */
  @Override
  public String toImmutable() {
    return toImmutable;
  }

  /**
   * @return The value of the {@code typeBuilder} attribute
   */
  @Override
  public String typeBuilder() {
    return typeBuilder;
  }

  /**
   * @return The value of the {@code typeInnerBuilder} attribute
   */
  @Override
  public String typeInnerBuilder() {
    return typeInnerBuilder;
  }

  /**
   * @return A cloned {@code typeAbstract} array
   */
  @Override
  public String[] typeAbstract() {
    return typeAbstract.clone();
  }

  /**
   * @return The value of the {@code typeImmutable} attribute
   */
  @Override
  public String typeImmutable() {
    return typeImmutable;
  }

  /**
   * @return The value of the {@code typeImmutableEnclosing} attribute
   */
  @Override
  public String typeImmutableEnclosing() {
    return typeImmutableEnclosing;
  }

  /**
   * @return The value of the {@code typeImmutableNested} attribute
   */
  @Override
  public String typeImmutableNested() {
    return typeImmutableNested;
  }

  /**
   * @return The value of the {@code typeModifiable} attribute
   */
  @Override
  public String typeModifiable() {
    return typeModifiable;
  }

  /**
   * @return The value of the {@code typeInnerModifiable} attribute
   */
  @Override
  public String typeInnerModifiable() {
    return typeInnerModifiable;
  }

  /**
   * @return The value of the {@code typeWith} attribute
   */
  @Override
  public String typeWith() {
    return typeWith;
  }

  /**
   * @return The value of the {@code packageGenerated} attribute
   */
  @Override
  public String packageGenerated() {
    return packageGenerated;
  }

  /**
   * @return The value of the {@code defaults} attribute
   */
  @Override
  public ValueImmutableInfo defaults() {
    return defaults;
  }

  /**
   * @return The value of the {@code strictBuilder} attribute
   */
  @Override
  public boolean strictBuilder() {
    return strictBuilder;
  }

  /**
   * @return The value of the {@code strictModifiable} attribute
   */
  @Override
  public boolean strictModifiable() {
    return strictModifiable;
  }

  /**
   * @return The value of the {@code validationMethod} attribute
   */
  @Override
  public ValueMirrors.Style.ValidationMethod validationMethod() {
    return validationMethod;
  }

  /**
   * @return The value of the {@code allParameters} attribute
   */
  @Override
  public boolean allParameters() {
    return allParameters;
  }

  /**
   * @return The value of the {@code defaultAsDefault} attribute
   */
  @Override
  public boolean defaultAsDefault() {
    return defaultAsDefault;
  }

  /**
   * @return The value of the {@code headerComments} attribute
   */
  @Override
  public boolean headerComments() {
    return headerComments;
  }

  /**
   * @return The value of the {@code jdkOnly} attribute
   */
  @Override
  public boolean jdkOnly() {
    return jdkOnly;
  }

  /**
   * @return The value of the {@code jdk9Collections} attribute
   */
  @Override
  public boolean jdk9Collections() {
    return jdk9Collections;
  }

  /**
   * @return The value of the {@code passAnnotationsNames} attribute
   */
  @Override
  public ImmutableSet<String> passAnnotationsNames() {
    return passAnnotationsNames;
  }

  /**
   * @return The value of the {@code additionalJsonAnnotationsNames} attribute
   */
  @Override
  public ImmutableSet<String> additionalJsonAnnotationsNames() {
    return additionalJsonAnnotationsNames;
  }

  /**
   * @return The value of the {@code visibility} attribute
   */
  @Override
  public ValueMirrors.Style.ImplementationVisibility visibility() {
    return visibility;
  }

  /**
   * @return The value of the {@code visibilityString} attribute
   */
  @Override
  public String visibilityString() {
    return visibilityString;
  }

  /**
   * @return The value of the {@code optionalAcceptNullable} attribute
   */
  @Override
  public boolean optionalAcceptNullable() {
    return optionalAcceptNullable;
  }

  /**
   * @return The value of the {@code generateSuppressAllWarnings} attribute
   */
  @Override
  public boolean generateSuppressAllWarnings() {
    return generateSuppressAllWarnings;
  }

  /**
   * @return The value of the {@code privateNoargConstructor} attribute
   */
  @Override
  public boolean privateNoargConstructor() {
    return privateNoargConstructor;
  }

  /**
   * @return The value of the {@code protectedNoargConstructor} attribute
   */
  @Override
  public boolean protectedNoargConstructor() {
    return protectedNoargConstructor;
  }

  /**
   * @return The value of the {@code attributelessSingleton} attribute
   */
  @Override
  public boolean attributelessSingleton() {
    return attributelessSingleton;
  }

  /**
   * @return The value of the {@code unsafeDefaultAndDerived} attribute
   */
  @Override
  public boolean unsafeDefaultAndDerived() {
    return unsafeDefaultAndDerived;
  }

  /**
   * @return The value of the {@code clearBuilder} attribute
   */
  @Override
  public boolean clearBuilder() {
    return clearBuilder;
  }

  /**
   * @return The value of the {@code isSetOnBuilder} attribute
   */
  @Override
  public boolean isSetOnBuilder() {
    return isSetOnBuilder;
  }

  /**
   * @return The value of the {@code deferCollectionAllocation} attribute
   */
  @Override
  public boolean deferCollectionAllocation() {
    return deferCollectionAllocation;
  }

  /**
   * @return The value of the {@code deepImmutablesDetection} attribute
   */
  @Override
  public boolean deepImmutablesDetection() {
    return deepImmutablesDetection;
  }

  /**
   * @return The value of the {@code overshadowImplementation} attribute
   */
  @Override
  public boolean overshadowImplementation() {
    return overshadowImplementation;
  }

  /**
   * @return The value of the {@code implementationNestedInBuilder} attribute
   */
  @Override
  public boolean implementationNestedInBuilder() {
    return implementationNestedInBuilder;
  }

  /**
   * @return The value of the {@code forceJacksonPropertyNames} attribute
   */
  @Override
  public boolean forceJacksonPropertyNames() {
    return forceJacksonPropertyNames;
  }

  /**
   * @return The value of the {@code setJacksonPropertyRequired} attribute
   */
  @Override
  public boolean setJacksonPropertyRequired() {
    return setJacksonPropertyRequired;
  }

  /**
   * @return The value of the {@code forceJacksonIgnoreFields} attribute
   */
  @Override
  public boolean forceJacksonIgnoreFields() {
    return forceJacksonIgnoreFields;
  }

  /**
   * @return The value of the {@code forceEqualsInWithers} attribute
   */
  @Override
  public boolean forceEqualsInWithers() {
    return forceEqualsInWithers;
  }

  /**
   * @return The value of the {@code jacksonIntegration} attribute
   */
  @Override
  public boolean jacksonIntegration() {
    return jacksonIntegration;
  }

  /**
   * @return The value of the {@code weakInterning} attribute
   */
  @Override
  public boolean weakInterning() {
    return weakInterning;
  }

  /**
   * @return The value of the {@code alwaysPublicInitializers} attribute
   */
  @Override
  public boolean alwaysPublicInitializers() {
    return alwaysPublicInitializers;
  }

  /**
   * @return The value of the {@code builderVisibility} attribute
   */
  @Override
  public ValueMirrors.Style.BuilderVisibility builderVisibility() {
    return builderVisibility;
  }

  /**
   * @return The value of the {@code builderVisibilityString} attribute
   */
  @Override
  public String builderVisibilityString() {
    return builderVisibilityString;
  }

  /**
   * @return The value of the {@code throwForInvalidImmutableStateName} attribute
   */
  @Override
  public String throwForInvalidImmutableStateName() {
    return throwForInvalidImmutableStateName;
  }

  /**
   * @return The value of the {@code throwForNullPointerName} attribute
   */
  @Override
  public String throwForNullPointerName() {
    return throwForNullPointerName;
  }

  /**
   * @return The value of the {@code depluralize} attribute
   */
  @Override
  public boolean depluralize() {
    return depluralize;
  }

  /**
   * @return A cloned {@code depluralizeDictionary} array
   */
  @Override
  public String[] depluralizeDictionary() {
    return depluralizeDictionary.clone();
  }

  /**
   * @return The value of the {@code immutableCopyOfRoutinesNames} attribute
   */
  @Override
  public ImmutableSet<String> immutableCopyOfRoutinesNames() {
    return immutableCopyOfRoutinesNames;
  }

  /**
   * @return The value of the {@code stagedBuilder} attribute
   */
  @Override
  public boolean stagedBuilder() {
    return stagedBuilder;
  }

  /**
   * @return The value of the {@code builtinContainerAttributes} attribute
   */
  @Override
  public boolean builtinContainerAttributes() {
    return builtinContainerAttributes;
  }

  /**
   * @return The value of the {@code beanFriendlyModifiables} attribute
   */
  @Override
  public boolean beanFriendlyModifiables() {
    return beanFriendlyModifiables;
  }

  /**
   * @return The value of the {@code allMandatoryParameters} attribute
   */
  @Override
  public boolean allMandatoryParameters() {
    return allMandatoryParameters;
  }

  /**
   * @return The value of the {@code transientDerivedFields} attribute
   */
  @Override
  public boolean transientDerivedFields() {
    return transientDerivedFields;
  }

  /**
   * @return The value of the {@code finalInstanceFields} attribute
   */
  @Override
  public boolean finalInstanceFields() {
    return finalInstanceFields;
  }

  /**
   * @return The value of the {@code redactedMask} attribute
   */
  @Override
  public String redactedMask() {
    return redactedMask;
  }

  /**
   * @return The value of the {@code attributeBuilderDetection} attribute
   */
  @Override
  public boolean attributeBuilderDetection() {
    return attributeBuilderDetection;
  }

  /**
   * @return A cloned {@code attributeBuilder} array
   */
  @Override
  public String[] attributeBuilder() {
    return attributeBuilder.clone();
  }

  /**
   * @return The value of the {@code getBuilder} attribute
   */
  @Override
  public String getBuilder() {
    return getBuilder;
  }

  /**
   * @return The value of the {@code setBuilder} attribute
   */
  @Override
  public String setBuilder() {
    return setBuilder;
  }

  /**
   * @return The value of the {@code addBuilder} attribute
   */
  @Override
  public String addBuilder() {
    return addBuilder;
  }

  /**
   * @return The value of the {@code addAllBuilder} attribute
   */
  @Override
  public String addAllBuilder() {
    return addAllBuilder;
  }

  /**
   * @return The value of the {@code getBuilders} attribute
   */
  @Override
  public String getBuilders() {
    return getBuilders;
  }

  /**
   * @return The value of the {@code nullableAnnotation} attribute
   */
  @Override
  public String nullableAnnotation() {
    return nullableAnnotation;
  }

  /**
   * @return The value of the {@code allowedClasspathAnnotationsNames} attribute
   */
  @Override
  public ImmutableSet<String> allowedClasspathAnnotationsNames() {
    return allowedClasspathAnnotationsNames;
  }

  /**
   * @return The value of the {@code fallbackNullableAnnotationName} attribute
   */
  @Override
  public String fallbackNullableAnnotationName() {
    return fallbackNullableAnnotationName;
  }

  /**
   * @return The value of the {@code limitStringLengthInToString} attribute
   */
  @Override
  public int limitStringLengthInToString() {
    return limitStringLengthInToString;
  }

  /**
   * @return The value of the {@code jakarta} attribute
   */
  @Override
  public boolean jakarta() {
    return jakarta;
  }

  /**
   * @return The value of the {@code legacyAccessorOrdering} attribute
   */
  @Override
  public boolean legacyAccessorOrdering() {
    return legacyAccessorOrdering;
  }

  /**
   * @return The value of the {@code builderToString} attribute
   */
  @Override
  public boolean builderToString() {
    return builderToString;
  }

  /**
   * @return The value of the {@code mergeFromSupertypesDynamically} attribute
   */
  @Override
  public boolean mergeFromSupertypesDynamically() {
    return mergeFromSupertypesDynamically;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#get() get}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for get
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withGet(String... elements) {
    String[] newValue = elements.clone();
    return validate(new ImmutableStyleInfo(
        this,
        newValue,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#init() init} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for init
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withInit(String value) {
    String newValue = Objects.requireNonNull(value, "init");
    if (this.init.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        newValue,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#with() with} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for with
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withWith(String value) {
    String newValue = Objects.requireNonNull(value, "with");
    if (this.with.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        newValue,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#withUnaryOperator() withUnaryOperator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for withUnaryOperator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withWithUnaryOperator(String value) {
    String newValue = Objects.requireNonNull(value, "withUnaryOperator");
    if (this.withUnaryOperator.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        newValue,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#add() add} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for add
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAdd(String value) {
    String newValue = Objects.requireNonNull(value, "add");
    if (this.add.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        newValue,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#addAll() addAll} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addAll
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAddAll(String value) {
    String newValue = Objects.requireNonNull(value, "addAll");
    if (this.addAll.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        newValue,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#put() put} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for put
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withPut(String value) {
    String newValue = Objects.requireNonNull(value, "put");
    if (this.put.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        newValue,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#putAll() putAll} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for putAll
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withPutAll(String value) {
    String newValue = Objects.requireNonNull(value, "putAll");
    if (this.putAll.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        newValue,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#copyOf() copyOf} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for copyOf
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withCopyOf(String value) {
    String newValue = Objects.requireNonNull(value, "copyOf");
    if (this.copyOf.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        newValue,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#of() of} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for of
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withOf(String value) {
    String newValue = Objects.requireNonNull(value, "of");
    if (this.of.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        newValue,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#instance() instance} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instance
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withInstance(String value) {
    String newValue = Objects.requireNonNull(value, "instance");
    if (this.instance.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        newValue,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#builder() builder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "builder");
    if (this.builder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        newValue,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#newBuilder() newBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for newBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withNewBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "newBuilder");
    if (this.newBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        newValue,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#from() from} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for from
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withFrom(String value) {
    String newValue = Objects.requireNonNull(value, "from");
    if (this.from.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        newValue,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#build() build} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for build
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuild(String value) {
    String newValue = Objects.requireNonNull(value, "build");
    if (this.build.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        newValue,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#buildOrThrow() buildOrThrow} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buildOrThrow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuildOrThrow(String value) {
    String newValue = Objects.requireNonNull(value, "buildOrThrow");
    if (this.buildOrThrow.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        newValue,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#canBuild() canBuild} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for canBuild
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withCanBuild(String value) {
    String newValue = Objects.requireNonNull(value, "canBuild");
    if (this.canBuild.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        newValue,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#toBuilder() toBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withToBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "toBuilder");
    if (this.toBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        newValue,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#underrideHashCode() underrideHashCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for underrideHashCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withUnderrideHashCode(String value) {
    String newValue = Objects.requireNonNull(value, "underrideHashCode");
    if (this.underrideHashCode.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        newValue,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#underrideEquals() underrideEquals} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for underrideEquals
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withUnderrideEquals(String value) {
    String newValue = Objects.requireNonNull(value, "underrideEquals");
    if (this.underrideEquals.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        newValue,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#underrideToString() underrideToString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for underrideToString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withUnderrideToString(String value) {
    String newValue = Objects.requireNonNull(value, "underrideToString");
    if (this.underrideToString.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        newValue,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#delegateToString() delegateToString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delegateToString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDelegateToString(String value) {
    String newValue = Objects.requireNonNull(value, "delegateToString");
    if (this.delegateToString.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        newValue,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#includeHashCode() includeHashCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for includeHashCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withIncludeHashCode(String value) {
    String newValue = Objects.requireNonNull(value, "includeHashCode");
    if (this.includeHashCode.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        newValue,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#isInitialized() isInitialized} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isInitialized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withIsInitialized(String value) {
    String newValue = Objects.requireNonNull(value, "isInitialized");
    if (this.isInitialized.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        newValue,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#isSet() isSet} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withIsSet(String value) {
    String newValue = Objects.requireNonNull(value, "isSet");
    if (this.isSet.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        newValue,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#set() set} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for set
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withSet(String value) {
    String newValue = Objects.requireNonNull(value, "set");
    if (this.set.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        newValue,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#unset() unset} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withUnset(String value) {
    String newValue = Objects.requireNonNull(value, "unset");
    if (this.unset.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        newValue,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#clear() clear} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clear
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withClear(String value) {
    String newValue = Objects.requireNonNull(value, "clear");
    if (this.clear.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        newValue,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#create() create} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for create
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withCreate(String value) {
    String newValue = Objects.requireNonNull(value, "create");
    if (this.create.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        newValue,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#toImmutable() toImmutable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withToImmutable(String value) {
    String newValue = Objects.requireNonNull(value, "toImmutable");
    if (this.toImmutable.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        newValue,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeBuilder() typeBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "typeBuilder");
    if (this.typeBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        newValue,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeInnerBuilder() typeInnerBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeInnerBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeInnerBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "typeInnerBuilder");
    if (this.typeInnerBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        newValue,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#typeAbstract() typeAbstract}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for typeAbstract
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withTypeAbstract(String... elements) {
    String[] newValue = elements.clone();
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        newValue,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeImmutable() typeImmutable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeImmutable(String value) {
    String newValue = Objects.requireNonNull(value, "typeImmutable");
    if (this.typeImmutable.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        newValue,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeImmutableEnclosing() typeImmutableEnclosing} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeImmutableEnclosing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeImmutableEnclosing(String value) {
    String newValue = Objects.requireNonNull(value, "typeImmutableEnclosing");
    if (this.typeImmutableEnclosing.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        newValue,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeImmutableNested() typeImmutableNested} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeImmutableNested
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeImmutableNested(String value) {
    String newValue = Objects.requireNonNull(value, "typeImmutableNested");
    if (this.typeImmutableNested.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        newValue,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeModifiable() typeModifiable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeModifiable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeModifiable(String value) {
    String newValue = Objects.requireNonNull(value, "typeModifiable");
    if (this.typeModifiable.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        newValue,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeInnerModifiable() typeInnerModifiable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeInnerModifiable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeInnerModifiable(String value) {
    String newValue = Objects.requireNonNull(value, "typeInnerModifiable");
    if (this.typeInnerModifiable.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        newValue,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#typeWith() typeWith} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeWith
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTypeWith(String value) {
    String newValue = Objects.requireNonNull(value, "typeWith");
    if (this.typeWith.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        newValue,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#packageGenerated() packageGenerated} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packageGenerated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withPackageGenerated(String value) {
    String newValue = Objects.requireNonNull(value, "packageGenerated");
    if (this.packageGenerated.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        newValue,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#defaults() defaults} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaults
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDefaults(ValueImmutableInfo value) {
    if (this.defaults == value) return this;
    ValueImmutableInfo newValue = Objects.requireNonNull(value, "defaults");
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        newValue,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#strictBuilder() strictBuilder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for strictBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withStrictBuilder(boolean value) {
    if (this.strictBuilder == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        value,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#strictModifiable() strictModifiable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for strictModifiable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withStrictModifiable(boolean value) {
    if (this.strictModifiable == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        value,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#validationMethod() validationMethod} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validationMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withValidationMethod(ValueMirrors.Style.ValidationMethod value) {
    if (this.validationMethod == value) return this;
    ValueMirrors.Style.ValidationMethod newValue = Objects.requireNonNull(value, "validationMethod");
    if (this.validationMethod.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        newValue,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#allParameters() allParameters} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAllParameters(boolean value) {
    if (this.allParameters == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        value,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#defaultAsDefault() defaultAsDefault} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultAsDefault
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDefaultAsDefault(boolean value) {
    if (this.defaultAsDefault == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        value,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#headerComments() headerComments} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headerComments
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withHeaderComments(boolean value) {
    if (this.headerComments == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        value,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#jdkOnly() jdkOnly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jdkOnly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withJdkOnly(boolean value) {
    if (this.jdkOnly == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        value,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#jdk9Collections() jdk9Collections} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jdk9Collections
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withJdk9Collections(boolean value) {
    if (this.jdk9Collections == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        value,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#passAnnotationsNames() passAnnotationsNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withPassAnnotationsNames(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        newValue,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#passAnnotationsNames() passAnnotationsNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of passAnnotationsNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withPassAnnotationsNames(Iterable<String> elements) {
    if (this.passAnnotationsNames == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        newValue,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#additionalJsonAnnotationsNames() additionalJsonAnnotationsNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withAdditionalJsonAnnotationsNames(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        newValue,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#additionalJsonAnnotationsNames() additionalJsonAnnotationsNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of additionalJsonAnnotationsNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withAdditionalJsonAnnotationsNames(Iterable<String> elements) {
    if (this.additionalJsonAnnotationsNames == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        newValue,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#visibility() visibility} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibility
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withVisibility(ValueMirrors.Style.ImplementationVisibility value) {
    if (this.visibility == value) return this;
    ValueMirrors.Style.ImplementationVisibility newValue = Objects.requireNonNull(value, "visibility");
    if (this.visibility.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        newValue,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#visibilityString() visibilityString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibilityString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withVisibilityString(String value) {
    String newValue = Objects.requireNonNull(value, "visibilityString");
    if (this.visibilityString.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        newValue,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#optionalAcceptNullable() optionalAcceptNullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optionalAcceptNullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withOptionalAcceptNullable(boolean value) {
    if (this.optionalAcceptNullable == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        value,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#generateSuppressAllWarnings() generateSuppressAllWarnings} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for generateSuppressAllWarnings
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withGenerateSuppressAllWarnings(boolean value) {
    if (this.generateSuppressAllWarnings == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        value,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#privateNoargConstructor() privateNoargConstructor} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for privateNoargConstructor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withPrivateNoargConstructor(boolean value) {
    if (this.privateNoargConstructor == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        value,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#protectedNoargConstructor() protectedNoargConstructor} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protectedNoargConstructor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withProtectedNoargConstructor(boolean value) {
    if (this.protectedNoargConstructor == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        value,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#attributelessSingleton() attributelessSingleton} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributelessSingleton
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAttributelessSingleton(boolean value) {
    if (this.attributelessSingleton == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        value,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#unsafeDefaultAndDerived() unsafeDefaultAndDerived} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unsafeDefaultAndDerived
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withUnsafeDefaultAndDerived(boolean value) {
    if (this.unsafeDefaultAndDerived == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        value,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#clearBuilder() clearBuilder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clearBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withClearBuilder(boolean value) {
    if (this.clearBuilder == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        value,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#isSetOnBuilder() isSetOnBuilder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSetOnBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withIsSetOnBuilder(boolean value) {
    if (this.isSetOnBuilder == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        value,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#deferCollectionAllocation() deferCollectionAllocation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deferCollectionAllocation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDeferCollectionAllocation(boolean value) {
    if (this.deferCollectionAllocation == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        value,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#deepImmutablesDetection() deepImmutablesDetection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deepImmutablesDetection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDeepImmutablesDetection(boolean value) {
    if (this.deepImmutablesDetection == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        value,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#overshadowImplementation() overshadowImplementation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for overshadowImplementation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withOvershadowImplementation(boolean value) {
    if (this.overshadowImplementation == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        value,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#implementationNestedInBuilder() implementationNestedInBuilder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for implementationNestedInBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withImplementationNestedInBuilder(boolean value) {
    if (this.implementationNestedInBuilder == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        value,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#forceJacksonPropertyNames() forceJacksonPropertyNames} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forceJacksonPropertyNames
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withForceJacksonPropertyNames(boolean value) {
    if (this.forceJacksonPropertyNames == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        value,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#setJacksonPropertyRequired() setJacksonPropertyRequired} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for setJacksonPropertyRequired
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withSetJacksonPropertyRequired(boolean value) {
    if (this.setJacksonPropertyRequired == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        value,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#forceJacksonIgnoreFields() forceJacksonIgnoreFields} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forceJacksonIgnoreFields
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withForceJacksonIgnoreFields(boolean value) {
    if (this.forceJacksonIgnoreFields == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        value,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#forceEqualsInWithers() forceEqualsInWithers} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forceEqualsInWithers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withForceEqualsInWithers(boolean value) {
    if (this.forceEqualsInWithers == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        value,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#jacksonIntegration() jacksonIntegration} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jacksonIntegration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withJacksonIntegration(boolean value) {
    if (this.jacksonIntegration == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        value,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#weakInterning() weakInterning} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for weakInterning
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withWeakInterning(boolean value) {
    if (this.weakInterning == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        value,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#alwaysPublicInitializers() alwaysPublicInitializers} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for alwaysPublicInitializers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAlwaysPublicInitializers(boolean value) {
    if (this.alwaysPublicInitializers == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        value,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#builderVisibility() builderVisibility} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderVisibility
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuilderVisibility(ValueMirrors.Style.BuilderVisibility value) {
    if (this.builderVisibility == value) return this;
    ValueMirrors.Style.BuilderVisibility newValue = Objects.requireNonNull(value, "builderVisibility");
    if (this.builderVisibility.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        newValue,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#builderVisibilityString() builderVisibilityString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderVisibilityString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuilderVisibilityString(String value) {
    String newValue = Objects.requireNonNull(value, "builderVisibilityString");
    if (this.builderVisibilityString.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        newValue,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#throwForInvalidImmutableStateName() throwForInvalidImmutableStateName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throwForInvalidImmutableStateName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withThrowForInvalidImmutableStateName(String value) {
    String newValue = Objects.requireNonNull(value, "throwForInvalidImmutableStateName");
    if (this.throwForInvalidImmutableStateName.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        newValue,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#throwForNullPointerName() throwForNullPointerName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throwForNullPointerName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withThrowForNullPointerName(String value) {
    String newValue = Objects.requireNonNull(value, "throwForNullPointerName");
    if (this.throwForNullPointerName.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        newValue,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#depluralize() depluralize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for depluralize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withDepluralize(boolean value) {
    if (this.depluralize == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        value,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#depluralizeDictionary() depluralizeDictionary}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for depluralizeDictionary
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withDepluralizeDictionary(String... elements) {
    String[] newValue = elements.clone();
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        newValue,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#immutableCopyOfRoutinesNames() immutableCopyOfRoutinesNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withImmutableCopyOfRoutinesNames(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        newValue,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#immutableCopyOfRoutinesNames() immutableCopyOfRoutinesNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of immutableCopyOfRoutinesNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withImmutableCopyOfRoutinesNames(Iterable<String> elements) {
    if (this.immutableCopyOfRoutinesNames == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        newValue,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#stagedBuilder() stagedBuilder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stagedBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withStagedBuilder(boolean value) {
    if (this.stagedBuilder == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        value,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#builtinContainerAttributes() builtinContainerAttributes} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builtinContainerAttributes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuiltinContainerAttributes(boolean value) {
    if (this.builtinContainerAttributes == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        value,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#beanFriendlyModifiables() beanFriendlyModifiables} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for beanFriendlyModifiables
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBeanFriendlyModifiables(boolean value) {
    if (this.beanFriendlyModifiables == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        value,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#allMandatoryParameters() allMandatoryParameters} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allMandatoryParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAllMandatoryParameters(boolean value) {
    if (this.allMandatoryParameters == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        value,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#transientDerivedFields() transientDerivedFields} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transientDerivedFields
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withTransientDerivedFields(boolean value) {
    if (this.transientDerivedFields == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        value,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#finalInstanceFields() finalInstanceFields} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for finalInstanceFields
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withFinalInstanceFields(boolean value) {
    if (this.finalInstanceFields == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        value,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#redactedMask() redactedMask} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for redactedMask
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withRedactedMask(String value) {
    String newValue = Objects.requireNonNull(value, "redactedMask");
    if (this.redactedMask.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        newValue,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#attributeBuilderDetection() attributeBuilderDetection} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributeBuilderDetection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAttributeBuilderDetection(boolean value) {
    if (this.attributeBuilderDetection == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        value,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#attributeBuilder() attributeBuilder}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for attributeBuilder
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withAttributeBuilder(String... elements) {
    String[] newValue = elements.clone();
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        newValue,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#getBuilder() getBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withGetBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "getBuilder");
    if (this.getBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        newValue,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#setBuilder() setBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for setBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withSetBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "setBuilder");
    if (this.setBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        newValue,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#addBuilder() addBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAddBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "addBuilder");
    if (this.addBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        newValue,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#addAllBuilder() addAllBuilder} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addAllBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withAddAllBuilder(String value) {
    String newValue = Objects.requireNonNull(value, "addAllBuilder");
    if (this.addAllBuilder.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        newValue,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#getBuilders() getBuilders} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for getBuilders
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withGetBuilders(String value) {
    String newValue = Objects.requireNonNull(value, "getBuilders");
    if (this.getBuilders.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        newValue,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#nullableAnnotation() nullableAnnotation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableAnnotation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withNullableAnnotation(String value) {
    String newValue = Objects.requireNonNull(value, "nullableAnnotation");
    if (this.nullableAnnotation.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        newValue,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#allowedClasspathAnnotationsNames() allowedClasspathAnnotationsNames}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withAllowedClasspathAnnotationsNames(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        newValue,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StyleInfo#allowedClasspathAnnotationsNames() allowedClasspathAnnotationsNames}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of allowedClasspathAnnotationsNames elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStyleInfo withAllowedClasspathAnnotationsNames(Iterable<String> elements) {
    if (this.allowedClasspathAnnotationsNames == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        newValue,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#fallbackNullableAnnotationName() fallbackNullableAnnotationName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fallbackNullableAnnotationName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withFallbackNullableAnnotationName(String value) {
    String newValue = Objects.requireNonNull(value, "fallbackNullableAnnotationName");
    if (this.fallbackNullableAnnotationName.equals(newValue)) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        newValue,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#limitStringLengthInToString() limitStringLengthInToString} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for limitStringLengthInToString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withLimitStringLengthInToString(int value) {
    if (this.limitStringLengthInToString == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        value,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#jakarta() jakarta} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jakarta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withJakarta(boolean value) {
    if (this.jakarta == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        value,
        this.legacyAccessorOrdering,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#legacyAccessorOrdering() legacyAccessorOrdering} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for legacyAccessorOrdering
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withLegacyAccessorOrdering(boolean value) {
    if (this.legacyAccessorOrdering == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        value,
        this.builderToString,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#builderToString() builderToString} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderToString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withBuilderToString(boolean value) {
    if (this.builderToString == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        value,
        this.mergeFromSupertypesDynamically));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StyleInfo#mergeFromSupertypesDynamically() mergeFromSupertypesDynamically} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeFromSupertypesDynamically
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStyleInfo withMergeFromSupertypesDynamically(boolean value) {
    if (this.mergeFromSupertypesDynamically == value) return this;
    return validate(new ImmutableStyleInfo(
        this,
        this.get,
        this.init,
        this.with,
        this.withUnaryOperator,
        this.add,
        this.addAll,
        this.put,
        this.putAll,
        this.copyOf,
        this.of,
        this.instance,
        this.builder,
        this.newBuilder,
        this.from,
        this.build,
        this.buildOrThrow,
        this.canBuild,
        this.toBuilder,
        this.underrideHashCode,
        this.underrideEquals,
        this.underrideToString,
        this.delegateToString,
        this.includeHashCode,
        this.isInitialized,
        this.isSet,
        this.set,
        this.unset,
        this.clear,
        this.create,
        this.toImmutable,
        this.typeBuilder,
        this.typeInnerBuilder,
        this.typeAbstract,
        this.typeImmutable,
        this.typeImmutableEnclosing,
        this.typeImmutableNested,
        this.typeModifiable,
        this.typeInnerModifiable,
        this.typeWith,
        this.packageGenerated,
        this.defaults,
        this.strictBuilder,
        this.strictModifiable,
        this.validationMethod,
        this.allParameters,
        this.defaultAsDefault,
        this.headerComments,
        this.jdkOnly,
        this.jdk9Collections,
        this.passAnnotationsNames,
        this.additionalJsonAnnotationsNames,
        this.visibility,
        this.visibilityString,
        this.optionalAcceptNullable,
        this.generateSuppressAllWarnings,
        this.privateNoargConstructor,
        this.protectedNoargConstructor,
        this.attributelessSingleton,
        this.unsafeDefaultAndDerived,
        this.clearBuilder,
        this.isSetOnBuilder,
        this.deferCollectionAllocation,
        this.deepImmutablesDetection,
        this.overshadowImplementation,
        this.implementationNestedInBuilder,
        this.forceJacksonPropertyNames,
        this.setJacksonPropertyRequired,
        this.forceJacksonIgnoreFields,
        this.forceEqualsInWithers,
        this.jacksonIntegration,
        this.weakInterning,
        this.alwaysPublicInitializers,
        this.builderVisibility,
        this.builderVisibilityString,
        this.throwForInvalidImmutableStateName,
        this.throwForNullPointerName,
        this.depluralize,
        this.depluralizeDictionary,
        this.immutableCopyOfRoutinesNames,
        this.stagedBuilder,
        this.builtinContainerAttributes,
        this.beanFriendlyModifiables,
        this.allMandatoryParameters,
        this.transientDerivedFields,
        this.finalInstanceFields,
        this.redactedMask,
        this.attributeBuilderDetection,
        this.attributeBuilder,
        this.getBuilder,
        this.setBuilder,
        this.addBuilder,
        this.addAllBuilder,
        this.getBuilders,
        this.nullableAnnotation,
        this.allowedClasspathAnnotationsNames,
        this.fallbackNullableAnnotationName,
        this.limitStringLengthInToString,
        this.jakarta,
        this.legacyAccessorOrdering,
        this.builderToString,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStyleInfo} that have equal attribute values.
   * As instances of the {@code ImmutableStyleInfo} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(ImmutableStyleInfo another) {
    return Arrays.equals(get, another.get)
        && init.equals(another.init)
        && with.equals(another.with)
        && withUnaryOperator.equals(another.withUnaryOperator)
        && add.equals(another.add)
        && addAll.equals(another.addAll)
        && put.equals(another.put)
        && putAll.equals(another.putAll)
        && copyOf.equals(another.copyOf)
        && of.equals(another.of)
        && instance.equals(another.instance)
        && builder.equals(another.builder)
        && newBuilder.equals(another.newBuilder)
        && from.equals(another.from)
        && build.equals(another.build)
        && buildOrThrow.equals(another.buildOrThrow)
        && canBuild.equals(another.canBuild)
        && toBuilder.equals(another.toBuilder)
        && underrideHashCode.equals(another.underrideHashCode)
        && underrideEquals.equals(another.underrideEquals)
        && underrideToString.equals(another.underrideToString)
        && delegateToString.equals(another.delegateToString)
        && includeHashCode.equals(another.includeHashCode)
        && isInitialized.equals(another.isInitialized)
        && isSet.equals(another.isSet)
        && set.equals(another.set)
        && unset.equals(another.unset)
        && clear.equals(another.clear)
        && create.equals(another.create)
        && toImmutable.equals(another.toImmutable)
        && typeBuilder.equals(another.typeBuilder)
        && typeInnerBuilder.equals(another.typeInnerBuilder)
        && Arrays.equals(typeAbstract, another.typeAbstract)
        && typeImmutable.equals(another.typeImmutable)
        && typeImmutableEnclosing.equals(another.typeImmutableEnclosing)
        && typeImmutableNested.equals(another.typeImmutableNested)
        && typeModifiable.equals(another.typeModifiable)
        && typeInnerModifiable.equals(another.typeInnerModifiable)
        && typeWith.equals(another.typeWith)
        && packageGenerated.equals(another.packageGenerated)
        && defaults.equals(another.defaults)
        && strictBuilder == another.strictBuilder
        && strictModifiable == another.strictModifiable
        && validationMethod.equals(another.validationMethod)
        && allParameters == another.allParameters
        && defaultAsDefault == another.defaultAsDefault
        && headerComments == another.headerComments
        && jdkOnly == another.jdkOnly
        && jdk9Collections == another.jdk9Collections
        && passAnnotationsNames.equals(another.passAnnotationsNames)
        && additionalJsonAnnotationsNames.equals(another.additionalJsonAnnotationsNames)
        && visibility.equals(another.visibility)
        && visibilityString.equals(another.visibilityString)
        && optionalAcceptNullable == another.optionalAcceptNullable
        && generateSuppressAllWarnings == another.generateSuppressAllWarnings
        && privateNoargConstructor == another.privateNoargConstructor
        && protectedNoargConstructor == another.protectedNoargConstructor
        && attributelessSingleton == another.attributelessSingleton
        && unsafeDefaultAndDerived == another.unsafeDefaultAndDerived
        && clearBuilder == another.clearBuilder
        && isSetOnBuilder == another.isSetOnBuilder
        && deferCollectionAllocation == another.deferCollectionAllocation
        && deepImmutablesDetection == another.deepImmutablesDetection
        && overshadowImplementation == another.overshadowImplementation
        && implementationNestedInBuilder == another.implementationNestedInBuilder
        && forceJacksonPropertyNames == another.forceJacksonPropertyNames
        && setJacksonPropertyRequired == another.setJacksonPropertyRequired
        && forceJacksonIgnoreFields == another.forceJacksonIgnoreFields
        && forceEqualsInWithers == another.forceEqualsInWithers
        && jacksonIntegration == another.jacksonIntegration
        && weakInterning == another.weakInterning
        && alwaysPublicInitializers == another.alwaysPublicInitializers
        && builderVisibility.equals(another.builderVisibility)
        && builderVisibilityString.equals(another.builderVisibilityString)
        && throwForInvalidImmutableStateName.equals(another.throwForInvalidImmutableStateName)
        && throwForNullPointerName.equals(another.throwForNullPointerName)
        && depluralize == another.depluralize
        && Arrays.equals(depluralizeDictionary, another.depluralizeDictionary)
        && immutableCopyOfRoutinesNames.equals(another.immutableCopyOfRoutinesNames)
        && stagedBuilder == another.stagedBuilder
        && builtinContainerAttributes == another.builtinContainerAttributes
        && beanFriendlyModifiables == another.beanFriendlyModifiables
        && allMandatoryParameters == another.allMandatoryParameters
        && transientDerivedFields == another.transientDerivedFields
        && finalInstanceFields == another.finalInstanceFields
        && redactedMask.equals(another.redactedMask)
        && attributeBuilderDetection == another.attributeBuilderDetection
        && Arrays.equals(attributeBuilder, another.attributeBuilder)
        && getBuilder.equals(another.getBuilder)
        && setBuilder.equals(another.setBuilder)
        && addBuilder.equals(another.addBuilder)
        && addAllBuilder.equals(another.addAllBuilder)
        && getBuilders.equals(another.getBuilders)
        && nullableAnnotation.equals(another.nullableAnnotation)
        && allowedClasspathAnnotationsNames.equals(another.allowedClasspathAnnotationsNames)
        && fallbackNullableAnnotationName.equals(another.fallbackNullableAnnotationName)
        && limitStringLengthInToString == another.limitStringLengthInToString
        && jakarta == another.jakarta
        && legacyAccessorOrdering == another.legacyAccessorOrdering
        && builderToString == another.builderToString
        && mergeFromSupertypesDynamically == another.mergeFromSupertypesDynamically;
  }

  /**
   * Computes a hash code from attributes: {@code get}, {@code init}, {@code with}, {@code withUnaryOperator}, {@code add}, {@code addAll}, {@code put}, {@code putAll}, {@code copyOf}, {@code of}, {@code instance}, {@code builder}, {@code newBuilder}, {@code from}, {@code build}, {@code buildOrThrow}, {@code canBuild}, {@code toBuilder}, {@code underrideHashCode}, {@code underrideEquals}, {@code underrideToString}, {@code delegateToString}, {@code includeHashCode}, {@code isInitialized}, {@code isSet}, {@code set}, {@code unset}, {@code clear}, {@code create}, {@code toImmutable}, {@code typeBuilder}, {@code typeInnerBuilder}, {@code typeAbstract}, {@code typeImmutable}, {@code typeImmutableEnclosing}, {@code typeImmutableNested}, {@code typeModifiable}, {@code typeInnerModifiable}, {@code typeWith}, {@code packageGenerated}, {@code defaults}, {@code strictBuilder}, {@code strictModifiable}, {@code validationMethod}, {@code allParameters}, {@code defaultAsDefault}, {@code headerComments}, {@code jdkOnly}, {@code jdk9Collections}, {@code passAnnotationsNames}, {@code additionalJsonAnnotationsNames}, {@code visibility}, {@code visibilityString}, {@code optionalAcceptNullable}, {@code generateSuppressAllWarnings}, {@code privateNoargConstructor}, {@code protectedNoargConstructor}, {@code attributelessSingleton}, {@code unsafeDefaultAndDerived}, {@code clearBuilder}, {@code isSetOnBuilder}, {@code deferCollectionAllocation}, {@code deepImmutablesDetection}, {@code overshadowImplementation}, {@code implementationNestedInBuilder}, {@code forceJacksonPropertyNames}, {@code setJacksonPropertyRequired}, {@code forceJacksonIgnoreFields}, {@code forceEqualsInWithers}, {@code jacksonIntegration}, {@code weakInterning}, {@code alwaysPublicInitializers}, {@code builderVisibility}, {@code builderVisibilityString}, {@code throwForInvalidImmutableStateName}, {@code throwForNullPointerName}, {@code depluralize}, {@code depluralizeDictionary}, {@code immutableCopyOfRoutinesNames}, {@code stagedBuilder}, {@code builtinContainerAttributes}, {@code beanFriendlyModifiables}, {@code allMandatoryParameters}, {@code transientDerivedFields}, {@code finalInstanceFields}, {@code redactedMask}, {@code attributeBuilderDetection}, {@code attributeBuilder}, {@code getBuilder}, {@code setBuilder}, {@code addBuilder}, {@code addAllBuilder}, {@code getBuilders}, {@code nullableAnnotation}, {@code allowedClasspathAnnotationsNames}, {@code fallbackNullableAnnotationName}, {@code limitStringLengthInToString}, {@code jakarta}, {@code legacyAccessorOrdering}, {@code builderToString}, {@code mergeFromSupertypesDynamically}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(get);
    h += (h << 5) + init.hashCode();
    h += (h << 5) + with.hashCode();
    h += (h << 5) + withUnaryOperator.hashCode();
    h += (h << 5) + add.hashCode();
    h += (h << 5) + addAll.hashCode();
    h += (h << 5) + put.hashCode();
    h += (h << 5) + putAll.hashCode();
    h += (h << 5) + copyOf.hashCode();
    h += (h << 5) + of.hashCode();
    h += (h << 5) + instance.hashCode();
    h += (h << 5) + builder.hashCode();
    h += (h << 5) + newBuilder.hashCode();
    h += (h << 5) + from.hashCode();
    h += (h << 5) + build.hashCode();
    h += (h << 5) + buildOrThrow.hashCode();
    h += (h << 5) + canBuild.hashCode();
    h += (h << 5) + toBuilder.hashCode();
    h += (h << 5) + underrideHashCode.hashCode();
    h += (h << 5) + underrideEquals.hashCode();
    h += (h << 5) + underrideToString.hashCode();
    h += (h << 5) + delegateToString.hashCode();
    h += (h << 5) + includeHashCode.hashCode();
    h += (h << 5) + isInitialized.hashCode();
    h += (h << 5) + isSet.hashCode();
    h += (h << 5) + set.hashCode();
    h += (h << 5) + unset.hashCode();
    h += (h << 5) + clear.hashCode();
    h += (h << 5) + create.hashCode();
    h += (h << 5) + toImmutable.hashCode();
    h += (h << 5) + typeBuilder.hashCode();
    h += (h << 5) + typeInnerBuilder.hashCode();
    h += (h << 5) + Arrays.hashCode(typeAbstract);
    h += (h << 5) + typeImmutable.hashCode();
    h += (h << 5) + typeImmutableEnclosing.hashCode();
    h += (h << 5) + typeImmutableNested.hashCode();
    h += (h << 5) + typeModifiable.hashCode();
    h += (h << 5) + typeInnerModifiable.hashCode();
    h += (h << 5) + typeWith.hashCode();
    h += (h << 5) + packageGenerated.hashCode();
    h += (h << 5) + defaults.hashCode();
    h += (h << 5) + Booleans.hashCode(strictBuilder);
    h += (h << 5) + Booleans.hashCode(strictModifiable);
    h += (h << 5) + validationMethod.hashCode();
    h += (h << 5) + Booleans.hashCode(allParameters);
    h += (h << 5) + Booleans.hashCode(defaultAsDefault);
    h += (h << 5) + Booleans.hashCode(headerComments);
    h += (h << 5) + Booleans.hashCode(jdkOnly);
    h += (h << 5) + Booleans.hashCode(jdk9Collections);
    h += (h << 5) + passAnnotationsNames.hashCode();
    h += (h << 5) + additionalJsonAnnotationsNames.hashCode();
    h += (h << 5) + visibility.hashCode();
    h += (h << 5) + visibilityString.hashCode();
    h += (h << 5) + Booleans.hashCode(optionalAcceptNullable);
    h += (h << 5) + Booleans.hashCode(generateSuppressAllWarnings);
    h += (h << 5) + Booleans.hashCode(privateNoargConstructor);
    h += (h << 5) + Booleans.hashCode(protectedNoargConstructor);
    h += (h << 5) + Booleans.hashCode(attributelessSingleton);
    h += (h << 5) + Booleans.hashCode(unsafeDefaultAndDerived);
    h += (h << 5) + Booleans.hashCode(clearBuilder);
    h += (h << 5) + Booleans.hashCode(isSetOnBuilder);
    h += (h << 5) + Booleans.hashCode(deferCollectionAllocation);
    h += (h << 5) + Booleans.hashCode(deepImmutablesDetection);
    h += (h << 5) + Booleans.hashCode(overshadowImplementation);
    h += (h << 5) + Booleans.hashCode(implementationNestedInBuilder);
    h += (h << 5) + Booleans.hashCode(forceJacksonPropertyNames);
    h += (h << 5) + Booleans.hashCode(setJacksonPropertyRequired);
    h += (h << 5) + Booleans.hashCode(forceJacksonIgnoreFields);
    h += (h << 5) + Booleans.hashCode(forceEqualsInWithers);
    h += (h << 5) + Booleans.hashCode(jacksonIntegration);
    h += (h << 5) + Booleans.hashCode(weakInterning);
    h += (h << 5) + Booleans.hashCode(alwaysPublicInitializers);
    h += (h << 5) + builderVisibility.hashCode();
    h += (h << 5) + builderVisibilityString.hashCode();
    h += (h << 5) + throwForInvalidImmutableStateName.hashCode();
    h += (h << 5) + throwForNullPointerName.hashCode();
    h += (h << 5) + Booleans.hashCode(depluralize);
    h += (h << 5) + Arrays.hashCode(depluralizeDictionary);
    h += (h << 5) + immutableCopyOfRoutinesNames.hashCode();
    h += (h << 5) + Booleans.hashCode(stagedBuilder);
    h += (h << 5) + Booleans.hashCode(builtinContainerAttributes);
    h += (h << 5) + Booleans.hashCode(beanFriendlyModifiables);
    h += (h << 5) + Booleans.hashCode(allMandatoryParameters);
    h += (h << 5) + Booleans.hashCode(transientDerivedFields);
    h += (h << 5) + Booleans.hashCode(finalInstanceFields);
    h += (h << 5) + redactedMask.hashCode();
    h += (h << 5) + Booleans.hashCode(attributeBuilderDetection);
    h += (h << 5) + Arrays.hashCode(attributeBuilder);
    h += (h << 5) + getBuilder.hashCode();
    h += (h << 5) + setBuilder.hashCode();
    h += (h << 5) + addBuilder.hashCode();
    h += (h << 5) + addAllBuilder.hashCode();
    h += (h << 5) + getBuilders.hashCode();
    h += (h << 5) + nullableAnnotation.hashCode();
    h += (h << 5) + allowedClasspathAnnotationsNames.hashCode();
    h += (h << 5) + fallbackNullableAnnotationName.hashCode();
    h += (h << 5) + limitStringLengthInToString;
    h += (h << 5) + Booleans.hashCode(jakarta);
    h += (h << 5) + Booleans.hashCode(legacyAccessorOrdering);
    h += (h << 5) + Booleans.hashCode(builderToString);
    h += (h << 5) + Booleans.hashCode(mergeFromSupertypesDynamically);
    return h;
  }

  /**
   * Prints the immutable value {@code StyleInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StyleInfo")
        .omitNullValues()
        .add("get", Arrays.toString(get))
        .add("init", init)
        .add("with", with)
        .add("withUnaryOperator", withUnaryOperator)
        .add("add", add)
        .add("addAll", addAll)
        .add("put", put)
        .add("putAll", putAll)
        .add("copyOf", copyOf)
        .add("of", of)
        .add("instance", instance)
        .add("builder", builder)
        .add("newBuilder", newBuilder)
        .add("from", from)
        .add("build", build)
        .add("buildOrThrow", buildOrThrow)
        .add("canBuild", canBuild)
        .add("toBuilder", toBuilder)
        .add("underrideHashCode", underrideHashCode)
        .add("underrideEquals", underrideEquals)
        .add("underrideToString", underrideToString)
        .add("delegateToString", delegateToString)
        .add("includeHashCode", includeHashCode)
        .add("isInitialized", isInitialized)
        .add("isSet", isSet)
        .add("set", set)
        .add("unset", unset)
        .add("clear", clear)
        .add("create", create)
        .add("toImmutable", toImmutable)
        .add("typeBuilder", typeBuilder)
        .add("typeInnerBuilder", typeInnerBuilder)
        .add("typeAbstract", Arrays.toString(typeAbstract))
        .add("typeImmutable", typeImmutable)
        .add("typeImmutableEnclosing", typeImmutableEnclosing)
        .add("typeImmutableNested", typeImmutableNested)
        .add("typeModifiable", typeModifiable)
        .add("typeInnerModifiable", typeInnerModifiable)
        .add("typeWith", typeWith)
        .add("packageGenerated", packageGenerated)
        .add("defaults", defaults)
        .add("strictBuilder", strictBuilder)
        .add("strictModifiable", strictModifiable)
        .add("validationMethod", validationMethod)
        .add("allParameters", allParameters)
        .add("defaultAsDefault", defaultAsDefault)
        .add("headerComments", headerComments)
        .add("jdkOnly", jdkOnly)
        .add("jdk9Collections", jdk9Collections)
        .add("passAnnotationsNames", passAnnotationsNames)
        .add("additionalJsonAnnotationsNames", additionalJsonAnnotationsNames)
        .add("visibility", visibility)
        .add("visibilityString", visibilityString)
        .add("optionalAcceptNullable", optionalAcceptNullable)
        .add("generateSuppressAllWarnings", generateSuppressAllWarnings)
        .add("privateNoargConstructor", privateNoargConstructor)
        .add("protectedNoargConstructor", protectedNoargConstructor)
        .add("attributelessSingleton", attributelessSingleton)
        .add("unsafeDefaultAndDerived", unsafeDefaultAndDerived)
        .add("clearBuilder", clearBuilder)
        .add("isSetOnBuilder", isSetOnBuilder)
        .add("deferCollectionAllocation", deferCollectionAllocation)
        .add("deepImmutablesDetection", deepImmutablesDetection)
        .add("overshadowImplementation", overshadowImplementation)
        .add("implementationNestedInBuilder", implementationNestedInBuilder)
        .add("forceJacksonPropertyNames", forceJacksonPropertyNames)
        .add("setJacksonPropertyRequired", setJacksonPropertyRequired)
        .add("forceJacksonIgnoreFields", forceJacksonIgnoreFields)
        .add("forceEqualsInWithers", forceEqualsInWithers)
        .add("jacksonIntegration", jacksonIntegration)
        .add("weakInterning", weakInterning)
        .add("alwaysPublicInitializers", alwaysPublicInitializers)
        .add("builderVisibility", builderVisibility)
        .add("builderVisibilityString", builderVisibilityString)
        .add("throwForInvalidImmutableStateName", throwForInvalidImmutableStateName)
        .add("throwForNullPointerName", throwForNullPointerName)
        .add("depluralize", depluralize)
        .add("depluralizeDictionary", Arrays.toString(depluralizeDictionary))
        .add("immutableCopyOfRoutinesNames", immutableCopyOfRoutinesNames)
        .add("stagedBuilder", stagedBuilder)
        .add("builtinContainerAttributes", builtinContainerAttributes)
        .add("beanFriendlyModifiables", beanFriendlyModifiables)
        .add("allMandatoryParameters", allMandatoryParameters)
        .add("transientDerivedFields", transientDerivedFields)
        .add("finalInstanceFields", finalInstanceFields)
        .add("redactedMask", redactedMask)
        .add("attributeBuilderDetection", attributeBuilderDetection)
        .add("attributeBuilder", Arrays.toString(attributeBuilder))
        .add("getBuilder", getBuilder)
        .add("setBuilder", setBuilder)
        .add("addBuilder", addBuilder)
        .add("addAllBuilder", addAllBuilder)
        .add("getBuilders", getBuilders)
        .add("nullableAnnotation", nullableAnnotation)
        .add("allowedClasspathAnnotationsNames", allowedClasspathAnnotationsNames)
        .add("fallbackNullableAnnotationName", fallbackNullableAnnotationName)
        .add("limitStringLengthInToString", limitStringLengthInToString)
        .add("jakarta", jakarta)
        .add("legacyAccessorOrdering", legacyAccessorOrdering)
        .add("builderToString", builderToString)
        .add("mergeFromSupertypesDynamically", mergeFromSupertypesDynamically)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long GET_STYLES_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Styles getStyles;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link StyleInfo#getStyles() getStyles} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code getStyles} attribute
   */
  @Override
  public Styles getStyles() {
    if ((lazyInitBitmap & GET_STYLES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & GET_STYLES_LAZY_INIT_BIT) == 0) {
          this.getStyles = Objects.requireNonNull(super.getStyles(), "getStyles");
          lazyInitBitmap |= GET_STYLES_LAZY_INIT_BIT;
        }
      }
    }
    return getStyles;
  }

  @Generated(from = "StyleInfo", generator = "Immutables")
  private static class InternProxy {
    final ImmutableStyleInfo instance;

    InternProxy(ImmutableStyleInfo instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

  /**
   * Construct a new immutable {@code StyleInfo} instance.
   * @param get The value for the {@code get} attribute
   * @param init The value for the {@code init} attribute
   * @param with The value for the {@code with} attribute
   * @param withUnaryOperator The value for the {@code withUnaryOperator} attribute
   * @param add The value for the {@code add} attribute
   * @param addAll The value for the {@code addAll} attribute
   * @param put The value for the {@code put} attribute
   * @param putAll The value for the {@code putAll} attribute
   * @param copyOf The value for the {@code copyOf} attribute
   * @param of The value for the {@code of} attribute
   * @param instance The value for the {@code instance} attribute
   * @param builder The value for the {@code builder} attribute
   * @param newBuilder The value for the {@code newBuilder} attribute
   * @param from The value for the {@code from} attribute
   * @param build The value for the {@code build} attribute
   * @param buildOrThrow The value for the {@code buildOrThrow} attribute
   * @param canBuild The value for the {@code canBuild} attribute
   * @param toBuilder The value for the {@code toBuilder} attribute
   * @param underrideHashCode The value for the {@code underrideHashCode} attribute
   * @param underrideEquals The value for the {@code underrideEquals} attribute
   * @param underrideToString The value for the {@code underrideToString} attribute
   * @param delegateToString The value for the {@code delegateToString} attribute
   * @param includeHashCode The value for the {@code includeHashCode} attribute
   * @param isInitialized The value for the {@code isInitialized} attribute
   * @param isSet The value for the {@code isSet} attribute
   * @param set The value for the {@code set} attribute
   * @param unset The value for the {@code unset} attribute
   * @param clear The value for the {@code clear} attribute
   * @param create The value for the {@code create} attribute
   * @param toImmutable The value for the {@code toImmutable} attribute
   * @param typeBuilder The value for the {@code typeBuilder} attribute
   * @param typeInnerBuilder The value for the {@code typeInnerBuilder} attribute
   * @param typeAbstract The value for the {@code typeAbstract} attribute
   * @param typeImmutable The value for the {@code typeImmutable} attribute
   * @param typeImmutableEnclosing The value for the {@code typeImmutableEnclosing} attribute
   * @param typeImmutableNested The value for the {@code typeImmutableNested} attribute
   * @param typeModifiable The value for the {@code typeModifiable} attribute
   * @param typeInnerModifiable The value for the {@code typeInnerModifiable} attribute
   * @param typeWith The value for the {@code typeWith} attribute
   * @param packageGenerated The value for the {@code packageGenerated} attribute
   * @param defaults The value for the {@code defaults} attribute
   * @param strictBuilder The value for the {@code strictBuilder} attribute
   * @param strictModifiable The value for the {@code strictModifiable} attribute
   * @param validationMethod The value for the {@code validationMethod} attribute
   * @param allParameters The value for the {@code allParameters} attribute
   * @param defaultAsDefault The value for the {@code defaultAsDefault} attribute
   * @param headerComments The value for the {@code headerComments} attribute
   * @param jdkOnly The value for the {@code jdkOnly} attribute
   * @param jdk9Collections The value for the {@code jdk9Collections} attribute
   * @param passAnnotationsNames The value for the {@code passAnnotationsNames} attribute
   * @param additionalJsonAnnotationsNames The value for the {@code additionalJsonAnnotationsNames} attribute
   * @param visibility The value for the {@code visibility} attribute
   * @param visibilityString The value for the {@code visibilityString} attribute
   * @param optionalAcceptNullable The value for the {@code optionalAcceptNullable} attribute
   * @param generateSuppressAllWarnings The value for the {@code generateSuppressAllWarnings} attribute
   * @param privateNoargConstructor The value for the {@code privateNoargConstructor} attribute
   * @param protectedNoargConstructor The value for the {@code protectedNoargConstructor} attribute
   * @param attributelessSingleton The value for the {@code attributelessSingleton} attribute
   * @param unsafeDefaultAndDerived The value for the {@code unsafeDefaultAndDerived} attribute
   * @param clearBuilder The value for the {@code clearBuilder} attribute
   * @param isSetOnBuilder The value for the {@code isSetOnBuilder} attribute
   * @param deferCollectionAllocation The value for the {@code deferCollectionAllocation} attribute
   * @param deepImmutablesDetection The value for the {@code deepImmutablesDetection} attribute
   * @param overshadowImplementation The value for the {@code overshadowImplementation} attribute
   * @param implementationNestedInBuilder The value for the {@code implementationNestedInBuilder} attribute
   * @param forceJacksonPropertyNames The value for the {@code forceJacksonPropertyNames} attribute
   * @param setJacksonPropertyRequired The value for the {@code setJacksonPropertyRequired} attribute
   * @param forceJacksonIgnoreFields The value for the {@code forceJacksonIgnoreFields} attribute
   * @param forceEqualsInWithers The value for the {@code forceEqualsInWithers} attribute
   * @param jacksonIntegration The value for the {@code jacksonIntegration} attribute
   * @param weakInterning The value for the {@code weakInterning} attribute
   * @param alwaysPublicInitializers The value for the {@code alwaysPublicInitializers} attribute
   * @param builderVisibility The value for the {@code builderVisibility} attribute
   * @param builderVisibilityString The value for the {@code builderVisibilityString} attribute
   * @param throwForInvalidImmutableStateName The value for the {@code throwForInvalidImmutableStateName} attribute
   * @param throwForNullPointerName The value for the {@code throwForNullPointerName} attribute
   * @param depluralize The value for the {@code depluralize} attribute
   * @param depluralizeDictionary The value for the {@code depluralizeDictionary} attribute
   * @param immutableCopyOfRoutinesNames The value for the {@code immutableCopyOfRoutinesNames} attribute
   * @param stagedBuilder The value for the {@code stagedBuilder} attribute
   * @param builtinContainerAttributes The value for the {@code builtinContainerAttributes} attribute
   * @param beanFriendlyModifiables The value for the {@code beanFriendlyModifiables} attribute
   * @param allMandatoryParameters The value for the {@code allMandatoryParameters} attribute
   * @param transientDerivedFields The value for the {@code transientDerivedFields} attribute
   * @param finalInstanceFields The value for the {@code finalInstanceFields} attribute
   * @param redactedMask The value for the {@code redactedMask} attribute
   * @param attributeBuilderDetection The value for the {@code attributeBuilderDetection} attribute
   * @param attributeBuilder The value for the {@code attributeBuilder} attribute
   * @param getBuilder The value for the {@code getBuilder} attribute
   * @param setBuilder The value for the {@code setBuilder} attribute
   * @param addBuilder The value for the {@code addBuilder} attribute
   * @param addAllBuilder The value for the {@code addAllBuilder} attribute
   * @param getBuilders The value for the {@code getBuilders} attribute
   * @param nullableAnnotation The value for the {@code nullableAnnotation} attribute
   * @param allowedClasspathAnnotationsNames The value for the {@code allowedClasspathAnnotationsNames} attribute
   * @param fallbackNullableAnnotationName The value for the {@code fallbackNullableAnnotationName} attribute
   * @param limitStringLengthInToString The value for the {@code limitStringLengthInToString} attribute
   * @param jakarta The value for the {@code jakarta} attribute
   * @param legacyAccessorOrdering The value for the {@code legacyAccessorOrdering} attribute
   * @param builderToString The value for the {@code builderToString} attribute
   * @param mergeFromSupertypesDynamically The value for the {@code mergeFromSupertypesDynamically} attribute
   * @return An immutable StyleInfo instance
   */
  public static ImmutableStyleInfo of(String[] get, String init, String with, String withUnaryOperator, String add, String addAll, String put, String putAll, String copyOf, String of, String instance, String builder, String newBuilder, String from, String build, String buildOrThrow, String canBuild, String toBuilder, String underrideHashCode, String underrideEquals, String underrideToString, String delegateToString, String includeHashCode, String isInitialized, String isSet, String set, String unset, String clear, String create, String toImmutable, String typeBuilder, String typeInnerBuilder, String[] typeAbstract, String typeImmutable, String typeImmutableEnclosing, String typeImmutableNested, String typeModifiable, String typeInnerModifiable, String typeWith, String packageGenerated, ValueImmutableInfo defaults, boolean strictBuilder, boolean strictModifiable, ValueMirrors.Style.ValidationMethod validationMethod, boolean allParameters, boolean defaultAsDefault, boolean headerComments, boolean jdkOnly, boolean jdk9Collections, ImmutableSet<String> passAnnotationsNames, ImmutableSet<String> additionalJsonAnnotationsNames, ValueMirrors.Style.ImplementationVisibility visibility, String visibilityString, boolean optionalAcceptNullable, boolean generateSuppressAllWarnings, boolean privateNoargConstructor, boolean protectedNoargConstructor, boolean attributelessSingleton, boolean unsafeDefaultAndDerived, boolean clearBuilder, boolean isSetOnBuilder, boolean deferCollectionAllocation, boolean deepImmutablesDetection, boolean overshadowImplementation, boolean implementationNestedInBuilder, boolean forceJacksonPropertyNames, boolean setJacksonPropertyRequired, boolean forceJacksonIgnoreFields, boolean forceEqualsInWithers, boolean jacksonIntegration, boolean weakInterning, boolean alwaysPublicInitializers, ValueMirrors.Style.BuilderVisibility builderVisibility, String builderVisibilityString, String throwForInvalidImmutableStateName, String throwForNullPointerName, boolean depluralize, String[] depluralizeDictionary, ImmutableSet<String> immutableCopyOfRoutinesNames, boolean stagedBuilder, boolean builtinContainerAttributes, boolean beanFriendlyModifiables, boolean allMandatoryParameters, boolean transientDerivedFields, boolean finalInstanceFields, String redactedMask, boolean attributeBuilderDetection, String[] attributeBuilder, String getBuilder, String setBuilder, String addBuilder, String addAllBuilder, String getBuilders, String nullableAnnotation, ImmutableSet<String> allowedClasspathAnnotationsNames, String fallbackNullableAnnotationName, int limitStringLengthInToString, boolean jakarta, boolean legacyAccessorOrdering, boolean builderToString, boolean mergeFromSupertypesDynamically) {
    return of(get, init, with, withUnaryOperator, add, addAll, put, putAll, copyOf, of, instance, builder, newBuilder, from, build, buildOrThrow, canBuild, toBuilder, underrideHashCode, underrideEquals, underrideToString, delegateToString, includeHashCode, isInitialized, isSet, set, unset, clear, create, toImmutable, typeBuilder, typeInnerBuilder, typeAbstract, typeImmutable, typeImmutableEnclosing, typeImmutableNested, typeModifiable, typeInnerModifiable, typeWith, packageGenerated, defaults, strictBuilder, strictModifiable, validationMethod, allParameters, defaultAsDefault, headerComments, jdkOnly, jdk9Collections, (Iterable<String>) passAnnotationsNames, (Iterable<String>) additionalJsonAnnotationsNames, visibility, visibilityString, optionalAcceptNullable, generateSuppressAllWarnings, privateNoargConstructor, protectedNoargConstructor, attributelessSingleton, unsafeDefaultAndDerived, clearBuilder, isSetOnBuilder, deferCollectionAllocation, deepImmutablesDetection, overshadowImplementation, implementationNestedInBuilder, forceJacksonPropertyNames, setJacksonPropertyRequired, forceJacksonIgnoreFields, forceEqualsInWithers, jacksonIntegration, weakInterning, alwaysPublicInitializers, builderVisibility, builderVisibilityString, throwForInvalidImmutableStateName, throwForNullPointerName, depluralize, depluralizeDictionary, (Iterable<String>) immutableCopyOfRoutinesNames, stagedBuilder, builtinContainerAttributes, beanFriendlyModifiables, allMandatoryParameters, transientDerivedFields, finalInstanceFields, redactedMask, attributeBuilderDetection, attributeBuilder, getBuilder, setBuilder, addBuilder, addAllBuilder, getBuilders, nullableAnnotation, (Iterable<String>) allowedClasspathAnnotationsNames, fallbackNullableAnnotationName, limitStringLengthInToString, jakarta, legacyAccessorOrdering, builderToString, mergeFromSupertypesDynamically);
  }

  /**
   * Construct a new immutable {@code StyleInfo} instance.
   * @param get The value for the {@code get} attribute
   * @param init The value for the {@code init} attribute
   * @param with The value for the {@code with} attribute
   * @param withUnaryOperator The value for the {@code withUnaryOperator} attribute
   * @param add The value for the {@code add} attribute
   * @param addAll The value for the {@code addAll} attribute
   * @param put The value for the {@code put} attribute
   * @param putAll The value for the {@code putAll} attribute
   * @param copyOf The value for the {@code copyOf} attribute
   * @param of The value for the {@code of} attribute
   * @param instance The value for the {@code instance} attribute
   * @param builder The value for the {@code builder} attribute
   * @param newBuilder The value for the {@code newBuilder} attribute
   * @param from The value for the {@code from} attribute
   * @param build The value for the {@code build} attribute
   * @param buildOrThrow The value for the {@code buildOrThrow} attribute
   * @param canBuild The value for the {@code canBuild} attribute
   * @param toBuilder The value for the {@code toBuilder} attribute
   * @param underrideHashCode The value for the {@code underrideHashCode} attribute
   * @param underrideEquals The value for the {@code underrideEquals} attribute
   * @param underrideToString The value for the {@code underrideToString} attribute
   * @param delegateToString The value for the {@code delegateToString} attribute
   * @param includeHashCode The value for the {@code includeHashCode} attribute
   * @param isInitialized The value for the {@code isInitialized} attribute
   * @param isSet The value for the {@code isSet} attribute
   * @param set The value for the {@code set} attribute
   * @param unset The value for the {@code unset} attribute
   * @param clear The value for the {@code clear} attribute
   * @param create The value for the {@code create} attribute
   * @param toImmutable The value for the {@code toImmutable} attribute
   * @param typeBuilder The value for the {@code typeBuilder} attribute
   * @param typeInnerBuilder The value for the {@code typeInnerBuilder} attribute
   * @param typeAbstract The value for the {@code typeAbstract} attribute
   * @param typeImmutable The value for the {@code typeImmutable} attribute
   * @param typeImmutableEnclosing The value for the {@code typeImmutableEnclosing} attribute
   * @param typeImmutableNested The value for the {@code typeImmutableNested} attribute
   * @param typeModifiable The value for the {@code typeModifiable} attribute
   * @param typeInnerModifiable The value for the {@code typeInnerModifiable} attribute
   * @param typeWith The value for the {@code typeWith} attribute
   * @param packageGenerated The value for the {@code packageGenerated} attribute
   * @param defaults The value for the {@code defaults} attribute
   * @param strictBuilder The value for the {@code strictBuilder} attribute
   * @param strictModifiable The value for the {@code strictModifiable} attribute
   * @param validationMethod The value for the {@code validationMethod} attribute
   * @param allParameters The value for the {@code allParameters} attribute
   * @param defaultAsDefault The value for the {@code defaultAsDefault} attribute
   * @param headerComments The value for the {@code headerComments} attribute
   * @param jdkOnly The value for the {@code jdkOnly} attribute
   * @param jdk9Collections The value for the {@code jdk9Collections} attribute
   * @param passAnnotationsNames The value for the {@code passAnnotationsNames} attribute
   * @param additionalJsonAnnotationsNames The value for the {@code additionalJsonAnnotationsNames} attribute
   * @param visibility The value for the {@code visibility} attribute
   * @param visibilityString The value for the {@code visibilityString} attribute
   * @param optionalAcceptNullable The value for the {@code optionalAcceptNullable} attribute
   * @param generateSuppressAllWarnings The value for the {@code generateSuppressAllWarnings} attribute
   * @param privateNoargConstructor The value for the {@code privateNoargConstructor} attribute
   * @param protectedNoargConstructor The value for the {@code protectedNoargConstructor} attribute
   * @param attributelessSingleton The value for the {@code attributelessSingleton} attribute
   * @param unsafeDefaultAndDerived The value for the {@code unsafeDefaultAndDerived} attribute
   * @param clearBuilder The value for the {@code clearBuilder} attribute
   * @param isSetOnBuilder The value for the {@code isSetOnBuilder} attribute
   * @param deferCollectionAllocation The value for the {@code deferCollectionAllocation} attribute
   * @param deepImmutablesDetection The value for the {@code deepImmutablesDetection} attribute
   * @param overshadowImplementation The value for the {@code overshadowImplementation} attribute
   * @param implementationNestedInBuilder The value for the {@code implementationNestedInBuilder} attribute
   * @param forceJacksonPropertyNames The value for the {@code forceJacksonPropertyNames} attribute
   * @param setJacksonPropertyRequired The value for the {@code setJacksonPropertyRequired} attribute
   * @param forceJacksonIgnoreFields The value for the {@code forceJacksonIgnoreFields} attribute
   * @param forceEqualsInWithers The value for the {@code forceEqualsInWithers} attribute
   * @param jacksonIntegration The value for the {@code jacksonIntegration} attribute
   * @param weakInterning The value for the {@code weakInterning} attribute
   * @param alwaysPublicInitializers The value for the {@code alwaysPublicInitializers} attribute
   * @param builderVisibility The value for the {@code builderVisibility} attribute
   * @param builderVisibilityString The value for the {@code builderVisibilityString} attribute
   * @param throwForInvalidImmutableStateName The value for the {@code throwForInvalidImmutableStateName} attribute
   * @param throwForNullPointerName The value for the {@code throwForNullPointerName} attribute
   * @param depluralize The value for the {@code depluralize} attribute
   * @param depluralizeDictionary The value for the {@code depluralizeDictionary} attribute
   * @param immutableCopyOfRoutinesNames The value for the {@code immutableCopyOfRoutinesNames} attribute
   * @param stagedBuilder The value for the {@code stagedBuilder} attribute
   * @param builtinContainerAttributes The value for the {@code builtinContainerAttributes} attribute
   * @param beanFriendlyModifiables The value for the {@code beanFriendlyModifiables} attribute
   * @param allMandatoryParameters The value for the {@code allMandatoryParameters} attribute
   * @param transientDerivedFields The value for the {@code transientDerivedFields} attribute
   * @param finalInstanceFields The value for the {@code finalInstanceFields} attribute
   * @param redactedMask The value for the {@code redactedMask} attribute
   * @param attributeBuilderDetection The value for the {@code attributeBuilderDetection} attribute
   * @param attributeBuilder The value for the {@code attributeBuilder} attribute
   * @param getBuilder The value for the {@code getBuilder} attribute
   * @param setBuilder The value for the {@code setBuilder} attribute
   * @param addBuilder The value for the {@code addBuilder} attribute
   * @param addAllBuilder The value for the {@code addAllBuilder} attribute
   * @param getBuilders The value for the {@code getBuilders} attribute
   * @param nullableAnnotation The value for the {@code nullableAnnotation} attribute
   * @param allowedClasspathAnnotationsNames The value for the {@code allowedClasspathAnnotationsNames} attribute
   * @param fallbackNullableAnnotationName The value for the {@code fallbackNullableAnnotationName} attribute
   * @param limitStringLengthInToString The value for the {@code limitStringLengthInToString} attribute
   * @param jakarta The value for the {@code jakarta} attribute
   * @param legacyAccessorOrdering The value for the {@code legacyAccessorOrdering} attribute
   * @param builderToString The value for the {@code builderToString} attribute
   * @param mergeFromSupertypesDynamically The value for the {@code mergeFromSupertypesDynamically} attribute
   * @return An immutable StyleInfo instance
   */
  public static ImmutableStyleInfo of(String[] get, String init, String with, String withUnaryOperator, String add, String addAll, String put, String putAll, String copyOf, String of, String instance, String builder, String newBuilder, String from, String build, String buildOrThrow, String canBuild, String toBuilder, String underrideHashCode, String underrideEquals, String underrideToString, String delegateToString, String includeHashCode, String isInitialized, String isSet, String set, String unset, String clear, String create, String toImmutable, String typeBuilder, String typeInnerBuilder, String[] typeAbstract, String typeImmutable, String typeImmutableEnclosing, String typeImmutableNested, String typeModifiable, String typeInnerModifiable, String typeWith, String packageGenerated, ValueImmutableInfo defaults, boolean strictBuilder, boolean strictModifiable, ValueMirrors.Style.ValidationMethod validationMethod, boolean allParameters, boolean defaultAsDefault, boolean headerComments, boolean jdkOnly, boolean jdk9Collections, Iterable<String> passAnnotationsNames, Iterable<String> additionalJsonAnnotationsNames, ValueMirrors.Style.ImplementationVisibility visibility, String visibilityString, boolean optionalAcceptNullable, boolean generateSuppressAllWarnings, boolean privateNoargConstructor, boolean protectedNoargConstructor, boolean attributelessSingleton, boolean unsafeDefaultAndDerived, boolean clearBuilder, boolean isSetOnBuilder, boolean deferCollectionAllocation, boolean deepImmutablesDetection, boolean overshadowImplementation, boolean implementationNestedInBuilder, boolean forceJacksonPropertyNames, boolean setJacksonPropertyRequired, boolean forceJacksonIgnoreFields, boolean forceEqualsInWithers, boolean jacksonIntegration, boolean weakInterning, boolean alwaysPublicInitializers, ValueMirrors.Style.BuilderVisibility builderVisibility, String builderVisibilityString, String throwForInvalidImmutableStateName, String throwForNullPointerName, boolean depluralize, String[] depluralizeDictionary, Iterable<String> immutableCopyOfRoutinesNames, boolean stagedBuilder, boolean builtinContainerAttributes, boolean beanFriendlyModifiables, boolean allMandatoryParameters, boolean transientDerivedFields, boolean finalInstanceFields, String redactedMask, boolean attributeBuilderDetection, String[] attributeBuilder, String getBuilder, String setBuilder, String addBuilder, String addAllBuilder, String getBuilders, String nullableAnnotation, Iterable<String> allowedClasspathAnnotationsNames, String fallbackNullableAnnotationName, int limitStringLengthInToString, boolean jakarta, boolean legacyAccessorOrdering, boolean builderToString, boolean mergeFromSupertypesDynamically) {
    return validate(new ImmutableStyleInfo(get, init, with, withUnaryOperator, add, addAll, put, putAll, copyOf, of, instance, builder, newBuilder, from, build, buildOrThrow, canBuild, toBuilder, underrideHashCode, underrideEquals, underrideToString, delegateToString, includeHashCode, isInitialized, isSet, set, unset, clear, create, toImmutable, typeBuilder, typeInnerBuilder, typeAbstract, typeImmutable, typeImmutableEnclosing, typeImmutableNested, typeModifiable, typeInnerModifiable, typeWith, packageGenerated, defaults, strictBuilder, strictModifiable, validationMethod, allParameters, defaultAsDefault, headerComments, jdkOnly, jdk9Collections, passAnnotationsNames, additionalJsonAnnotationsNames, visibility, visibilityString, optionalAcceptNullable, generateSuppressAllWarnings, privateNoargConstructor, protectedNoargConstructor, attributelessSingleton, unsafeDefaultAndDerived, clearBuilder, isSetOnBuilder, deferCollectionAllocation, deepImmutablesDetection, overshadowImplementation, implementationNestedInBuilder, forceJacksonPropertyNames, setJacksonPropertyRequired, forceJacksonIgnoreFields, forceEqualsInWithers, jacksonIntegration, weakInterning, alwaysPublicInitializers, builderVisibility, builderVisibilityString, throwForInvalidImmutableStateName, throwForNullPointerName, depluralize, depluralizeDictionary, immutableCopyOfRoutinesNames, stagedBuilder, builtinContainerAttributes, beanFriendlyModifiables, allMandatoryParameters, transientDerivedFields, finalInstanceFields, redactedMask, attributeBuilderDetection, attributeBuilder, getBuilder, setBuilder, addBuilder, addAllBuilder, getBuilders, nullableAnnotation, allowedClasspathAnnotationsNames, fallbackNullableAnnotationName, limitStringLengthInToString, jakarta, legacyAccessorOrdering, builderToString, mergeFromSupertypesDynamically));
  }

  private static ImmutableStyleInfo validate(ImmutableStyleInfo instance) {
    return INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link StyleInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StyleInfo instance
   */
  public static ImmutableStyleInfo copyOf(StyleInfo instance) {
    if (instance instanceof ImmutableStyleInfo) {
      return (ImmutableStyleInfo) instance;
    }
    return ImmutableStyleInfo.of(instance.get(), instance.init(), instance.with(), instance.withUnaryOperator(), instance.add(), instance.addAll(), instance.put(), instance.putAll(), instance.copyOf(), instance.of(), instance.instance(), instance.builder(), instance.newBuilder(), instance.from(), instance.build(), instance.buildOrThrow(), instance.canBuild(), instance.toBuilder(), instance.underrideHashCode(), instance.underrideEquals(), instance.underrideToString(), instance.delegateToString(), instance.includeHashCode(), instance.isInitialized(), instance.isSet(), instance.set(), instance.unset(), instance.clear(), instance.create(), instance.toImmutable(), instance.typeBuilder(), instance.typeInnerBuilder(), instance.typeAbstract(), instance.typeImmutable(), instance.typeImmutableEnclosing(), instance.typeImmutableNested(), instance.typeModifiable(), instance.typeInnerModifiable(), instance.typeWith(), instance.packageGenerated(), instance.defaults(), instance.strictBuilder(), instance.strictModifiable(), instance.validationMethod(), instance.allParameters(), instance.defaultAsDefault(), instance.headerComments(), instance.jdkOnly(), instance.jdk9Collections(), instance.passAnnotationsNames(), instance.additionalJsonAnnotationsNames(), instance.visibility(), instance.visibilityString(), instance.optionalAcceptNullable(), instance.generateSuppressAllWarnings(), instance.privateNoargConstructor(), instance.protectedNoargConstructor(), instance.attributelessSingleton(), instance.unsafeDefaultAndDerived(), instance.clearBuilder(), instance.isSetOnBuilder(), instance.deferCollectionAllocation(), instance.deepImmutablesDetection(), instance.overshadowImplementation(), instance.implementationNestedInBuilder(), instance.forceJacksonPropertyNames(), instance.setJacksonPropertyRequired(), instance.forceJacksonIgnoreFields(), instance.forceEqualsInWithers(), instance.jacksonIntegration(), instance.weakInterning(), instance.alwaysPublicInitializers(), instance.builderVisibility(), instance.builderVisibilityString(), instance.throwForInvalidImmutableStateName(), instance.throwForNullPointerName(), instance.depluralize(), instance.depluralizeDictionary(), instance.immutableCopyOfRoutinesNames(), instance.stagedBuilder(), instance.builtinContainerAttributes(), instance.beanFriendlyModifiables(), instance.allMandatoryParameters(), instance.transientDerivedFields(), instance.finalInstanceFields(), instance.redactedMask(), instance.attributeBuilderDetection(), instance.attributeBuilder(), instance.getBuilder(), instance.setBuilder(), instance.addBuilder(), instance.addAllBuilder(), instance.getBuilders(), instance.nullableAnnotation(), instance.allowedClasspathAnnotationsNames(), instance.fallbackNullableAnnotationName(), instance.limitStringLengthInToString(), instance.jakarta(), instance.legacyAccessorOrdering(), instance.builderToString(), instance.mergeFromSupertypesDynamically());
  }
}
