/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.immutables.generator.EnvironmentState;

public final class ExtensionLoader {
    private static final Splitter RESOURCE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();

    private ExtensionLoader() {
    }

    public static Supplier<ImmutableSet<String>> findExtensions(final String resource) {
        return Suppliers.memoize((Supplier)new Supplier<ImmutableSet<String>>(){

            public ImmutableSet<String> get() {
                ArrayList extensions = Lists.newArrayList();
                try {
                    String lines = ExtensionLoader.getClasspathResourceText(EnvironmentState.processing().getFiler(), resource);
                    extensions.addAll(RESOURCE_SPLITTER.splitToList((CharSequence)lines));
                }
                catch (IOException | RuntimeException lines) {
                    // empty catch block
                }
                ClassLoader classLoader = ExtensionLoader.class.getClassLoader();
                try {
                    Enumeration<URL> resources = classLoader.getResources(resource);
                    while (resources.hasMoreElements()) {
                        URL nextElement = resources.nextElement();
                        String lines = ExtensionLoader.getClasspathResourceText(nextElement);
                        extensions.addAll(RESOURCE_SPLITTER.splitToList((CharSequence)lines));
                    }
                }
                catch (IOException | RuntimeException exception) {
                    // empty catch block
                }
                return ImmutableSet.copyOf((Collection)extensions);
            }
        });
    }

    private static String getClasspathResourceText(Filer filer, String resourceName) throws IOException {
        FileObject resource = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName);
        try (Reader r = resource.openReader(true);){
            String string = CharStreams.toString((Readable)r);
            return string;
        }
    }

    private static String getClasspathResourceText(URL requestURL) throws IOException {
        URLConnection connection = requestURL.openConnection();
        connection.setUseCaches(false);
        try (InputStreamReader r = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
            String string = CharStreams.toString((Readable)r);
            return string;
        }
    }
}

