/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.util.Map;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;

public class Hbm2DDLExporterTask
extends ExporterTask {
    boolean exportToDatabase = true;
    boolean scriptToConsole = true;
    boolean schemaUpdate = false;
    String delimiter = ";";
    boolean drop = false;
    boolean create = true;
    boolean format = false;
    String outputFileName = null;
    private boolean haltOnError = false;

    public Hbm2DDLExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "hbm2ddl (Generates database schema)";
    }

    @Override
    protected Exporter configureExporter(Exporter exp) {
        Exporter exporter = super.configureExporter(exp);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ExportToDatabase", (Object)this.exportToDatabase);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ExportToConsole", (Object)this.scriptToConsole);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.SchemaUpdate", (Object)this.schemaUpdate);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.Delimiter", this.delimiter);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DropDatabase", (Object)this.drop);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.CreateDatabase", (Object)this.create);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.Format", (Object)this.format);
        if (this.outputFileName == null) {
            exporter.getProperties().remove("org.hibernate.tool.api.export.ExporterConstants.OutputFileName");
        } else {
            exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", this.outputFileName);
        }
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.HaltOnError", (Object)this.haltOnError);
        return exporter;
    }

    @Override
    protected Exporter createExporter() {
        Exporter exporter = ExporterFactory.createExporter((ExporterType)ExporterType.DDL);
        exporter.getProperties().putAll((Map<?, ?>)this.parent.getProperties());
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", this.parent.getProperties());
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", this.parent.getDestDir());
        return exporter;
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }
}

