/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedBindingContext;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorDirectValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathCastedTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoProcessorNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexedEmbeddedIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexedEmbeddedMappingElement;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorCastedTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorValueBridgeNode;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexingProcessorValueNodeBuilderDelegate<P, V>
extends AbstractPojoProcessorNodeBuilder
implements PojoIndexMappingCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BoundPojoModelPathValueNode<?, P, V> modelPath;
    private final Collection<BoundValueBridge<V, ?>> boundBridges = new ArrayList();
    private final Collection<AbstractPojoIndexingProcessorTypeNodeBuilder<V, ?>> typeNodeBuilders = new ArrayList();
    private final boolean multiValuedFromContainerExtractor;

    PojoIndexingProcessorValueNodeBuilderDelegate(BoundPojoModelPathValueNode<?, P, V> modelPath, PojoMappingHelper mappingHelper, IndexBindingContext bindingContext, boolean multiValuedFromContainerExtractor) {
        super(mappingHelper, bindingContext);
        this.modelPath = modelPath;
        this.multiValuedFromContainerExtractor = multiValuedFromContainerExtractor;
    }

    @Override
    public void valueBinder(ValueBinder binder, Map<String, Object> params, String relativeFieldName, FieldModelContributor fieldModelContributor) {
        String defaultedRelativeFieldName = relativeFieldName;
        if (defaultedRelativeFieldName == null) {
            defaultedRelativeFieldName = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().name();
        }
        this.mappingHelper.indexModelBinder().bindValue(this.bindingContext, this.modelPath, this.multiValuedFromContainerExtractor, binder, params, defaultedRelativeFieldName, fieldModelContributor).ifPresent(this.boundBridges::add);
    }

    @Override
    public void indexedEmbedded(PojoRawTypeIdentifier<?> definingType, String relativePrefix, ObjectStructure structure, TreeFilterDefinition filterDefinition, boolean includeEmbeddedObjectId, Class<?> targetType) {
        PojoTypeModel<Object> targetTypeModel;
        AbstractPojoIndexingProcessorTypeNodeBuilder nestedProcessorBuilder;
        PojoIndexedEmbeddedIdentityMappingCollector<Object> identityMappingCollector;
        Optional nestedBindingContextOptional;
        String propertyName = ((BoundPojoModelPathPropertyNode)this.modelPath.getParent()).getPropertyModel().name();
        String defaultedRelativePrefix = relativePrefix;
        if (defaultedRelativePrefix == null) {
            defaultedRelativePrefix = propertyName + ".";
        }
        if (!(nestedBindingContextOptional = this.bindingContext.addIndexedEmbeddedIfIncluded((MappingElement)new PojoIndexedEmbeddedMappingElement(definingType, propertyName, relativePrefix), defaultedRelativePrefix, structure, filterDefinition, this.multiValuedFromContainerExtractor)).isPresent()) {
            return;
        }
        IndexedEmbeddedBindingContext nestedBindingContext = (IndexedEmbeddedBindingContext)nestedBindingContextOptional.get();
        if (targetType == null) {
            BoundPojoModelPathOriginalTypeNode<V> typeModelPath = this.modelPath.type();
            identityMappingCollector = new PojoIndexedEmbeddedIdentityMappingCollector<V>(typeModelPath.getTypeModel().rawType(), this.mappingHelper);
            nestedProcessorBuilder = new PojoIndexingProcessorOriginalTypeNodeBuilder<V>(typeModelPath, this.mappingHelper, (IndexBindingContext)nestedBindingContext, identityMappingCollector, nestedBindingContext.parentIndexObjectReferences());
        } else {
            targetTypeModel = this.mappingHelper.introspector().typeModel(targetType);
            BoundPojoModelPathCastedTypeNode<V, ?> typeModelPath = this.modelPath.type().castTo(targetTypeModel);
            identityMappingCollector = new PojoIndexedEmbeddedIdentityMappingCollector(typeModelPath.getTypeModel().rawType(), this.mappingHelper);
            nestedProcessorBuilder = new PojoIndexingProcessorCastedTypeNodeBuilder(typeModelPath, this.mappingHelper, (IndexBindingContext)nestedBindingContext, identityMappingCollector, nestedBindingContext.parentIndexObjectReferences());
        }
        this.typeNodeBuilders.add(nestedProcessorBuilder);
        targetTypeModel = ((BoundPojoModelPathTypeNode)((AbstractPojoIndexingProcessorTypeNodeBuilder)nestedProcessorBuilder).getModelPath()).getTypeModel();
        Set contributors = this.mappingHelper.contributorProvider().get(targetTypeModel.rawType());
        if (!includeEmbeddedObjectId && contributors.isEmpty()) {
            throw log.invalidIndexedEmbedded(targetTypeModel);
        }
        contributors.forEach(c -> c.contributeIndexMapping(nestedProcessorBuilder));
        if (includeEmbeddedObjectId) {
            identityMappingCollector.contributeIdentifierField(nestedProcessorBuilder);
        }
    }

    @Override
    BoundPojoModelPathValueNode<?, P, V> getModelPath() {
        return this.modelPath;
    }

    @Override
    void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(ValueBridge::close, this.boundBridges, BoundValueBridge::getBridge);
            closer.pushAll(BeanHolder::close, this.boundBridges, BoundValueBridge::getBridgeHolder);
            closer.pushAll(AbstractPojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.typeNodeBuilders);
        }
    }

    Collection<PojoIndexingProcessor<? super V>> build(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        try {
            return this.doBuild(parentDependencyCollector);
        }
        catch (RuntimeException e) {
            this.failureCollector().add((Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<PojoIndexingProcessor<? super V>> doBuild(PojoIndexingDependencyCollectorPropertyNode<?, P> parentDependencyCollector) {
        AbstractPojoIndexingDependencyCollectorDirectValueNode valueDependencyCollector = parentDependencyCollector.value(this.modelPath.getBoundExtractorPath());
        List<Object> immutableNestedNodes = this.boundBridges.isEmpty() && this.typeNodeBuilders.isEmpty() ? Collections.emptyList() : new ArrayList(this.boundBridges.size() + this.typeNodeBuilders.size());
        try {
            for (BoundValueBridge<V, ?> boundBridge : this.boundBridges) {
                immutableNestedNodes.add(PojoIndexingProcessorValueNodeBuilderDelegate.createValueBridgeNode(boundBridge));
            }
            this.typeNodeBuilders.stream().map(builder -> builder.build(valueDependencyCollector)).filter(Optional::isPresent).map(Optional::get).forEach(immutableNestedNodes::add);
            if (!immutableNestedNodes.isEmpty()) {
                valueDependencyCollector.collectDependency();
            }
            return immutableNestedNodes;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(PojoIndexingProcessor::close, immutableNestedNodes);
            throw e;
        }
    }

    private static <V, F> PojoIndexingProcessor<V> createValueBridgeNode(BoundValueBridge<V, F> boundBridge) {
        return new PojoIndexingProcessorValueBridgeNode<V, F>(boundBridge.getBridgeHolder(), boundBridge.getIndexFieldReference());
    }
}

