/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexModel
implements AutoCloseable,
IndexDescriptor {
    private final String indexName;
    private final String mappedTypeName;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final LuceneIndexSchemaObjectNode rootNode;
    private final Map<String, AbstractLuceneIndexSchemaFieldNode> staticFields;
    private final List<IndexFieldDescriptor> includedStaticFields;
    private final List<AbstractLuceneIndexSchemaFieldTemplate<?>> fieldTemplates;
    private final boolean hasNestedDocuments;
    private final ConcurrentMap<String, AbstractLuceneIndexSchemaFieldNode> dynamicFieldsCache = new ConcurrentHashMap<String, AbstractLuceneIndexSchemaFieldNode>();
    private final IndexingScopedAnalyzer indexingAnalyzer;
    private final SearchScopedAnalyzer searchAnalyzer;

    public LuceneIndexModel(String indexName, String mappedTypeName, ToDocumentIdentifierValueConverter<?> idDslConverter, LuceneIndexSchemaObjectNode rootNode, Map<String, AbstractLuceneIndexSchemaFieldNode> staticFields, List<AbstractLuceneIndexSchemaFieldTemplate<?>> fieldTemplates, boolean hasNestedDocuments) {
        this.indexName = indexName;
        this.mappedTypeName = mappedTypeName;
        this.idDslConverter = idDslConverter;
        this.rootNode = rootNode;
        this.staticFields = CollectionHelper.toImmutableMap(staticFields);
        this.includedStaticFields = CollectionHelper.toImmutableList(staticFields.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.inclusion())).collect(Collectors.toList()));
        this.indexingAnalyzer = new IndexingScopedAnalyzer();
        this.searchAnalyzer = new SearchScopedAnalyzer();
        this.fieldTemplates = fieldTemplates;
        this.hasNestedDocuments = hasNestedDocuments;
    }

    @Override
    public void close() {
        this.indexingAnalyzer.close();
    }

    public String hibernateSearchName() {
        return this.indexName;
    }

    public LuceneIndexSchemaObjectNode root() {
        return this.rootNode;
    }

    public Optional<IndexFieldDescriptor> field(String absolutePath) {
        return Optional.ofNullable(this.fieldOrNull(absolutePath));
    }

    public AbstractLuceneIndexSchemaFieldNode fieldOrNull(String absolutePath) {
        return this.fieldOrNull(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
    }

    public AbstractLuceneIndexSchemaFieldNode fieldOrNull(String absolutePath, IndexFieldFilter filter) {
        AbstractLuceneIndexSchemaFieldNode field = this.fieldOrNullIgnoringInclusion(absolutePath);
        return field == null ? null : (AbstractLuceneIndexSchemaFieldNode)filter.filter((Object)field, field.inclusion());
    }

    public Collection<IndexFieldDescriptor> staticFields() {
        return this.includedStaticFields;
    }

    public String mappedTypeName() {
        return this.mappedTypeName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.indexName);
    }

    public ToDocumentIdentifierValueConverter<?> idDslConverter() {
        return this.idDslConverter;
    }

    public boolean hasNestedDocuments() {
        return this.hasNestedDocuments;
    }

    public Analyzer getIndexingAnalyzer() {
        return this.indexingAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexName=" + this.indexName + "]";
    }

    private AbstractLuceneIndexSchemaFieldNode fieldOrNullIgnoringInclusion(String absolutePath) {
        AbstractLuceneIndexSchemaFieldNode field = this.staticFields.get(absolutePath);
        if (field != null) {
            return field;
        }
        field = (AbstractLuceneIndexSchemaFieldNode)this.dynamicFieldsCache.get(absolutePath);
        if (field != null) {
            return field;
        }
        for (AbstractLuceneIndexSchemaFieldTemplate<?> template : this.fieldTemplates) {
            field = template.createNodeIfMatching(this, absolutePath);
            if (field == null) continue;
            AbstractLuceneIndexSchemaFieldNode previous = this.dynamicFieldsCache.putIfAbsent(absolutePath, field);
            if (previous == null) break;
            field = previous;
            break;
        }
        return field;
    }

    private class SearchScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected SearchScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            AbstractLuceneIndexSchemaFieldNode field = LuceneIndexModel.this.fieldOrNull(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = field.toValueField().type().searchAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }

    private class IndexingScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected IndexingScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            AbstractLuceneIndexSchemaFieldNode field = LuceneIndexModel.this.fieldOrNull(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = field.toValueField().type().indexingAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }
}

