/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;

final class ResourceLoaderHelper {
    private static final Log log = LoggerFactory.make();

    ResourceLoaderHelper() {
    }

    static InputStream getResettableInputStreamForPath(String path) {
        String inputPath = path;
        if (inputPath.startsWith("/")) {
            inputPath = inputPath.substring(1);
        }
        boolean isContextCL = true;
        ClassLoader loader = ResourceLoaderHelper.run(GetClassLoader.fromContext());
        if (loader == null) {
            log.debug("No default context class loader, fall back to Bean Validation's loader");
            loader = ResourceLoaderHelper.run(GetClassLoader.fromClass(ResourceLoaderHelper.class));
            isContextCL = false;
        }
        InputStream inputStream = loader.getResourceAsStream(inputPath);
        if (isContextCL && inputStream == null) {
            loader = ResourceLoaderHelper.run(GetClassLoader.fromClass(ResourceLoaderHelper.class));
            inputStream = loader.getResourceAsStream(inputPath);
        }
        if (inputStream == null) {
            return null;
        }
        if (inputStream.markSupported()) {
            return inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

