/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.logging;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.GroupDefinitionException;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HV")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Hibernate Validator %s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Ignoring XML configuration.")
    public void ignoringXmlConfiguration();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Using %s as constraint factory.")
    public void usingConstraintFactory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Using %s as message interpolator.")
    public void usingMessageInterpolator(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Using %s as traversable resolver.")
    public void usingTraversableResolver(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Using %s as validation provider.")
    public void usingValidationProvider(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="%s found. Parsing XML based configuration.")
    public void parsingXMLFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Unable to close input stream.")
    public void unableToCloseInputStream();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Unable to load provider class %s.")
    public void unableToLoadProviderClass(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Unable to close input stream for %s.")
    public void unableToCloseXMLFileInputStream(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Unable to create schema for %1$s: %2$s")
    public void unableToCreateSchema(String var1, String var2);

    @Message(id=12, value="Unable to create annotation for configured constraint: %s.")
    public ValidationException getUnableToCreateAnnotationForConfiguredConstraintException(String var1, @Cause RuntimeException var2);

    @Message(id=13, value="The class %1$s does not have a property '%2$s' with access %3$s.")
    public ValidationException getUnableToFindPropertyWithAccessException(Class<?> var1, String var2, ElementType var3);

    @Message(id=14, value="Type %1$s doesn't have a method %2$s(%3$s).")
    public IllegalArgumentException getUnableToFindMethodException(Class<?> var1, String var2, String var3);

    @Message(id=15, value="A valid parameter index has to be specified for method '%s'")
    public IllegalArgumentException getInvalidMethodParameterIndexException(String var1);

    @Message(id=16, value="%s does not represent a valid BigDecimal format.")
    public IllegalArgumentException getInvalidBigDecimalFormatException(String var1, @Cause NumberFormatException var2);

    @Message(id=17, value="The length of the integer part cannot be negative.")
    public IllegalArgumentException getInvalidLengthForIntegerPartException();

    @Message(id=18, value="The length of the fraction part cannot be negative.")
    public IllegalArgumentException getInvalidLengthForFractionPartException();

    @Message(id=19, value="The min parameter cannot be negative.")
    public IllegalArgumentException getMinCannotBeNegativeException();

    @Message(id=20, value="The max parameter cannot be negative.")
    public IllegalArgumentException getMaxCannotBeNegativeException();

    @Message(id=21, value="The length cannot be negative.")
    public IllegalArgumentException getLengthCannotBeNegativeException();

    @Message(id=22, value="Invalid regular expression.")
    public IllegalArgumentException getInvalidRegularExpressionException(@Cause PatternSyntaxException var1);

    @Message(id=23, value="Error during execution of script \"%s\" occurred.")
    public ConstraintDeclarationException getErrorDuringScriptExecutionException(String var1, @Cause Exception var2);

    @Message(id=24, value="Script \"%s\" returned null, but must return either true or false.")
    public ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(String var1);

    @Message(id=25, value="Script \"%1$s\" returned %2$s (of type %3$s), but must return either true or false.")
    public ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(String var1, Object var2, String var3);

    @Message(id=26, value="Assertion error: inconsistent ConfigurationImpl construction.")
    public ValidationException getInconsistentConfigurationException();

    @Message(id=27, value="Unable to find provider: %s.")
    public ValidationException getUnableToFindProviderException(Class<?> var1);

    @Message(id=28, value="Unexpected exception during isValid call.")
    public ValidationException getExceptionDuringIsValidCall(@Cause RuntimeException var1);

    @Message(id=29, value="Constraint factory returned null when trying to create instance of %s.")
    public ValidationException getConstraintFactoryMustNotReturnNullException(String var1);

    @Message(id=30, value="No validator could be found for type: %s.")
    public UnexpectedTypeException getNoValidatorFoundForTypeException(String var1);

    @Message(id=31, value="There are multiple validator classes which could validate the type %1$s. The validator classes are: %2$s.")
    public UnexpectedTypeException getMoreThanOneValidatorFoundForTypeException(Type var1, String var2);

    @Message(id=32, value="Unable to initialize %s.")
    public ValidationException getUnableToInitializeConstraintValidatorException(String var1, @Cause RuntimeException var2);

    @Message(id=33, value="At least one custom message must be created if the default error message gets disabled.")
    public ValidationException getAtLeastOneCustomMessageMustBeCreatedException();

    @Message(id=34, value="%s is not a valid Java Identifier.")
    public IllegalArgumentException getInvalidJavaIdentifierException(String var1);

    @Message(id=35, value="Unable to parse property path %s.")
    public IllegalArgumentException getUnableToParsePropertyPathException(String var1);

    @Message(id=36, value="Type %s not supported.")
    public ValidationException getTypeNotSupportedException(Class<?> var1);

    @Message(id=37, value="Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties.")
    public ValidationException getInconsistentFailFastConfigurationException();

    @Message(id=38, value="Invalid property path.")
    public IllegalArgumentException getInvalidPropertyPathException();

    @Message(id=39, value="Invalid property path. There is no property %1$s in entity %2$s.")
    public IllegalArgumentException getInvalidPropertyPathException(String var1, String var2);

    @Message(id=40, value="Property path must provide index or map key.")
    public IllegalArgumentException getPropertyPathMustProvideIndexOrMapKeyException();

    @Message(id=41, value="Call to TraversableResolver.isReachable() threw an exception.")
    public ValidationException getErrorDuringCallOfTraversableResolverIsReachableException(@Cause RuntimeException var1);

    @Message(id=42, value="Call to TraversableResolver.isCascadable() threw an exception.")
    public ValidationException getErrorDuringCallOfTraversableResolverIsCascadableException(@Cause RuntimeException var1);

    @Message(id=43, value="Unable to expand default group list %1$s into sequence %2$s.")
    public GroupDefinitionException getUnableToExpandDefaultGroupListException(List<?> var1, List<?> var2);

    @Message(id=44, value="At least one group has to be specified.")
    public IllegalArgumentException getAtLeastOneGroupHasToBeSpecifiedException();

    @Message(id=45, value="A group has to be an interface. %s is not.")
    public ValidationException getGroupHasToBeAnInterfaceException(String var1);

    @Message(id=46, value="Sequence definitions are not allowed as composing parts of a sequence.")
    public GroupDefinitionException getSequenceDefinitionsNotAllowedException();

    @Message(id=47, value="Cyclic dependency in groups definition")
    public GroupDefinitionException getCyclicDependencyInGroupsDefinitionException();

    @Message(id=48, value="Unable to expand group sequence.")
    public GroupDefinitionException getUnableToExpandGroupSequenceException();

    @Message(id=49, value="The given index must be between %1$s and %2$s.")
    public IndexOutOfBoundsException getInvalidIndexException(String var1, String var2);

    @Message(id=50, value="Missing format string in template: %s.")
    public ValidationException getMissingFormatStringInTemplateException(String var1);

    @Message(id=51, value="Invalid format: %s.")
    public ValidationException throwInvalidFormat(String var1, @Cause IllegalFormatException var2);

    @Message(id=52, value="Default group sequence and default group sequence provider cannot be defined at the same time.")
    public GroupDefinitionException getInvalidDefaultGroupSequenceDefinitionException();

    @Message(id=53, value="'Default.class' cannot appear in default group sequence list.")
    public GroupDefinitionException getNoDefaultGroupInGroupSequenceException();

    @Message(id=54, value="%s must be part of the redefined default group sequence.")
    public GroupDefinitionException getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(String var1);

    @Message(id=55, value="The default group sequence provider defined for %s has the wrong type")
    public GroupDefinitionException getWrongDefaultGroupSequenceProviderTypeException(String var1);

    @Message(id=56, value="Method %1$s doesn't have a parameter with index %2$d.")
    public IllegalArgumentException getInvalidMethodParameterIndexException(String var1, int var2);

    @Message(id=57, value="Unable to find constraints for  %s.")
    public ValidationException getUnableToFindAnnotationConstraintsException(Class<? extends Annotation> var1);

    @Message(id=58, value="Unable to read annotation attributes: %s.")
    public ValidationException getUnableToReadAnnotationAttributesException(Class<? extends Annotation> var1, @Cause Exception var2);

    @Message(id=59, value="Unable to retrieve annotation parameter value.")
    public ValidationException getUnableToRetrieveAnnotationParameterValueException(@Cause Exception var1);

    @Message(id=60, value="Multiple definitions of default group sequence provider.")
    public GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceProviderException();

    @Message(id=61, value="Multiple definitions of default group sequence.")
    public GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceException();

    @Message(id=62, value="Method %1$s has %2$s parameters, but the passed list of parameter meta data has a size of %3$s.")
    public IllegalArgumentException getInvalidLengthOfParameterMetaDataListException(Method var1, int var2, int var3);

    @Message(id=63, value="Unable to instantiate %s.")
    public ValidationException getUnableToInstantiateException(String var1, @Cause Exception var2);

    public ValidationException getUnableToInstantiateException(Class<?> var1, @Cause Exception var2);

    @Message(id=64, value="Unable to instantiate %1$s: %2$s.")
    public ValidationException getUnableToInstantiateException(String var1, Class<?> var2, @Cause Exception var3);

    @Message(id=65, value="Unable to load class: %s.")
    public ValidationException getUnableToLoadClassException(String var1);

    public ValidationException getUnableToLoadClassException(String var1, @Cause Exception var2);

    @Message(id=66, value="Unable to instantiate Bean Validation provider %s.")
    public ValidationException getUnableToInstantiateBeanValidationProviderException(List<String> var1, @Cause Exception var2);

    @Message(id=67, value="Unable to read %s.")
    public ValidationException getUnableToReadServicesFileException(String var1, @Cause Exception var2);

    @Message(id=68, value="Start index cannot be negative: %d.")
    public IllegalArgumentException getStartIndexCannotBeNegativeException(int var1);

    @Message(id=69, value="End index cannot be negative: %d.")
    public IllegalArgumentException getEndIndexCannotBeNegativeException(int var1);

    @Message(id=70, value="Invalid Range: %1$d > %2$d.")
    public IllegalArgumentException getInvalidRangeException(int var1, int var2);

    @Message(id=71, value="A explicitly specified check digit must lie outside the interval: [%1$d, %2$d].")
    public IllegalArgumentException getInvalidCheckDigitException(int var1, int var2);

    @Message(id=72, value="'%c' is not a digit.")
    public NumberFormatException getCharacterIsNotADigitException(char var1);

    @Message(id=73, value="Parameters starting with 'valid' are not allowed in a constraint.")
    public ConstraintDefinitionException getConstraintParametersCannotStartWithValidException();

    @Message(id=74, value="%2$s contains Constraint annotation, but does not contain a %1$s parameter.")
    public ConstraintDefinitionException getConstraintWithoutMandatoryParameterException(String var1, String var2);

    @Message(id=75, value="%s contains Constraint annotation, but the payload parameter default value is not the empty array.")
    public ConstraintDefinitionException getWrongDefaultValueForPayloadParameterException(String var1);

    @Message(id=76, value="%s contains Constraint annotation, but the payload parameter is of wrong type.")
    public ConstraintDefinitionException getWrongTypeForPayloadParameterException(String var1, @Cause ClassCastException var2);

    @Message(id=77, value="%s contains Constraint annotation, but the groups parameter default value is not the empty array.")
    public ConstraintDefinitionException getWrongDefaultValueForGroupsParameterException(String var1);

    @Message(id=78, value="%s contains Constraint annotation, but the groups parameter is of wrong type.")
    public ConstraintDefinitionException getWrongTypeForGroupsParameterException(String var1, @Cause ClassCastException var2);

    @Message(id=79, value="%s contains Constraint annotation, but the message parameter is not of type java.lang.String.")
    public ConstraintDefinitionException getWrongTypeForMessageParameterException(String var1);

    @Message(id=80, value="Overridden constraint does not define an attribute with name %s.")
    public ConstraintDefinitionException getOverriddenConstraintAttributeNotFoundException(String var1);

    @Message(id=81, value="The overriding type of a composite constraint must be identical to the overridden one. Expected %1$s found %2$s.")
    public ConstraintDefinitionException getWrongAttributeTypeForOverriddenConstraintException(String var1, Class<?> var2);

    @Message(id=82, value="Wrong parameter type. Expected: %1$s Actual: %2$s.")
    public ValidationException getWrongParameterTypeException(String var1, String var2);

    @Message(id=83, value="The specified annotation defines no parameter '%s'.")
    public ValidationException getUnableToFindAnnotationParameterException(String var1, @Cause NoSuchMethodException var2);

    @Message(id=84, value="Unable to get '%1$s' from %2$s.")
    public ValidationException getUnableToGetAnnotationParameterException(String var1, String var2, @Cause Exception var3);

    @Message(id=85, value="No value provided for %s.")
    public IllegalArgumentException getNoValueProvidedForAnnotationParameterException(String var1);

    @Message(id=86, value="Trying to instantiate %1$s with unknown parameter(s): %2$s.")
    public RuntimeException getTryingToInstantiateAnnotationWithUnknownParametersException(Class<?> var1, Set<String> var2);

    @Message(id=87, value="Property name cannot be null or empty.")
    public IllegalArgumentException getPropertyNameCannotBeNullOrEmptyException();

    @Message(id=88, value="Element type has to be FIELD or METHOD.")
    public IllegalArgumentException getElementTypeHasToBeFieldOrMethodException();

    @Message(id=89, value="Member %s is neither a field nor a method.")
    public IllegalArgumentException getMemberIsNeitherAFieldNorAMethodException(Member var1);

    @Message(id=90, value="Unable to access %s.")
    public ValidationException getUnableToAccessMemberException(String var1, @Cause Exception var2);

    @Message(id=91, value="%s has to be a primitive type.")
    public IllegalArgumentException getHasToBeAPrimitiveTypeException(Class<?> var1);

    @Message(id=93, value="null is an invalid type for a constraint validator.")
    public ValidationException getNullIsAnInvalidTypeForAConstraintValidatorException();

    @Message(id=94, value="Missing actual type argument for type parameter: %s.")
    public IllegalArgumentException getMissingActualTypeArgumentForTypeParameterException(TypeVariable<?> var1);

    @Message(id=95, value="Unable to instantiate constraint factory class %s.")
    public ValidationException getUnableToInstantiateConstraintFactoryClassException(String var1, @Cause ValidationException var2);

    @Message(id=96, value="Unable to open input stream for mapping file %s.")
    public ValidationException getUnableToOpenInputStreamForMappingFileException(String var1);

    @Message(id=97, value="Unable to instantiate message interpolator class %s.")
    public ValidationException getUnableToInstantiateMessageInterpolatorClassException(String var1, @Cause Exception var2);

    @Message(id=98, value="Unable to instantiate traversable resolver class %s.")
    public ValidationException getUnableToInstantiateTraversableResolverClassException(String var1, @Cause Exception var2);

    @Message(id=99, value="Unable to instantiate validation provider class %s.")
    public ValidationException getUnableToInstantiateValidationProviderClassException(String var1, @Cause Exception var2);

    @Message(id=100, value="Unable to parse %s.")
    public ValidationException getUnableToParseValidationXmlFileException(String var1, @Cause Exception var2);

    @Message(id=101, value="%s is not an annotation.")
    public ValidationException getIsNotAnAnnotationException(String var1);

    @Message(id=102, value="%s is not a constraint validator class.")
    public ValidationException getIsNotAConstraintValidatorClassException(Class<?> var1);

    @Message(id=103, value="%s has already be configured in xml.")
    public ValidationException getBeanClassHasAlreadyBeConfiguredInXmlException(String var1);

    @Message(id=104, value="%1$s is defined twice in mapping xml for bean %2$s.")
    public ValidationException getIsDefinedTwiceInMappingXmlForBeanException(String var1, String var2);

    @Message(id=105, value="%1$s does not contain the fieldType %2$s.")
    public ValidationException getBeanDoesNotContainTheFieldException(String var1, String var2);

    @Message(id=106, value="%1$s does not contain the property %2$s.")
    public ValidationException getBeanDoesNotContainThePropertyException(String var1, String var2);

    @Message(id=107, value="Annotation of type %1$s does not contain a parameter %2$s.")
    public ValidationException getAnnotationDoesNotContainAParameterException(String var1, String var2);

    @Message(id=108, value="Attempt to specify an array where single value is expected.")
    public ValidationException getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException();

    @Message(id=109, value="Unexpected parameter value.")
    public ValidationException getUnexpectedParameterValueException();

    public ValidationException getUnexpectedParameterValueException(@Cause ClassCastException var1);

    @Message(id=110, value="Invalid %s format.")
    public ValidationException getInvalidNumberFormatException(String var1, @Cause NumberFormatException var2);

    @Message(id=111, value="Invalid char value: %s.")
    public ValidationException getInvalidCharValueException(String var1);

    @Message(id=112, value="Invalid return type: %s. Should be a enumeration type.")
    public ValidationException getInvalidReturnTypeException(Class<?> var1, @Cause ClassCastException var2);

    @Message(id=113, value="%s, %s, %s are reserved parameter names.")
    public ValidationException getReservedParameterNamesException(String var1, String var2, String var3);

    @Message(id=114, value="Specified payload class %s does not implement javax.validation.Payload")
    public ValidationException getWrongPayloadClassException(String var1);

    @Message(id=115, value="Error parsing mapping file.")
    public ValidationException getErrorParsingMappingFileException(@Cause Exception var1);

    @Message(id=116, value="%s")
    public IllegalArgumentException getIllegalArgumentException(String var1);

    @Message(id=117, value="Invalid value for property %s: %s")
    public ValidationException getInvalidPropertyValue(String var1, String var2, @Cause Exception var3);
}

