/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.spi;

import java.io.File;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryHelper {
    private static final Log log = LoggerFactory.make();

    private DirectoryHelper() {
    }

    public static void initializeIndexIfNeeded(Directory directory) {
        Version version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        try (SimpleAnalyzer analyzer = new SimpleAnalyzer(version);){
            if (!DirectoryReader.indexExists((Directory)directory)) {
                try {
                    IndexWriterConfig iwriterConfig = new IndexWriterConfig(version, (Analyzer)analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                    iwriterConfig.setWriteLockTimeout(2000L);
                    IndexWriter iw = new IndexWriter(directory, iwriterConfig);
                    iw.close();
                }
                catch (LockObtainFailedException lofe) {
                    log.lockingFailureDuringInitialization(directory.toString());
                }
            }
        }
    }

    public static File getVerifiedIndexDir(String annotatedIndexName, Properties properties, boolean verifyIsWritable) {
        String indexBase = properties.getProperty("indexBase", ".");
        String indexName = properties.getProperty("indexName", annotatedIndexName);
        File baseIndexDir = new File(indexBase);
        DirectoryProviderHelper.makeSanityCheckedDirectory(baseIndexDir, indexName, verifyIsWritable);
        File indexDir = new File(baseIndexDir, indexName);
        DirectoryProviderHelper.makeSanityCheckedDirectory(indexDir, indexName, verifyIsWritable);
        return indexDir;
    }
}

