/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
final class NFIBackendSignatureBuilderLibraryGen
extends LibraryFactory<NFIBackendSignatureBuilderLibrary> {
    private static final Class<NFIBackendSignatureBuilderLibrary> LIBRARY_CLASS = NFIBackendSignatureBuilderLibraryGen.lazyLibraryClass();
    private static final Message SET_RETURN_TYPE = new MessageImpl("setReturnType", 0, Void.TYPE, Object.class, Object.class);
    private static final Message ADD_ARGUMENT = new MessageImpl("addArgument", 1, Void.TYPE, Object.class, Object.class);
    private static final Message MAKE_VARARGS = new MessageImpl("makeVarargs", 2, Void.TYPE, Object.class);
    private static final Message BUILD = new MessageImpl("build", 3, Object.class, Object.class);
    private static final NFIBackendSignatureBuilderLibraryGen INSTANCE = new NFIBackendSignatureBuilderLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NFIBackendSignatureBuilderLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(SET_RETURN_TYPE, ADD_ARGUMENT, MAKE_VARARGS, BUILD)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NFIBackendSignatureBuilderLibrary.class;
    }

    protected NFIBackendSignatureBuilderLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NFIBackendSignatureBuilderLibrary createDelegate(NFIBackendSignatureBuilderLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFIBackendSignatureBuilderLibrary lib = (NFIBackendSignatureBuilderLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                lib.setReturnType(receiver, args[offset]);
                return null;
            }
            case 1: {
                lib.addArgument(receiver, args[offset]);
                return null;
            }
            case 2: {
                lib.makeVarargs(receiver);
                return null;
            }
            case 3: {
                return lib.build(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NFIBackendSignatureBuilderLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NFIBackendSignatureBuilderLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NFIBackendSignatureBuilderLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary", false, NFIBackendSignatureBuilderLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static abstract class CachedDispatch
    extends NFIBackendSignatureBuilderLibrary {
        @Node.Child
        NFIBackendSignatureBuilderLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NFIBackendSignatureBuilderLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public void setReturnType(Object receiver_, Object type) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.setReturnType(receiver_, type);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void addArgument(Object receiver_, Object type) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.addArgument(receiver_, type);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void makeVarargs(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.makeVarargs(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object build(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureBuilderLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.build(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            NFIBackendSignatureBuilderLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NFIBackendSignatureBuilderLibrary)this.insert((Node)INSTANCE.create(receiver_));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NFIBackendSignatureBuilderLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NFIBackendSignatureBuilderLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NFIBackendSignatureBuilderLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NFIBackendSignatureBuilderLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NFIBackendSignatureBuilderLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class UncachedDispatch
    extends NFIBackendSignatureBuilderLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void setReturnType(Object receiver_, Object type) {
            ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).setReturnType(receiver_, type);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void addArgument(Object receiver_, Object type) {
            ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).addArgument(receiver_, type);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void makeVarargs(Object receiver_) {
            ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).makeVarargs(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object build(Object receiver_) {
            return ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).build(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NFIBackendSignatureBuilderLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void setReturnType(Object receiver_, Object type) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).setReturnType(receiver_, type);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void addArgument(Object receiver_, Object type) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).addArgument(receiver_, type);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void makeVarargs(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).makeVarargs(receiver_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object build(Object receiver_) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendSignatureBuilderLibrary)INSTANCE.getUncached(receiver_)).build(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class Delegate
    extends NFIBackendSignatureBuilderLibrary {
        @Node.Child
        private NFIBackendSignatureBuilderLibrary delegateLibrary;

        Delegate(NFIBackendSignatureBuilderLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void setReturnType(Object receiver_, Object type) {
            if (NFIBackendSignatureBuilderLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NFIBackendSignatureBuilderLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((NFIBackendSignatureBuilderLibrary)NFIBackendSignatureBuilderLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).setReturnType(delegate, type);
                return;
            }
            this.delegateLibrary.setReturnType(receiver_, type);
        }

        @Override
        public void addArgument(Object receiver_, Object type) {
            if (NFIBackendSignatureBuilderLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NFIBackendSignatureBuilderLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((NFIBackendSignatureBuilderLibrary)NFIBackendSignatureBuilderLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).addArgument(delegate, type);
                return;
            }
            this.delegateLibrary.addArgument(receiver_, type);
        }

        @Override
        public void makeVarargs(Object receiver_) {
            if (NFIBackendSignatureBuilderLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = NFIBackendSignatureBuilderLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((NFIBackendSignatureBuilderLibrary)NFIBackendSignatureBuilderLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).makeVarargs(delegate);
                return;
            }
            this.delegateLibrary.makeVarargs(receiver_);
        }

        @Override
        public Object build(Object receiver_) {
            if (NFIBackendSignatureBuilderLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = NFIBackendSignatureBuilderLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendSignatureBuilderLibrary)NFIBackendSignatureBuilderLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).build(delegate);
            }
            return this.delegateLibrary.build(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class Proxy
    extends NFIBackendSignatureBuilderLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void setReturnType(Object receiver_, Object type) {
            try {
                this.lib.send(receiver_, SET_RETURN_TYPE, new Object[]{type});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void addArgument(Object receiver_, Object type) {
            try {
                this.lib.send(receiver_, ADD_ARGUMENT, new Object[]{type});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void makeVarargs(Object receiver_) {
            try {
                this.lib.send(receiver_, MAKE_VARARGS, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object build(Object receiver_) {
            try {
                return this.lib.send(receiver_, BUILD, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
    private static final class Default
    extends LibraryExport<NFIBackendSignatureBuilderLibrary> {
        private Default() {
            super(NFIBackendSignatureBuilderLibrary.class, Object.class, false);
        }

        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
        private static final class Uncached
        extends NFIBackendSignatureBuilderLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setReturnType(Object receiver, Object type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void addArgument(Object receiver, Object type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void makeVarargs(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.makeVarargs(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object build(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=NFIBackendSignatureBuilderLibrary.class)
        private static final class Cached
        extends NFIBackendSignatureBuilderLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setReturnType(Object receiver, Object type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void addArgument(Object receiver, Object type) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void makeVarargs(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.makeVarargs(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object build(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

