/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.BindSignatureNodeGen;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFISymbol.class)
final class NFISymbolGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SignatureLibrary> SIGNATURE_LIBRARY_ = LibraryFactory.resolve(SignatureLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private NFISymbolGen() {
    }

    static {
        LibraryExport.register(NFISymbol.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=NFISymbol.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISymbol.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISymbol);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISymbol);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFISymbol.class)
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                if (arg0Value.isExecutable()) {
                    return NFISymbol.Execute.doGeneric(arg0Value, arg1Value, (SignatureLibrary)SIGNATURE_LIBRARY_.getUncached(arg0Value.signature));
                }
                if (!arg0Value.isExecutable()) {
                    return NFISymbol.Execute.doFail(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).isExecutable();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).isMemberInvocable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, BindSignatureNodeGen.getUncached(), BranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isNull(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.isNull((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.isPointer((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                return arg0Value.asPointer((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public void toNative(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                arg0Value.toNative((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value.nativeSymbol));
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=NFISymbol.class)
        private static final class Cached
        extends InteropLibrary {
            @Node.Child
            private SignatureLibrary receiverSignatureSignatureLibrary_;
            @Node.Child
            private InteropLibrary receiverNativeSymbolInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private BindSignatureNode invokeMemberNode__bind_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile invokeMemberNode__exception_;

            protected Cached(Object receiver) {
                NFISymbol castReceiver = (NFISymbol)receiver;
                this.receiverSignatureSignatureLibrary_ = (SignatureLibrary)super.insert((Node)SIGNATURE_LIBRARY_.create(castReceiver.signature));
                this.receiverNativeSymbolInteropLibrary_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(castReceiver.nativeSymbol));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISymbol) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISymbol)) {
                    return false;
                }
                if (!this.receiverSignatureSignatureLibrary_.accepts(((NFISymbol)receiver).signature)) {
                    return false;
                }
                return this.receiverNativeSymbolInteropLibrary_.accepts(((NFISymbol)receiver).nativeSymbol);
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value.isExecutable()) {
                        SignatureLibrary execute_generic_library__ = this.receiverSignatureSignatureLibrary_;
                        return NFISymbol.Execute.doGeneric(arg0Value, arg1Value, execute_generic_library__);
                    }
                    if ((state_0 & 2) != 0 && !arg0Value.isExecutable()) {
                        return NFISymbol.Execute.doFail(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFISymbol arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    SignatureLibrary execute_generic_library__ = null;
                    if (arg0Value.isExecutable()) {
                        execute_generic_library__ = this.receiverSignatureSignatureLibrary_;
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = NFISymbol.Execute.doGeneric(arg0Value, arg1Value, execute_generic_library__);
                        return object;
                    }
                    if (!arg0Value.isExecutable()) {
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = NFISymbol.Execute.doFail(arg0Value, arg1Value);
                        return object;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean isExecutable(Object receiver) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).isExecutable();
            }

            public boolean hasMembers(Object receiver) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).getMembers(includeInternal);
            }

            public boolean isMemberInvocable(Object receiver, String member) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).isMemberInvocable(member);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, this.invokeMemberNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object invokeMemberNode_AndSpecialize(NFISymbol arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.invokeMemberNode__bind_ = (BindSignatureNode)super.insert((Node)BindSignatureNodeGen.create());
                    this.invokeMemberNode__exception_ = BranchProfile.create();
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, this.invokeMemberNode__exception_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isNull(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary isNullNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.isNull(isNullNode__library__);
            }

            public boolean isPointer(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary isPointerNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.isPointer(isPointerNode__library__);
            }

            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary asPointerNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                return arg0Value.asPointer(asPointerNode__library__);
            }

            public void toNative(Object arg0Value_) {
                assert (arg0Value_ instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                NFISymbol arg0Value = (NFISymbol)arg0Value_;
                InteropLibrary toNativeNode__library__ = this.receiverNativeSymbolInteropLibrary_;
                arg0Value.toNative(toNativeNode__library__);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof NFISymbol) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((NFISymbol)receiver).toDisplayString(allowSideEffects);
            }
        }
    }
}

