/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFIRootNode;
import com.oracle.truffle.nfi.NativeSource;
import com.oracle.truffle.nfi.Parser;
import com.oracle.truffle.nfi.SignatureRootNode;

@TruffleLanguage.Registration(id="nfi", name="TruffleNFI", version="0.1", characterMimeTypes={"application/x-native"}, internal=true, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public class NFILanguage
extends TruffleLanguage<NFIContext> {
    public static final String MIME_TYPE = "application/x-native";
    private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("NFI single context");

    protected NFIContext createContext(TruffleLanguage.Env env) {
        return new NFIContext(env);
    }

    protected boolean patchContext(NFIContext context, TruffleLanguage.Env newEnv) {
        context.patch(newEnv);
        return true;
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContextAssumption.invalidate();
    }

    static NFILanguage getCurrentLanguage() {
        CompilerAsserts.neverPartOfCompilation((String)"getCurrentLanguage");
        return (NFILanguage)NFILanguage.getCurrentLanguage(NFILanguage.class);
    }

    static Assumption getSingleContextAssumption() {
        return NFILanguage.getCurrentLanguage().singleContextAssumption;
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        CharSequence nfiSource = request.getSource().getCharacters();
        NativeSource source = Parser.parseNFISource(nfiSource);
        String backendId = source.isDefaultBackend() ? "native" : source.getNFIBackendId();
        NativeSource.Content c = source.getContent();
        assert (c != null);
        if (c instanceof NativeSource.ParsedLibrary) {
            NativeSource.ParsedLibrary lib = (NativeSource.ParsedLibrary)c;
            return Truffle.getRuntime().createCallTarget((RootNode)new NFIRootNode(this, lib, backendId));
        }
        NativeSource.ParsedSignature sig = (NativeSource.ParsedSignature)c;
        SignatureRootNode buildSignature = new SignatureRootNode(this, backendId, sig.getBuildSignatureNode());
        return Truffle.getRuntime().createCallTarget((RootNode)buildSignature);
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }
}

