/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.polyglot.GuestToHostRootNode;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyDate;
import org.graalvm.polyglot.proxy.ProxyDuration;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyHashMap;
import org.graalvm.polyglot.proxy.ProxyInstant;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyIterable;
import org.graalvm.polyglot.proxy.ProxyIterator;
import org.graalvm.polyglot.proxy.ProxyNativeObject;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyTime;
import org.graalvm.polyglot.proxy.ProxyTimeZone;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotProxy
implements TruffleObject {
    static final int LIMIT = 5;
    private static final ProxyArray EMPTY = new ProxyArray(){

        public void set(long index, Value value) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public long getSize() {
            return 0L;
        }

        public Object get(long index) {
            throw new ArrayIndexOutOfBoundsException();
        }
    };
    final Proxy proxy;

    PolyglotProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolyglotProxy)) {
            return false;
        }
        return this.proxy == ((PolyglotProxy)obj).proxy;
    }

    public int hashCode() {
        return System.identityHashCode(this.proxy);
    }

    @ExportMessage
    boolean isInstantiable() {
        return this.proxy instanceof ProxyInstantiable;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object instantiate(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyInstantiable) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Value[] convertedArguments = languageContext.toHostValues(arguments, 0);
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().instantiate, languageContext, this.proxy, convertedArguments);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isExecutable() {
        return this.proxy instanceof ProxyExecutable;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object execute(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyExecutable) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Value[] convertedArguments = languageContext.toHostValues(arguments, 0);
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().execute, languageContext, this.proxy, convertedArguments);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer() {
        return this.proxy instanceof ProxyNativeObject;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long asPointer(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyNativeObject) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Long)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asPointer, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasArrayElements() {
        return this.proxy instanceof ProxyArray;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyArray) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arrayGet, languageContext, this.proxy, index);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeArrayElement(long index, Object value, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (!(this.proxy instanceof ProxyArray)) {
            throw UnsupportedMessageException.create();
        }
        PolyglotLanguageContext languageContext = context.get().internalContext;
        Value castValue = languageContext.asValue(value);
        GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arraySet, languageContext, this.proxy, index, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, InvalidArrayIndexException {
        if (this.proxy instanceof ProxyArray) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arrayRemove, languageContext, this.proxy, index);
            if (!result) {
                throw InvalidArrayIndexException.create(index);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getArraySize(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyArray) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Long)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arraySize, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable"), @ExportMessage(name="isArrayElementRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementExisting(long index, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyArray) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arraySize, languageContext, this.proxy);
            return index >= 0L && index < size;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementInsertable(long index, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyArray) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().arraySize, languageContext, this.proxy);
            return index < 0L || index >= size;
        }
        return false;
    }

    @ExportMessage
    boolean hasMembers() {
        return this.proxy instanceof ProxyObject;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyObject) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().memberKeys, languageContext, this.proxy);
            if (result == null) {
                result = EMPTY;
            }
            Object guestValue = languageContext.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.hasArrayElements(guestValue)) {
                throw PolyglotProxy.illegalProxy(languageContext, "getMemberKeys() returned invalid value %s but must return an array of member key Strings.", languageContext.asValue(guestValue).toString());
            }
            int i = 0;
            while ((long)i < interop.getArraySize(guestValue)) {
                try {
                    Object element = interop.readArrayElement(guestValue, i);
                    if (!interop.isString(element)) {
                        throw PolyglotProxy.illegalProxy(languageContext, "getMemberKeys() returned invalid value %s but must return an array of member key Strings.", languageContext.asValue(guestValue).toString());
                    }
                }
                catch (UnsupportedOperationException e) {
                    CompilerDirectives.shouldNotReachHere(e);
                }
                catch (InvalidArrayIndexException e) {
                    // empty catch block
                }
                ++i;
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException illegalProxy(PolyglotLanguageContext languageContext, String message, Object ... parameters) {
        throw PolyglotImpl.hostToGuestException(languageContext, new IllegalStateException(String.format(message, parameters)));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            if (!this.isMemberExisting(member, library, context, language)) {
                throw UnknownIdentifierException.create(member);
            }
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getMember, languageContext, this.proxy, member);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (!(this.proxy instanceof ProxyObject)) {
            throw UnsupportedMessageException.create();
        }
        PolyglotLanguageContext languageContext = context.get().internalContext;
        Value castValue = languageContext.asValue(value);
        GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().putMember, languageContext, this.proxy, member, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String member, Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            Object memberObject;
            if (!this.isMemberExisting(member, library, context, language)) {
                throw UnknownIdentifierException.create(member);
            }
            try {
                memberObject = this.readMember(member, library, context, language);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            PolyglotLanguageContext languageContext = context.get().internalContext;
            memberObject = languageContext.toGuestValue(library, memberObject);
            if (executables.isExecutable(memberObject)) {
                return executables.execute(memberObject, arguments);
            }
            throw UnsupportedMessageException.create();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyObject && this.isMemberExisting(member, library, context, language)) {
            try {
                return executables.isExecutable(this.readMember(member, library, context, language));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                return false;
            }
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeMember(String member, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            if (!this.isMemberExisting(member, library, context, language)) {
                throw UnknownIdentifierException.create(member);
            }
            PolyglotLanguageContext languageContext = context.get().internalContext;
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().removeMember, languageContext, this.proxy, member);
            if (!result) {
                throw UnknownIdentifierException.create(member);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberExisting(String member, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyObject) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().hasMember, languageContext, this.proxy, member);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyObject) {
            return !this.isMemberExisting(member, library, context, language);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDate() {
        return this.proxy instanceof ProxyDate;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTime() {
        return this.proxy instanceof ProxyTime;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTimeZone() {
        return this.proxy instanceof ProxyTimeZone;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyTimeZone) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (ZoneId)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asTimezone, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyDate) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (LocalDate)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asDate, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyTime) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (LocalTime)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asTime, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Instant asInstant(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyInstant) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Instant)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asInstant, languageContext, this.proxy);
        }
        if (this.isDate() && this.isTime() && this.isTimeZone()) {
            return ZonedDateTime.of(this.asDate(library, context, language), this.asTime(library, context, language), this.asTimeZone(library, context, language)).toInstant();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDuration() {
        return this.proxy instanceof ProxyDuration;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Duration asDuration(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyDuration) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Duration)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().asDuration, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return HostLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean config, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context) {
        try {
            return this.proxy.toString();
        }
        catch (Throwable t) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            throw PolyglotImpl.hostToGuestException(languageContext, t);
        }
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject(@CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context) {
        Class<?> javaObject = this.proxy.getClass();
        PolyglotLanguageContext languageContext = context.get().internalContext;
        return HostObject.forClass(javaObject, languageContext);
    }

    @ExportMessage
    boolean hasIterator() {
        return this.proxy instanceof ProxyIterable;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getIterator(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyIterable) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getIterator, languageContext, this.proxy);
            Object guestValue = languageContext.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.isIterator(guestValue)) {
                throw PolyglotProxy.illegalProxy(languageContext, "getIterator() returned an invalid value %s but must return an iterator.", languageContext.asValue(guestValue).toString());
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isIterator() {
        return this.proxy instanceof ProxyIterator;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasIteratorNextElement(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyIterator) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().hasIteratorNextElement, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getIteratorNextElement(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyIterator) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getIteratorNextElement, languageContext, this.proxy);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasHashEntries() {
        return this.proxy instanceof ProxyHashMap;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getHashSize(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyHashMap) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            return (Long)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getHashSize, languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryReadable"), @ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isHashValueExisting(Object key, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyHashMap) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Value keyValue = languageContext.asValue(key);
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().hasHashEntry, languageContext, this.proxy, keyValue);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readHashValue(Object key, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, UnknownKeyException {
        if (this.proxy instanceof ProxyHashMap) {
            if (!this.isHashValueExisting(key, library, context, language)) {
                throw UnknownKeyException.create(key);
            }
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Value keyValue = languageContext.asValue(key);
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getHashValue, languageContext, this.proxy, keyValue);
            return languageContext.toGuestValue(library, result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isHashEntryInsertable(Object key, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) {
        if (this.proxy instanceof ProxyHashMap) {
            return !this.isHashValueExisting(key, library, context, language);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeHashEntry(Object key, Object value, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (!(this.proxy instanceof ProxyHashMap)) {
            throw UnsupportedMessageException.create();
        }
        PolyglotLanguageContext languageContext = context.get().internalContext;
        Value keyValue = languageContext.asValue(key);
        Value valueValue = languageContext.asValue(value);
        GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().putHashEntry, languageContext, this.proxy, keyValue, valueValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeHashEntry(Object key, @CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException, UnknownKeyException {
        if (this.proxy instanceof ProxyHashMap) {
            if (!this.isHashValueExisting(key, library, context, language)) {
                throw UnknownKeyException.create(key);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
        PolyglotLanguageContext languageContext = context.get().internalContext;
        Value keyValue = languageContext.asValue(key);
        GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().removeHashEntry, languageContext, this.proxy, keyValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getHashEntriesIterator(@CachedLibrary(value="this") InteropLibrary library, @CachedContext(value=HostLanguage.class) TruffleLanguage.ContextReference<HostLanguage.HostContext> context, @CachedLanguage HostLanguage language) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyHashMap) {
            PolyglotLanguageContext languageContext = context.get().internalContext;
            Object result = GuestToHostRootNode.guestToHostCall(library, language.getHostToGuestCache().getHashEntriesIterator, languageContext, this.proxy);
            Object guestValue = languageContext.toGuestValue(library, result);
            InteropLibrary interop = InteropLibrary.getFactory().getUncached();
            if (!interop.isIterator(guestValue)) {
                throw PolyglotProxy.illegalProxy(languageContext, "getHashEntriesIterator() returned an invalid value %s but must return an iterator.", languageContext.asValue(guestValue).toString());
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static int identityHashCode(PolyglotProxy receiver) {
        return System.identityHashCode(receiver.proxy);
    }

    public static boolean isProxyGuestObject(TruffleObject value) {
        return value instanceof PolyglotProxy;
    }

    public static boolean isProxyGuestObject(Object value) {
        return value instanceof PolyglotProxy;
    }

    public static Proxy toProxyHostObject(TruffleObject value) {
        return ((PolyglotProxy)value).proxy;
    }

    public static TruffleObject toProxyGuestObject(Proxy receiver) {
        return new PolyglotProxy(receiver);
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(PolyglotProxy receiver, PolyglotProxy other) {
            return receiver.proxy == other.proxy ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(PolyglotProxy receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

