/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphics2d.VectorGraphicsConstants;
import org.freehep.graphicsio.test.TestingPanel;
import org.freehep.util.images.ImageHandler;

public class TestAll
extends TestingPanel
implements VectorGraphicsConstants {
    private BufferedImage marble;
    private BufferedImage sky;
    private static float[] dash = new float[]{10.0f, 5.0f, 2.0f, 5.0f};
    static /* synthetic */ Class class$org$freehep$graphicsio$test$TestAll;

    public TestAll(String[] args) throws Exception {
        super(args);
        this.setName("All");
    }

    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.marble == null) {
            MediaTracker t = new MediaTracker(this);
            Image skyI = ImageHandler.getImage((String)"images/sky.gif", (Class)(class$org$freehep$graphicsio$test$TestAll == null ? (class$org$freehep$graphicsio$test$TestAll = TestAll.class$("org.freehep.graphicsio.test.TestAll")) : class$org$freehep$graphicsio$test$TestAll));
            t.addImage(skyI, 0);
            try {
                t.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sky = new BufferedImage(skyI.getWidth(this), skyI.getHeight(this), 1);
            this.sky.createGraphics().drawImage(skyI, 0, 0, this);
        }
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        double width = dim.getWidth();
        double height = dim.getHeight();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        vg.setPaint((Paint)new GradientPaint(0.0f, 10.0f, Color.blue, (int)width, 10.0f, Color.white));
        vg.fillRect(0.0, 10.0, width, 30.0);
        vg.setFont(new Font("Helvetica", 1, 18));
        vg.setPaint((Paint)new GradientPaint(0.0f, 10.0f, Color.white, (int)width, 10.0f, Color.orange));
        String str = "Testing " + vg.getClass().getName();
        vg.drawString(str, 10, 30);
        double fx = 3.0 * width / 16.0;
        double fy = 5.0 * height / 16.0;
        double fw = width / 4.0;
        for (int i = 0; i < 15; ++i) {
            vg.setColor(Color.black);
            vg.fillRect(fx - fw / 2.0, fy - fw / 2.0, fw, fw);
            vg.setColor(Color.white);
            vg.fillOval(fx - fw / 2.0, fy - fw / 2.0, fw, fw);
            fw /= Math.sqrt(2.0);
        }
        vg.setColor(Color.black);
        vg.setFont(new Font("TimesRoman", 0, 11));
        vg.drawString(new TagString("The <i>drawString</i> methods in <i>VectorGraphics</i> support"), fx + 3.0 * width / 16.0, fy - width / 8.0 + 10.0);
        vg.drawString(new TagString("output of strings using a subset of the <b>HTML language</b>."), fx + 3.0 * width / 16.0, fy - width / 8.0 + 24.0);
        String text = "The direct output of attributed strings is supported too.";
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.FAMILY, "TimesRoman");
        as.addAttribute(TextAttribute.SIZE, new Float(11.0f));
        as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, text.indexOf("output"), text.indexOf("output") + "output".length());
        as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, text.indexOf("attributed"), text.indexOf("attributed") + "attributed".length());
        as.addAttribute(TextAttribute.TRANSFORM, AffineTransform.getTranslateInstance(0.0, 5.0), text.indexOf("supported"), text.indexOf("supported") + "supported".length());
        as.addAttribute(TextAttribute.FOREGROUND, Color.red, text.indexOf("strings"), text.indexOf("strings") + "strings".length());
        as.addAttribute(TextAttribute.BACKGROUND, new TexturePaint(this.sky, new Rectangle(0, 0, 100, 100)), text.indexOf("direct"), text.indexOf("direct") + "direct".length());
        vg.drawString(as.getIterator(), (float)(fx + 3.0 * width / 16.0), (float)(fy - width / 8.0 + 38.0));
        vg.setColor(Color.red);
        double sx = width / 2.0;
        double sy = 5.0 * height / 16.0;
        for (int i = 0; i < 10; ++i) {
            vg.drawSymbol(sx + (double)(15 * i), sy, 12.0, i);
            vg.fillSymbol(sx + (double)(15 * i), sy + 15.0, 10.0, i);
        }
        vg.setPaint((Paint)new TexturePaint(this.sky, new Rectangle2D.Double(0.0, 0.0, this.sky.getWidth(), this.sky.getHeight())));
        double mx = 0.0;
        double my = height / 2.0;
        vg.fillRect(mx, my, width / 2.0, height / 2.0);
        vg.setPaint((Paint)Color.black);
        vg.setFont(new Font("Impact", 1, 60));
        vg.drawString("\u25c4Impact\u25ba", mx + width / 4.0, my + height / 4.0, 2, 0);
        GeneralPath shape = new GeneralPath();
        shape.moveTo(0.0f, 0.0f);
        shape.lineTo(25.0f, 50.0f);
        shape.lineTo(-25.0f, 50.0f);
        shape.lineTo(25.0f, -50.0f);
        shape.lineTo(-25.0f, -50.0f);
        shape.closePath();
        Graphics subgraphics = vg.create();
        VectorGraphics svg = VectorGraphics.create((Graphics)subgraphics);
        svg.translate(width / 2.0, height / 2.0);
        svg.setStroke((Stroke)new BasicStroke(8.0f, 0, 2, 10.0f, null, 0.0f));
        svg.draw((Shape)shape);
        subgraphics = svg.create();
        VectorGraphics svg2 = VectorGraphics.create((Graphics)subgraphics);
        svg2.setColor(Color.black);
        svg2.setStroke((Stroke)new BasicStroke(3.0f, 1, 1, 10.0f, dash, 0.0f));
        svg2.rotate(0.6283185307179586);
        svg2.draw((Shape)shape);
        svg2.dispose();
        svg.setLineWidth(1);
        svg.shear(0.5, 0.5);
        svg.draw((Shape)shape);
        svg.dispose();
        subgraphics = vg.create();
        svg = VectorGraphics.create((Graphics)subgraphics);
        double tx = 3.0 * width / 4.0;
        double ty = 3.0 * height / 4.0;
        double d = width / 10.0;
        svg.setColor(Color.black);
        svg.translate(tx, ty);
        svg.fillOval(-d, -d, 2.0 * d, 2.0 * d);
        svg.setStroke((Stroke)new BasicStroke(4.0f, 1, 1, 10.0f, null, 0.0f));
        svg.drawOval(-1.4 * d, -1.4 * d, 2.8 * d, 2.8 * d);
        String circle = "ORAETLAB";
        svg.setFont(new Font("TimesRoman", 1, 16));
        for (int i = 0; i < circle.length(); ++i) {
            svg.drawString(circle.substring(i, i + 1), 0.0, -1.1 * d);
            svg.rotate(Math.PI * 2 / (double)circle.length());
        }
        svg.dispose();
    }

    public static void main(String[] args) throws Exception {
        new TestAll(args).runTest();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

