/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;

public class ByteArrayEndPoint
implements ConnectedEndPoint {
    protected byte[] _inBytes;
    protected ByteArrayBuffer _in;
    protected ByteArrayBuffer _out;
    protected boolean _closed;
    protected boolean _nonBlocking;
    protected boolean _growOutput;
    protected Connection _connection;
    protected int _maxIdleTime;

    public ByteArrayEndPoint() {
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    public boolean isNonBlocking() {
        return this._nonBlocking;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this._nonBlocking = nonBlocking;
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this._inBytes = input;
        this._in = new ByteArrayBuffer(input);
        this._out = new ByteArrayBuffer(outputSize);
    }

    public ByteArrayBuffer getIn() {
        return this._in;
    }

    public void setIn(ByteArrayBuffer in) {
        this._in = in;
    }

    public ByteArrayBuffer getOut() {
        return this._out;
    }

    public void setOut(ByteArrayBuffer out) {
        this._out = out;
    }

    @Override
    public boolean isOpen() {
        return !this._closed;
    }

    @Override
    public boolean isInputShutdown() {
        return this._closed;
    }

    @Override
    public boolean isOutputShutdown() {
        return this._closed;
    }

    @Override
    public boolean isBlocking() {
        return !this._nonBlocking;
    }

    @Override
    public boolean blockReadable(long millisecs) {
        return true;
    }

    @Override
    public boolean blockWritable(long millisecs) {
        return true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._in != null && this._in.length() > 0) {
            int len = buffer.put(this._in);
            this._in.skip(len);
            return len;
        }
        if (this._in != null && this._in.length() == 0 && this._nonBlocking) {
            return 0;
        }
        this.close();
        return -1;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._growOutput && buffer.length() > this._out.space()) {
            this._out.compact();
            if (buffer.length() > this._out.space()) {
                ByteArrayBuffer n = new ByteArrayBuffer(this._out.putIndex() + buffer.length());
                n.put(this._out.peek(0, this._out.putIndex()));
                if (this._out.getIndex() > 0) {
                    n.mark();
                    n.setGetIndex(this._out.getIndex());
                }
                this._out = n;
            }
        }
        int len = this._out.put(buffer);
        buffer.skip(len);
        return len;
    }

    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        int flushed = 0;
        if (header != null && header.length() > 0) {
            flushed = this.flush(header);
        }
        if (header == null || header.length() == 0) {
            if (buffer != null && buffer.length() > 0) {
                flushed += this.flush(buffer);
            }
            if ((buffer == null || buffer.length() == 0) && trailer != null && trailer.length() > 0) {
                flushed += this.flush(trailer);
            }
        }
        return flushed;
    }

    public void reset() {
        this._closed = false;
        this._in.clear();
        this._out.clear();
        if (this._inBytes != null) {
            this._in.setPutIndex(this._inBytes.length);
        }
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public String getLocalHost() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public Object getTransport() {
        return this._inBytes;
    }

    @Override
    public void flush() throws IOException {
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean growOutput) {
        this._growOutput = growOutput;
    }

    @Override
    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

