/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class BooleanMetaData
extends BaseColumnMetaData {
    public BooleanMetaData(@JsonProperty(value="name") String name) {
        super(name);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Boolean;
    }

    @Override
    public boolean isValid(Writable writable) {
        try {
            boolean value = Boolean.parseBoolean(writable.toString());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(Object input) {
        try {
            boolean value = Boolean.parseBoolean(input.toString());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public BooleanMetaData clone() {
        return new BooleanMetaData(this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BooleanMetaData(name=\"").append(this.name).append("\",");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BooleanMetaData)) {
            return false;
        }
        BooleanMetaData other = (BooleanMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BooleanMetaData;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

