/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnIdx", "stateNames", "statesMap"})
public class CategoricalToOneHotTransform
extends BaseTransform {
    private String columnName;
    private int columnIdx = -1;
    private List<String> stateNames;
    private Map<String, Integer> statesMap;

    public CategoricalToOneHotTransform(@JsonProperty(value="columnName") String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        super.setInputSchema(inputSchema);
        this.columnIdx = inputSchema.getIndexOfColumn(this.columnName);
        ColumnMetaData meta = inputSchema.getMetaData(this.columnName);
        if (!(meta instanceof CategoricalMetaData)) {
            throw new IllegalStateException("Cannot convert column \"" + this.columnName + "\" from categorical to one-hot: column is not categorical (is: " + meta.getColumnType() + ")");
        }
        this.stateNames = ((CategoricalMetaData)meta).getStateNames();
        this.statesMap = new HashMap<String, Integer>(this.stateNames.size());
        for (int i = 0; i < this.stateNames.size(); ++i) {
            this.statesMap.put(this.stateNames.get(i), i);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoricalToOneHotTransform o2 = (CategoricalToOneHotTransform)o;
        return this.columnName.equals(o2.columnName);
    }

    @Override
    public int hashCode() {
        return this.columnName.hashCode();
    }

    @Override
    public String toString() {
        return "CategoricalToOneHotTransform(columnName=\"" + this.columnName + "\")";
    }

    @Override
    public Schema transform(Schema schema) {
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        int i = 0;
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> typesIter = origMeta.iterator();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(schema.numColumns());
        while (namesIter.hasNext()) {
            String s = namesIter.next();
            ColumnMetaData t = typesIter.next();
            if (i++ == this.columnIdx) {
                for (String stateName : this.stateNames) {
                    String newName = s + "[" + stateName + "]";
                    newMeta.add(new IntegerMetaData(newName, 0, 1));
                }
                continue;
            }
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int idx = this.getColumnIdx();
        int n = this.stateNames.size();
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == idx) {
                String str = w.toString();
                Integer classIdx = this.statesMap.get(str);
                if (classIdx == null) {
                    throw new IllegalStateException("Cannot convert categorical value to one-hot: input value (\"" + str + "\") is not in the list of known categories (state names/categories: " + this.stateNames + ")");
                }
                for (int j = 0; j < n; ++j) {
                    if (j == classIdx) {
                        out.add(new IntWritable(1));
                        continue;
                    }
                    out.add(new IntWritable(0));
                }
                continue;
            }
            out.add(w);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        String str = input.toString();
        ArrayList<Integer> oneHot = new ArrayList<Integer>();
        int n = this.stateNames.size();
        Integer classIdx = this.statesMap.get(str);
        if (classIdx == null) {
            throw new IllegalStateException("Cannot convert categorical value to one-hot: input value (\"" + str + "\") is not in the list of known categories (state names/categories: " + this.stateNames + ")");
        }
        for (int j = 0; j < n; ++j) {
            if (j == classIdx) {
                oneHot.add(1);
                continue;
            }
            oneHot.add(0);
        }
        return oneHot;
    }

    @Override
    public Object mapSequence(Object sequence) {
        List values = (List)sequence;
        ArrayList<List> ret = new ArrayList<List>();
        for (Object obj : values) {
            ret.add((List)this.map(obj));
        }
        return ret;
    }

    @Override
    public String outputColumnName() {
        throw new UnsupportedOperationException("Output column name will be more than 1");
    }

    @Override
    public String[] outputColumnNames() {
        return this.stateNames.toArray(new String[this.stateNames.size()]);
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName};
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public Map<String, Integer> getStatesMap() {
        return this.statesMap;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public void setStatesMap(Map<String, Integer> statesMap) {
        this.statesMap = statesMap;
    }
}

