/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DoubleMetaData
extends BaseColumnMetaData {
    private final Double minAllowedValue;
    private final Double maxAllowedValue;
    private final boolean allowNaN;
    private final boolean allowInfinite;

    public DoubleMetaData(String name) {
        this(name, null, null, false, false);
    }

    public DoubleMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="minAllowedValue") Double minAllowedValue, @JsonProperty(value="maxAllowedValue") Double maxAllowedValue) {
        this(name, minAllowedValue, maxAllowedValue, false, false);
    }

    public DoubleMetaData(String name, Double min, Double maxAllowedValue, boolean allowNaN, boolean allowInfinite) {
        super(name);
        this.minAllowedValue = min;
        this.maxAllowedValue = maxAllowedValue;
        this.allowNaN = allowNaN;
        this.allowInfinite = allowInfinite;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Double;
    }

    @Override
    public boolean isValid(Writable writable) {
        double d;
        try {
            d = writable.toDouble();
        }
        catch (Exception e) {
            return false;
        }
        if (this.allowNaN && Double.isNaN(d)) {
            return true;
        }
        if (this.allowInfinite && Double.isInfinite(d)) {
            return true;
        }
        if (this.minAllowedValue != null && d < this.minAllowedValue) {
            return false;
        }
        return this.maxAllowedValue == null || !(d > this.maxAllowedValue);
    }

    @Override
    public boolean isValid(Object input) {
        double d;
        try {
            d = Double.valueOf(input.toString());
        }
        catch (Exception e) {
            return false;
        }
        if (this.allowNaN && Double.isNaN(d)) {
            return true;
        }
        if (this.allowInfinite && Double.isInfinite(d)) {
            return true;
        }
        if (this.minAllowedValue != null && d < this.minAllowedValue) {
            return false;
        }
        return this.maxAllowedValue == null || !(d > this.maxAllowedValue);
    }

    @Override
    public DoubleMetaData clone() {
        return new DoubleMetaData(this.name, this.minAllowedValue, this.maxAllowedValue, this.allowNaN, this.allowInfinite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoubleMetaData(name=\"").append(this.name).append("\",");
        boolean needComma = false;
        if (this.minAllowedValue != null) {
            sb.append("minAllowed=").append(this.minAllowedValue);
            needComma = true;
        }
        if (this.maxAllowedValue != null) {
            if (needComma) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.maxAllowedValue);
            needComma = true;
        }
        if (needComma) {
            sb.append(",");
        }
        sb.append("allowNaN=").append(this.allowNaN).append(",allowInfinite=").append(this.allowInfinite).append(")");
        return sb.toString();
    }

    public Double getMinAllowedValue() {
        return this.minAllowedValue;
    }

    public Double getMaxAllowedValue() {
        return this.maxAllowedValue;
    }

    public boolean isAllowNaN() {
        return this.allowNaN;
    }

    public boolean isAllowInfinite() {
        return this.allowInfinite;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleMetaData)) {
            return false;
        }
        DoubleMetaData other = (DoubleMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllowNaN() != other.isAllowNaN()) {
            return false;
        }
        if (this.isAllowInfinite() != other.isAllowInfinite()) {
            return false;
        }
        Double this$minAllowedValue = this.getMinAllowedValue();
        Double other$minAllowedValue = other.getMinAllowedValue();
        if (this$minAllowedValue == null ? other$minAllowedValue != null : !((Object)this$minAllowedValue).equals(other$minAllowedValue)) {
            return false;
        }
        Double this$maxAllowedValue = this.getMaxAllowedValue();
        Double other$maxAllowedValue = other.getMaxAllowedValue();
        return !(this$maxAllowedValue == null ? other$maxAllowedValue != null : !((Object)this$maxAllowedValue).equals(other$maxAllowedValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllowNaN() ? 79 : 97);
        result = result * 59 + (this.isAllowInfinite() ? 79 : 97);
        Double $minAllowedValue = this.getMinAllowedValue();
        result = result * 59 + ($minAllowedValue == null ? 43 : ((Object)$minAllowedValue).hashCode());
        Double $maxAllowedValue = this.getMaxAllowedValue();
        result = result * 59 + ($maxAllowedValue == null ? 43 : ((Object)$maxAllowedValue).hashCode());
        return result;
    }
}

