/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.histogram;

import org.datavec.api.transform.analysis.histogram.DoubleHistogramCounter;
import org.datavec.api.transform.analysis.histogram.HistogramCounter;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayHistogramCounter
implements HistogramCounter {
    private DoubleHistogramCounter underlying;

    public NDArrayHistogramCounter(double minValue, double maxValue, int nBins) {
        this.underlying = new DoubleHistogramCounter(minValue, maxValue, nBins);
    }

    @Override
    public HistogramCounter add(Writable w) {
        INDArray arr = ((NDArrayWritable)w).get();
        if (arr == null) {
            return this;
        }
        long length = arr.length();
        DoubleWritable dw = new DoubleWritable();
        int i = 0;
        while ((long)i < length) {
            dw.set(arr.getDouble((long)i));
            this.underlying.add(dw);
            ++i;
        }
        return this;
    }

    @Override
    public NDArrayHistogramCounter merge(HistogramCounter other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof NDArrayHistogramCounter)) {
            throw new IllegalArgumentException("Cannot merge " + other.getClass());
        }
        NDArrayHistogramCounter o = (NDArrayHistogramCounter)other;
        if (this.underlying == null) {
            this.underlying = o.underlying;
        } else {
            if (o.underlying == null) {
                return this;
            }
            this.underlying.merge(o.underlying);
        }
        return this;
    }

    @Override
    public double[] getBins() {
        return this.underlying.getBins();
    }

    @Override
    public long[] getCounts() {
        return this.underlying.getCounts();
    }
}

