/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.runner.api.Runner;
import org.sonar.runner.impl.BatchLauncher;

public class EmbeddedRunner
extends Runner<EmbeddedRunner> {
    private final BatchLauncher batchLauncher;
    private final List<Object> extensions = new ArrayList<Object>();
    private static final String MASK_RULES_PROP = "sonarRunner.maskRules";

    EmbeddedRunner(BatchLauncher bl) {
        this.batchLauncher = bl;
    }

    public static EmbeddedRunner create() {
        return new EmbeddedRunner(new BatchLauncher());
    }

    public EmbeddedRunner unmask(String fqcnPrefix) {
        return this.addMaskRule("UNMASK", fqcnPrefix);
    }

    public EmbeddedRunner mask(String fqcnPrefix) {
        return this.addMaskRule("MASK", fqcnPrefix);
    }

    private EmbeddedRunner addMaskRule(String type, String fqcnPrefix) {
        String existingRules = this.property(MASK_RULES_PROP, "");
        if (!"".equals(existingRules)) {
            existingRules = existingRules + ",";
        }
        existingRules = existingRules + type + "|" + fqcnPrefix;
        return (EmbeddedRunner)this.setProperty(MASK_RULES_PROP, existingRules);
    }

    @Deprecated
    public EmbeddedRunner setUnmaskedPackages(String ... packages) {
        for (String packagePrefix : packages) {
            this.unmask(packagePrefix + ".");
        }
        return this;
    }

    public EmbeddedRunner addExtensions(Object ... objects) {
        this.extensions.addAll(Arrays.asList(objects));
        return this;
    }

    List<Object> extensions() {
        return this.extensions;
    }

    @Override
    protected void doExecute() {
        this.batchLauncher.execute(this.properties(), this.extensions);
    }
}

