/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.IOException;
import org.sonar.runner.impl.Logs;
import org.sonar.runner.impl.ServerConnection;

class ServerVersion {
    private static final String[] LESS_THAN_3_0 = new String[]{"0", "1", "2"};
    private static final String[] LESS_THAN_3_5 = new String[]{"0", "1", "2", "3.0", "3.1", "3.2", "3.3", "3.4"};
    private final ServerConnection serverConnection;
    private String version;

    ServerVersion(ServerConnection serverConnection) {
        this.serverConnection = serverConnection;
    }

    String version() {
        if (this.version == null) {
            this.version = this.downloadVersion();
            Logs.info("SonarQube Server " + this.version);
        }
        return this.version;
    }

    private String downloadVersion() {
        String result;
        try {
            result = this.serverConnection.downloadString("/api/server/version");
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request server version", e);
        }
        if (result == null || "".equals(result.trim())) {
            throw new IllegalStateException("Server version is not set");
        }
        return result;
    }

    boolean is30Compatible() {
        return !ServerVersion.inVersions(this.version(), LESS_THAN_3_0);
    }

    boolean is35Compatible() {
        return !ServerVersion.inVersions(this.version(), LESS_THAN_3_5);
    }

    private static boolean inVersions(String version, String[] versions) {
        for (String s : versions) {
            if (!ServerVersion.isVersion(version, s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersion(String version, String prefix) {
        return version.startsWith(prefix + ".") || version.equals(prefix);
    }
}

