/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.sonar.runner.impl.BatchLauncher;

public class BatchLauncherMain {
    private final BatchLauncher launcher;

    BatchLauncherMain(BatchLauncher l) {
        this.launcher = l;
    }

    void execute(String[] args) throws IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing path to properties file");
        }
        Properties props = this.loadProperties(args[0]);
        this.launcher.execute(props, Collections.<Object>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String arg) throws IOException {
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(arg);
        try {
            props.load(input);
            props.remove("sonarRunner.maskRules");
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        return props;
    }

    public static void main(String[] args) throws IOException {
        new BatchLauncherMain(new BatchLauncher()).execute(args);
    }
}

