package org.codehaus.plexus.component.manager;

import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;

import java.util.Map;

/**
 *
 *
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 *
 * @version $Id: ComponentManagerManager.java 1750 2005-04-19 07:45:02Z brett $
 */
public interface ComponentManagerManager
{
    String ROLE = ComponentManagerManager.class.getName();

    void setLifecycleHandlerManager( LifecycleHandlerManager lifecycleHandlerManager );

    // ----------------------------------------------------------------------
    // Component manager handling
    // ----------------------------------------------------------------------

    ComponentManager findComponentManagerByComponentKey( String componentKey );

    ComponentManager findComponentManagerByComponentInstance( Object component );

    ComponentManager createComponentManager( ComponentDescriptor descriptor, PlexusContainer container )
        throws UndefinedComponentManagerException, UndefinedLifecycleHandlerException;

    Map getComponentManagers();

    void associateComponentWithComponentManager( Object component, ComponentManager componentManager );
}
