/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.logging.Log;

public class FilteredJarFile
extends JarFile {
    private Log logger;

    public FilteredJarFile(File arg0, Log log) throws IOException {
        super(arg0);
        this.logger = log;
    }

    public List getEntryPathsAndExtract(String[] filter, File prefix) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<JarEntry> e = this.entries();
        while (e.hasMoreElements()) {
            JarEntry nextEntry = e.nextElement();
            if (nextEntry.isDirectory() || this.isFiltered(nextEntry.getName(), filter)) continue;
            this.logger.debug((CharSequence)("adding and extracting " + nextEntry.getName()));
            this.extractEntry(prefix, nextEntry);
            entries.add(nextEntry.getName());
        }
        return entries;
    }

    private boolean isFiltered(String name, String[] filter) {
        int size = filter.length;
        if (name != null) {
            for (int i = 0; i < size; ++i) {
                if (!name.endsWith(filter[i])) continue;
                this.logger.debug((CharSequence)("Accepting " + name));
                return false;
            }
            this.logger.debug((CharSequence)("Filtering " + name));
            return true;
        }
        this.logger.debug((CharSequence)"Filtering out null.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractEntry(File prefix, JarEntry entry) throws IOException {
        File output = new File(prefix, entry.getName());
        if (!output.exists()) {
            output.getParentFile().mkdirs();
            output.createNewFile();
            InputStream ios = null;
            FileOutputStream fos = null;
            try {
                int length;
                ios = this.getInputStream(entry);
                fos = new FileOutputStream(output);
                byte[] buf = new byte[8192];
                while ((length = ios.read(buf)) >= 0) {
                    fos.write(buf, 0, length);
                }
            }
            finally {
                if (ios != null) {
                    try {
                        ios.close();
                    }
                    catch (IOException ignore) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
    }
}

