/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.control;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.AbstractStepContainer;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NotStep
extends AbstractStepContainer {
    private static final Logger LOG = Logger.getLogger(NotStep.class);
    public static final String DEFAULT_DESCRIPTION = "not";

    public void doExecute() throws Exception {
        boolean allStepsFailed = true;
        Task currentStep = null;
        Iterator iter = this.getSteps().iterator();
        while (iter.hasNext() && allStepsFailed) {
            try {
                currentStep = (Task)iter.next();
                this.executeContainedStep(currentStep);
                allStepsFailed = false;
            }
            catch (BuildException e) {
                if (StepFailedException.isCausedByStepFailedException(e)) {
                    LOG.debug((Object)("Ignoring expected exception: " + e.getMessage()));
                    continue;
                }
                LOG.debug((Object)"Rethrowing exception");
                throw e;
            }
            catch (Exception e) {
                LOG.debug((Object)"Step failed", (Throwable)e);
                throw e;
            }
            finally {
                LOG.debug((Object)"finished NOT step");
            }
        }
        if (!allStepsFailed) {
            StringBuffer message = new StringBuffer("Wrapped step did not fail");
            if (currentStep.getDescription() != null) {
                message.append(": ");
                message.append(currentStep.getDescription());
            }
            throw new StepFailedException(message.toString(), this);
        }
    }
}

