/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.WebTestException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import javax.xml.xpath.XPathException;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.XNIException;
import org.xml.sax.SAXException;

public class StepUtil {
    private static final Logger LOG = Logger.getLogger(StepUtil.class);

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    public static void handleException(Throwable e) {
        if (e instanceof WebTestException) {
            throw (WebTestException)((Object)e);
        }
        if (e instanceof FailingHttpStatusCodeException) {
            LOG.debug((Object)("Wrapping FailingHttpStatusCodeException in StepFailedException: " + e.getMessage()));
            FailingHttpStatusCodeException he = (FailingHttpStatusCodeException)e;
            throw new StepFailedException("HTTP error " + he.getStatusCode(), (Exception)((Object)he));
        }
        if (e instanceof XPathException) {
            LOG.debug((Object)("Wrapping XPathException in StepFailedException: " + e.getMessage()));
            throw new StepFailedException(e.getMessage(), (Exception)e);
        }
        if (e instanceof ScriptException) {
            ScriptException se = (ScriptException)e;
            HtmlPage page = se.getPage();
            StepFailedException sfe = new StepFailedException("JavaScript error loading page " + (page != null ? page.getUrl().toString() : "") + ": " + se.getMessage(), (Exception)se);
            sfe.addDetail("javascript error", se.getMessage());
            sfe.addDetail("line", String.valueOf(se.getFailingLineNumber()));
            sfe.addDetail("javascript source", se.getScriptSourceCode());
            String failingLine = se.getFailingLine();
            if (failingLine != null) {
                sfe.addDetail("failing line", failingLine);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            se.printScriptStackTrace(printWriter);
            sfe.addDetail("javascript call stack", stringWriter.toString());
            throw sfe;
        }
        if (e instanceof SocketTimeoutException) {
            SocketTimeoutException ste = (SocketTimeoutException)e;
            throw new StepFailedException("Server took to long to answer: " + ste.getMessage(), ste);
        }
        if (e instanceof SAXException) {
            throw new StepExecutionException("Response is not well-formed: " + e.getMessage(), e);
        }
        if (e instanceof XNIException) {
            Throwable originalException = StepUtil.extractNestedException(e);
            throw new StepExecutionException("XNIException caused by " + originalException.getMessage(), originalException);
        }
        throw new StepExecutionException("Unexpected exception caught: " + e.getClass().getName(), e);
    }
}

