/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.MimeType;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;

public class VerifyLinkedContent
extends Step {
    private static final Logger LOG = Logger.getLogger(VerifyLinkedContent.class);
    private String fXpath;
    private String fAccept;
    private MimeType fMimeTypes = MimeType.ALL_MEDIA;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    protected void verifyParameters() {
        this.nullResponseCheck();
        this.nullParamCheck(this.getXpath(), "xpath");
        if (this.getAccept() != null) {
            this.fMimeTypes = new MimeType(this.getAccept());
        }
    }

    public void setXpath(String xpath) {
        this.fXpath = xpath;
    }

    public String getXpath() {
        return this.fXpath;
    }

    public void setAccept(String accept) {
        this.fAccept = accept;
    }

    public String getAccept() {
        return this.fAccept;
    }

    public void doExecute() throws Exception {
        HtmlPage currentResponse;
        Context context = this.getContext();
        try {
            currentResponse = (HtmlPage)context.getCurrentResponse();
        }
        catch (ClassCastException cce) {
            throw new StepFailedException("Current response is not an html page but " + context.getCurrentResponse().getClass(), this);
        }
        StringBuffer sb = this.verifyLinksOnPage(currentResponse);
        if (sb.length() > 0) {
            sb.insert(0, currentResponse.getUrl().toExternalForm() + ":" + LINE_SEPARATOR);
            throw new StepFailedException(sb.toString(), this);
        }
    }

    WebClient setupWebClient() {
        WebClient webClient = this.getContext().getConfig().createWebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.setWebConnection(this.getContext().getWebClient().getWebConnection());
        return webClient;
    }

    StringBuffer verifyLinksOnPage(HtmlPage htmlPage) throws Exception {
        WebClient webClient = this.setupWebClient();
        StringBuffer sb = new StringBuffer();
        Iterator it = this.iterateAllMatchingElements(htmlPage).iterator();
        while (it.hasNext()) {
            sb.append(this.verifyOneLink(webClient, htmlPage, (Attr)it.next()));
        }
        return sb;
    }

    String verifyOneLink(WebClient webClient, HtmlPage htmlPage, Attr linkAttribute) throws IOException {
        String key = linkAttribute.getLocalName();
        String src = linkAttribute.getValue();
        URL url = htmlPage.getFullyQualifiedUrl(src);
        LOG.debug((Object)(src + " -> " + url.toExternalForm()));
        try {
            Page resp = webClient.getPage(url);
            String contentType = resp.getWebResponse().getContentType();
            if (!this.fMimeTypes.match(contentType)) {
                StringBuffer sb = new StringBuffer();
                sb.append(src).append(" <").append(url.toExternalForm()).append("> ");
                sb.append(contentType).append(" is not expected").append(LINE_SEPARATOR);
                LOG.info((Object)("Failed link with " + key + "=\"" + src + "\", mime-type is " + contentType));
                return sb.toString();
            }
        }
        catch (FailingHttpStatusCodeException fhsce) {
            StringBuffer sb = new StringBuffer();
            sb.append(src).append(" <").append(url.toExternalForm()).append("> ");
            sb.append(fhsce.getStatusCode()).append(" ").append(fhsce.getMessage()).append(LINE_SEPARATOR);
            LOG.info((Object)("Failed link with " + key + "=\"" + src + "\", code is " + fhsce.getStatusCode()));
            return sb.toString();
        }
        LOG.debug((Object)("Link with " + key + "=\"" + src + "\" is ok"));
        return "";
    }

    List iterateAllMatchingElements(HtmlPage htmlPage) throws Exception {
        try {
            return this.getContext().getXPathHelper().selectNodes((Page)htmlPage, this.getXpath());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isPerformingAction() {
        return false;
    }
}

