/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.mojo.weblogic.AbstractWeblogicMojo;
import org.codehaus.mojo.weblogic.util.Bootstrapper;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;
import weblogic.wsee.tools.anttasks.ClientGenTask;
import weblogic.wsee.tools.anttasks.JwsModule;
import weblogic.wsee.tools.anttasks.MultipleJwsModule;

public class ClientGen9Mojo
extends AbstractWeblogicMojo {
    private String warFileName;
    private String inputWSDL;
    private String outputDir;
    private String packageName;
    private String serviceName;
    private boolean verbose;
    private boolean useServerTypes;
    private boolean autotype;
    private boolean jaxRPCWrappedArrayStyle;
    private boolean generateAsyncMethods;
    private String handlerChainFile;
    private boolean skipClientGen;
    private String wsType;
    private boolean debug;
    private String bindingFile;

    public void setSkipClientGen(boolean skipClientGen) {
        this.skipClientGen = skipClientGen;
    }

    public void setWsType(String wsType) {
        this.wsType = wsType;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void setBindingFile(String bindingFile) {
        this.bindingFile = bindingFile;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getBindingFile() {
        return this.bindingFile;
    }

    public boolean isSkipClientGen() {
        return this.skipClientGen;
    }

    public String getWsType() {
        return this.wsType;
    }

    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.skipClientGen) {
            this.getLog().info((CharSequence)"skipping client gen");
            return;
        }
        File tmpFile = null;
        try {
            String executeClass = ClientGenExecutor.class.getName();
            URI[] classPathUrls = WeblogicMojoUtilities.getDependenciesAsUri(this.getArtifacts(), this.getPluginArtifacts());
            StringBuffer path = new StringBuffer(1024);
            path.append(this.getWeblogicJar().toURI()).append(' ');
            for (URI url : classPathUrls) {
                path.append(url).append(' ');
            }
            path.append(Bootstrapper.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            ClientGenParameters params = new ClientGenParameters();
            params.setClassPath(WeblogicMojoUtilities.getDependencies(this.getArtifacts(), this.getPluginArtifacts()));
            params.setDebug(this.debug);
            params.setDestDir(new File(this.outputDir));
            params.setDestEncoding("UTF-8");
            params.setNoWarn(false);
            params.setSrcEncoding("UTF-8");
            params.setVerbose(this.verbose);
            params.setWsType(this.wsType != null && this.wsType.trim().length() > 0 ? this.wsType : null);
            params.packageName = this.packageName;
            params.useServerTypes = this.useServerTypes;
            params.serviceName = this.serviceName;
            params.handlerChainFile = this.handlerChainFile;
            params.bindingFile = this.bindingFile;
            params.srcDir = new File(this.outputDir);
            String wsdlUri = null;
            if (this.warFileName != null) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" calculating wsdl URI from warFileName " + this.warFileName + " with wsdl " + this.inputWSDL));
                }
                wsdlUri = "jar:file:" + WeblogicMojoUtilities.getWarFileName(this.getArtifacts(), this.warFileName) + "!" + this.inputWSDL;
                new File(this.inputWSDL).toURI().toString();
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + wsdlUri + " for clientgen."));
                }
            } else if (this.inputWSDL.startsWith("http")) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + this.inputWSDL + " for clientgen."));
                }
                wsdlUri = this.inputWSDL;
            } else {
                wsdlUri = new File(this.inputWSDL).toURI().toString();
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)(" using " + wsdlUri + " for clientgen."));
                }
            }
            params.inputWSDL = wsdlUri;
            tmpFile = ClientGen9Mojo.serialize(params);
            Bootstrapper.exec(path.toString(), new String[]{executeClass, tmpFile != null ? tmpFile.getPath() : ""});
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while bootstrapping clientGen", e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File serialize(ClientGenParameters params) throws IOException {
        FileOutputStream file = null;
        ObjectOutputStream ois = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("clientGenParams", ".bin");
            file = new FileOutputStream(tmpFile);
            ois = new ObjectOutputStream(file);
            ois.writeObject(params);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
        }
        return tmpFile;
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String inInputWSDL) {
        this.inputWSDL = inInputWSDL;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String inOutputDir) {
        this.outputDir = inOutputDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String inServiceName) {
        this.serviceName = inServiceName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientGen9Mojo");
        sb.append("{warFileName='").append(this.warFileName).append('\'');
        sb.append(", inputWSDL='").append(this.inputWSDL).append('\'');
        sb.append(", outputDir='").append(this.outputDir).append('\'');
        sb.append(", packageName='").append(this.packageName).append('\'');
        sb.append(", serviceName='").append(this.serviceName).append('\'');
        sb.append(", verbose=").append(this.verbose);
        sb.append(", useServerTypes=").append(this.useServerTypes);
        sb.append(", autotype=").append(this.autotype);
        sb.append(", jaxRPCWrappedArrayStyle=").append(this.jaxRPCWrappedArrayStyle);
        sb.append(", generateAsyncMethods=").append(this.generateAsyncMethods);
        sb.append(", handlerChainFile='").append(this.handlerChainFile).append('\'');
        sb.append(", skipClientGen=").append(this.skipClientGen);
        sb.append(", wsType='").append(this.wsType).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isUseServerTypes() {
        return this.useServerTypes;
    }

    public void setUseServerTypes(boolean useServerTypes) {
        this.useServerTypes = useServerTypes;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAutotype() {
        return this.autotype;
    }

    public void setAutotype(boolean autotype) {
        this.autotype = autotype;
    }

    public String getWarFileName() {
        return this.warFileName;
    }

    public void setWarFileName(String warFileName) {
        this.warFileName = warFileName;
    }

    public boolean isJaxRPCWrappedArrayStyle() {
        return this.jaxRPCWrappedArrayStyle;
    }

    public void setJaxRPCWrappedArrayStyle(boolean jaxRPCWrappedArrayStyle) {
        this.jaxRPCWrappedArrayStyle = jaxRPCWrappedArrayStyle;
    }

    public boolean isGenerateAsyncMethods() {
        return this.generateAsyncMethods;
    }

    public void setGenerateAsyncMethods(boolean generateAsyncMethods) {
        this.generateAsyncMethods = generateAsyncMethods;
    }

    public String getHandlerChainFile() {
        return this.handlerChainFile;
    }

    public void setHandlerChainFile(String handlerChainFile) {
        this.handlerChainFile = handlerChainFile;
    }

    static class ClientGenParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String classPath;
        private boolean noWarn;
        private File destDir;
        private boolean verbose;
        private boolean optimize;
        private boolean debug;
        private File srcDir;
        private String destEncoding;
        private String srcEncoding;
        private boolean keepGenerated;
        private File inputDir;
        private String descriptors;
        private String outtputName;
        private boolean explode;
        private String contextPath;
        private String sourcePath;
        private String wsType;
        private String srcExcludes;
        private String packageName;
        private boolean useServerTypes;
        private String serviceName;
        private String handlerChainFile;
        private String inputWSDL;
        public String bindingFile;

        ClientGenParameters() {
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public String getClassPath() {
            return this.classPath;
        }

        public void setClassPath(String classPath) {
            this.classPath = classPath;
        }

        public boolean isNoWarn() {
            return this.noWarn;
        }

        public void setNoWarn(boolean noWarn) {
            this.noWarn = noWarn;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public void setDestDir(File destDir) {
            this.destDir = destDir;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean isOptimize() {
            return this.optimize;
        }

        public void setOptimize(boolean optimize) {
            this.optimize = optimize;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public File getSrcDir() {
            return this.srcDir;
        }

        public void setSrcDir(File srcDir) {
            this.srcDir = srcDir;
        }

        public String getDestEncoding() {
            return this.destEncoding;
        }

        public void setDestEncoding(String destEncoding) {
            this.destEncoding = destEncoding;
        }

        public String getSrcEncoding() {
            return this.srcEncoding;
        }

        public void setSrcEncoding(String srcEncoding) {
            this.srcEncoding = srcEncoding;
        }

        public boolean isKeepGenerated() {
            return this.keepGenerated;
        }

        public void setKeepGenerated(boolean keepGenerated) {
            this.keepGenerated = keepGenerated;
        }

        public File getInputDir() {
            return this.inputDir;
        }

        public void setInputDir(File inputDir) {
            this.inputDir = inputDir;
        }

        public String getDescriptors() {
            return this.descriptors;
        }

        public void setDescriptors(String descriptors) {
            this.descriptors = descriptors;
        }

        public String getOuttputName() {
            return this.outtputName;
        }

        public void setOuttputName(String outtputName) {
            this.outtputName = outtputName;
        }

        public boolean isExplode() {
            return this.explode;
        }

        public void setExplode(boolean explode) {
            this.explode = explode;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public void setWsType(String wsType) {
            this.wsType = wsType;
        }

        public String getSrcExcludes() {
            return this.srcExcludes;
        }

        public void setSrcExcludes(String srcExcludes) {
            this.srcExcludes = srcExcludes;
        }

        public String getWsType() {
            return this.wsType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ClientGenParameters");
            sb.append("{classPath='").append(this.classPath).append('\'');
            sb.append(", noWarn=").append(this.noWarn);
            sb.append(", destDir=").append(this.destDir);
            sb.append(", verbose=").append(this.verbose);
            sb.append(", optimize=").append(this.optimize);
            sb.append(", debug=").append(this.debug);
            sb.append(", srcDir=").append(this.srcDir);
            sb.append(", destEncoding='").append(this.destEncoding).append('\'');
            sb.append(", srcEncoding='").append(this.srcEncoding).append('\'');
            sb.append(", keepGenerated=").append(this.keepGenerated);
            sb.append(", inputDir=").append(this.inputDir);
            sb.append(", descriptors='").append(this.descriptors).append('\'');
            sb.append(", outtputName='").append(this.outtputName).append('\'');
            sb.append(", explode=").append(this.explode);
            sb.append(", contextPath='").append(this.contextPath).append('\'');
            sb.append(", sourcePath='").append(this.sourcePath).append('\'');
            sb.append(", wsType='").append(this.wsType).append('\'');
            sb.append(", srcExcludes='").append(this.srcExcludes).append('\'');
            sb.append(", packageName='").append(this.packageName).append('\'');
            sb.append(", useServerTypes=").append(this.useServerTypes);
            sb.append(", serviceName='").append(this.serviceName).append('\'');
            sb.append(", handlerChainFile='").append(this.handlerChainFile).append('\'');
            sb.append(", inputWSDL='").append(this.inputWSDL).append('\'');
            sb.append(", bindingFile='").append(this.bindingFile).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class ClientGenExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) throws Exception {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(args[0]));
                ClientGenParameters params = (ClientGenParameters)ois.readObject();
                ClientGenExecutor.execute(params);
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
            }
        }

        private static void execute(ClientGenParameters params) throws MojoExecutionException {
            System.out.println(params);
            try {
                boolean mk;
                if (params.destDir != null && params.destDir.exists() && !(mk = params.destDir.mkdirs())) {
                    System.out.println(String.format("Did not make the output dir %s", params.destDir));
                }
                ClientGenTask clientGen = new ClientGenTask();
                Project project = new Project();
                project.setName("clientgen");
                String pathString = params.getClassPath();
                Path path = new Path(project, pathString);
                clientGen.setProject(project);
                clientGen.setClasspath(path);
                clientGen.setVerbose(params.verbose);
                clientGen.setDebug(params.debug);
                clientGen.setSrcdir(params.srcDir);
                clientGen.setDestDir(params.destDir);
                clientGen.setPackageName(params.packageName);
                clientGen.setIncludeGlobalTypes(params.useServerTypes);
                if (params.bindingFile != null && params.bindingFile.length() > 0) {
                    FileSet binding = new FileSet();
                    File bindingFile = new File(params.bindingFile);
                    binding.setFile(bindingFile);
                    binding.setProject(project);
                    clientGen.addBinding(binding);
                }
                clientGen.setWsdl(params.inputWSDL);
                if (params.handlerChainFile != null) {
                    clientGen.setHandlerChainFile(new File(params.handlerChainFile));
                }
                if (params.serviceName != null) {
                    clientGen.setServiceName(params.serviceName);
                }
                if (params.wsType != null && params.wsType.trim().length() > 0) {
                    clientGen.setType(params.wsType);
                }
                clientGen.setListfiles(true);
                clientGen.execute();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception encountered during clientGen", ex);
            }
        }

        private static void setupDescriptors(ClientGenParameters params, MultipleJwsModule module) {
            if (params.getDescriptors() != null) {
                String[] files = params.getDescriptors().split("\\,");
                for (int i = 0; i < files.length; ++i) {
                    File ff;
                    String file = files[i];
                    if (file == null || file.trim().length() <= 0 || !(ff = new File(file.trim())).exists()) continue;
                    JwsModule.Descriptor dd = module.createDescriptor();
                    dd.setFile(ff);
                }
            }
        }

        private static BuildListener getDefaultLogger(boolean verbose) {
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(verbose ? 4 : 2);
            return antLogger;
        }
    }
}

