/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.providers.ssh.jsch.AbstractJschWagon;
import org.codehaus.mojo.wagon.AbstractSingleWagonMojo;

@Mojo(name="sshexec")
public class SshExecMojo
extends AbstractSingleWagonMojo {
    @Parameter(required=true)
    private String[] commands;
    @Parameter(defaultValue="true")
    private boolean failOnError = true;
    @Parameter(defaultValue="false")
    private boolean displayCommandOutputs = true;

    @Override
    protected void execute(Wagon wagon) throws MojoExecutionException {
        if (this.commands != null) {
            for (String command : this.commands) {
                try {
                    Streams stream = wagon instanceof AbstractJschWagon ? ((AbstractJschWagon)wagon).executeCommand(command, true, false) : ((CommandExecutor)wagon).executeCommand(command, false);
                    this.getLog().info((CharSequence)("sshexec: " + command + " ..."));
                    if (!this.displayCommandOutputs) continue;
                    System.out.println(stream.getOut());
                    System.out.println(stream.getErr());
                }
                catch (WagonException e) {
                    if (this.failOnError) {
                        throw new MojoExecutionException("Unable to execute remote command", (Exception)((Object)e));
                    }
                    this.getLog().warn((Throwable)e);
                }
            }
        }
    }
}

