/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="unlock-snapshots", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UnlockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("-(\\d{8}\\.\\d{6})-(\\d+)$");

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            this.unlockSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
        }
        if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
            this.unlockSnapshots(pom, this.getProject().getDependencies());
        }
        if (this.getProject().getParent() != null && this.isProcessingParent()) {
            this.unlockParentSnapshot(pom, this.getProject().getParent());
        }
    }

    private void unlockSnapshots(ModifiedPomXMLEventReader pom, List<Dependency> dependencies) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = this.matchSnapshotRegex.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length()) continue;
            String unlockedVersion = versionMatcher.replaceFirst("-SNAPSHOT");
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), unlockedVersion, this.getProject().getModel())) continue;
            this.getLog().info((CharSequence)("Unlocked " + this.toString(dep) + " to version " + unlockedVersion));
        }
    }

    private void unlockParentSnapshot(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, MojoExecutionException {
        String unlockedParentVersion;
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = this.matchSnapshotRegex.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length() && PomHelper.setProjectParentVersion(pom, unlockedParentVersion = versionMatcher.replaceFirst("-SNAPSHOT"))) {
            this.getLog().info((CharSequence)("Unlocked parent " + parentArtifact + " to version " + unlockedParentVersion));
        }
    }
}

