/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.SegmentUtils;

@Mojo(name="update-property", threadSafe=true)
public class UpdatePropertyMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="property")
    protected String property = null;
    @Parameter(property="newVersion")
    private String newVersion = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;
    @Parameter(property="allowDowngrade", defaultValue="false")
    private boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;

    @Inject
    public UpdatePropertyMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        super(repositorySystem, projectBuilder, artifactMetadataSource, wagonManager, artifactResolver);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        Property propertyConfig = new Property(this.property);
        propertyConfig.setVersion(this.newVersion);
        Map<Property, PropertyVersions> propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), new Property[]{propertyConfig}, this.property, "", this.autoLinkItems);
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            Optional<Segment> unchangedSegment = SegmentUtils.determineUnchangedSegment(this.allowMajorUpdates, this.allowMinorUpdates, this.allowIncrementalUpdates, this.getLog());
            try {
                ArtifactVersion targetVersion = this.updatePropertyToNewestVersion(pom, property, version, currentVersion, this.allowDowngrade, unchangedSegment);
                if (targetVersion == null) continue;
                for (ArtifactAssociation association : version.getAssociations()) {
                    this.getChangeRecorder().recordUpdate("updateProperty", association.getGroupId(), association.getArtifactId(), currentVersion, targetVersion.toString());
                }
            }
            catch (InvalidVersionSpecificationException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
    }
}

