/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sqlj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:sqlj-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "SQLJ Maven Plugin 1.1", 0);
        this.append(sb, "A wrapper around the sqlj.tools.Sqlj SQLJ generator.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "sqlj:clean", 0);
            this.append(sb, "Cleans out generated stale resources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "generatedResourcesDirectory (Default: ${project.build.directory}/generated-resources/sqlj)", 2);
                this.append(sb, "Location for generated .ser files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/sqlj)", 2);
                this.append(sb, "Location for generated source files.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "sqlj:help", 0);
            this.append(sb, "Display help information on sqlj-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0sqlj:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "sqlj".equals(this.goal)) {
            this.append(sb, "sqlj:sqlj", 0);
            this.append(sb, "Generates SQLJ javacode.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Codepage for generated sources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedResourcesDirectory (Default: ${project.build.directory}/generated-resources/sqlj)", 2);
                this.append(sb, "Location for generated .ser files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/sqlj)", 2);
                this.append(sb, "Location for generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqljDirs", 2);
                this.append(sb, "Directories to recursively scan for .sqlj files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqljFiles", 2);
                this.append(sb, "Explicit list of sqlj files to process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "status (Default: true)", 2);
                this.append(sb, "Show status while executing.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

