/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.scmchangelog.ReportHelper;
import org.codehaus.mojo.scmchangelog.changelog.Release;
import org.codehaus.mojo.scmchangelog.changelog.ReleaseAlphabeticalComparator;
import org.codehaus.mojo.scmchangelog.changelog.log.Issue;
import org.codehaus.mojo.scmchangelog.changelog.log.OperationTypeEnum;
import org.codehaus.mojo.scmchangelog.changelog.log.ScmLogEntry;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.GrammarEnum;
import org.codehaus.mojo.scmchangelog.scm.ScmAdapterFactory;
import org.codehaus.mojo.scmchangelog.scm.util.ColorConsoleLogger;
import org.codehaus.mojo.scmchangelog.scm.util.ScmAdapter;
import org.codehaus.mojo.scmchangelog.tracker.BugTrackLinker;
import org.codehaus.mojo.scmchangelog.tracker.BugTrackers;
import org.codehaus.mojo.scmchangelog.tracker.BugzillaBugTrackLinker;
import org.codehaus.mojo.scmchangelog.tracker.JiraBugTrackLinker;
import org.codehaus.mojo.scmchangelog.tracker.SourceforgeBugTrackLinker;
import org.codehaus.mojo.scmchangelog.tracker.XPlannerBugTrackLinker;
import org.codehaus.plexus.util.StringUtils;

public class ScmActivityReport
extends AbstractMavenReport {
    private boolean logHasBeenColorized = false;
    private static SimpleDateFormat simpleDateFormat;
    private static SimpleDateFormat simpleTimestampFormat;
    private String commentSeparator;
    private String trackerUrlPattern;
    private String trackerType;
    private String dateFormat;
    private String timestampFormat;
    private File basedir;
    private String grammar;
    private String releasesOrder;
    private String username;
    private String password;
    private String privateKey;
    private String passphrase;
    private String tagBase;
    private String filter;
    private MavenProject project;
    private File outputDirectory;
    private Renderer siteRenderer;
    private Settings settings;
    private ScmManager manager;
    private String connectionUrl;
    private String developerConnectionUrl;
    private String connectionType;
    private BugTrackLinker bugLinker;
    private ResourceBundle bundle = this.getBundle(Locale.getDefault());

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        return this.outputDirectory.getAbsolutePath();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.bundle.getString("report.svn.changelog.description");
    }

    public String getName(Locale locale) {
        return this.bundle.getString("report.svn.changelog.plugin.name");
    }

    public String getOutputName() {
        return this.bundle.getString("report.svn.changelog.plugin.output.name");
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scm-activity", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.bundle = this.getBundle(locale);
            ScmRepository repository = this.getScmRepository();
            GrammarEnum realGrammar = GrammarEnum.valueOf(this.grammar);
            this.commentSeparator = realGrammar.getIssueSeparator();
            ScmFileSet fileSet = this.getFileSet("");
            this.getLog().debug((CharSequence)("FileSet : " + fileSet));
            ScmAdapter adapter = ScmAdapterFactory.getInstance(this.getScmManager(), realGrammar, repository, this.getLog());
            List releases = adapter.getListOfReleases(repository, fileSet);
            if ("alphabetic".equalsIgnoreCase(this.releasesOrder)) {
                Collections.sort(releases, new ReleaseAlphabeticalComparator());
            }
            this.doGenerateReport(releases, this.getSink());
        }
        catch (MojoExecutionException ex) {
            Logger.getLogger(ScmActivityReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MavenReportException(this.bundle.getString("error"), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            Logger.getLogger(ScmActivityReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MavenReportException(this.bundle.getString("error"), (Exception)ex);
        }
        catch (ScmException ex) {
            Logger.getLogger(ScmActivityReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MavenReportException(this.bundle.getString("error"), (Exception)((Object)ex));
        }
        try {
            ReportHelper.copyImage(this.bundle.getString("report.svn.changelog.img.update"), this.getReportOutputDirectory().getAbsolutePath());
            ReportHelper.copyImage(this.bundle.getString("report.svn.changelog.img.fix"), this.getReportOutputDirectory().getAbsolutePath());
            ReportHelper.copyImage(this.bundle.getString("report.svn.changelog.img.remove"), this.getReportOutputDirectory().getAbsolutePath());
            ReportHelper.copyImage(this.bundle.getString("report.svn.changelog.img.add"), this.getReportOutputDirectory().getAbsolutePath());
        }
        catch (IOException ioex) {
            throw new MavenReportException(this.bundle.getString("error.copy.images"), (Exception)ioex);
        }
    }

    protected void doGenerateReport(List releases, Sink sink) {
        sink.head();
        sink.title();
        sink.text(this.bundle.getString("report.svn.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.bundle.getString("report.svn.changelog.mainTitle"));
        sink.sectionTitle1_();
        this.doSummarySection(releases, sink);
        Iterator iter = releases.iterator();
        while (iter.hasNext()) {
            Release release = (Release)iter.next();
            this.doRelease(release, sink);
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doSummarySection(List releases, Sink sink) {
        sink.paragraph();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(this.bundle.getString("report.svn.changelog.version"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.bundle.getString("report.svn.changelog.date"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.bundle.getString("report.svn.changelog.author"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.bundle.getString("report.svn.changelog.revision"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        Iterator iter = releases.iterator();
        while (iter.hasNext()) {
            Release release = (Release)iter.next();
            sink.tableRow();
            sink.tableCell();
            sink.link('#' + release.getTag().getTitle());
            sink.text(release.getTag().getTitle());
            sink.link_();
            sink.tableCell_();
            sink.tableCell();
            sink.text(this.formatTimestamp(release.getTag().getDate()));
            sink.tableCell_();
            sink.tableCell();
            sink.text(release.getTag().getAuthor());
            sink.tableCell_();
            sink.tableCell();
            if (release.getTag().getEndRevision() == null) {
                sink.text(this.bundle.getString("scm.head.name"));
            } else {
                sink.text(release.getTag().getEndRevision());
            }
            sink.text(":" + release.getTag().getStartRevision());
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.paragraph_();
    }

    private void doRelease(Release release, Sink sink) {
        sink.sectionTitle2();
        sink.anchor(release.getTag().getTitle());
        sink.text(release.getTag().getTitle() + " - " + this.formatDate(release.getTag().getDate()));
        sink.anchor_();
        sink.sectionTitle2_();
        sink.paragraph();
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell(this.bundle.getString("report.svn.changelog.img_cell.width"));
        sink.text(this.bundle.getString("report.svn.changelog.type"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell(this.bundle.getString("report.svn.changelog.bug_cell.width"));
        sink.text(this.bundle.getString("report.svn.changelog.bug"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(this.bundle.getString("report.svn.changelog.details"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell(this.bundle.getString("report.svn.changelog.date_cell.width"));
        sink.text(this.bundle.getString("report.svn.changelog.date"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell(this.bundle.getString("report.svn.changelog.author_cell.width"));
        sink.text(this.bundle.getString("report.svn.changelog.author"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell(this.bundle.getString("report.svn.changelog.revision_cell.width"));
        sink.text(this.bundle.getString("report.svn.changelog.revision"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        List entries = release.getEntries();
        Collections.sort(entries);
        Collections.reverse(entries);
        this.getLog().info((CharSequence)("We have " + entries.size() + " entries for " + release.getTag().getTitle()));
        Iterator iterEntry = entries.iterator();
        while (iterEntry.hasNext()) {
            Issue issue;
            Iterator iterIssue;
            ScmLogEntry entry = (ScmLogEntry)iterEntry.next();
            this.getLog().info((CharSequence)("Entry : " + entry.getRevision() + entry.getMessage().getComment()));
            sink.tableRow();
            sink.tableCell(this.bundle.getString("report.svn.changelog.img_cell.width"));
            if (!entry.getMessage().getIssues().isEmpty()) {
                iterIssue = entry.getMessage().getIssues().iterator();
                while (iterIssue.hasNext()) {
                    issue = (Issue)iterIssue.next();
                    sink.figure();
                    if (OperationTypeEnum.UPDATE.equals(issue.getType())) {
                        sink.figureGraphics(this.bundle.getString("report.svn.changelog.img.update"));
                    } else if (OperationTypeEnum.ADD.equals(issue.getType())) {
                        sink.figureGraphics(this.bundle.getString("report.svn.changelog.img.add"));
                    } else if (OperationTypeEnum.FIX.equals(issue.getType())) {
                        sink.figureGraphics(this.bundle.getString("report.svn.changelog.img.fix"));
                    } else if (OperationTypeEnum.REMOVE.equals(issue.getType())) {
                        sink.figureGraphics(this.bundle.getString("report.svn.changelog.img.remove"));
                    }
                    sink.figureCaption();
                    sink.figureCaption_();
                    sink.figure_();
                    sink.lineBreak();
                }
            } else {
                sink.figure();
                sink.figureGraphics(this.bundle.getString("report.svn.changelog.img.update"));
                sink.figure_();
            }
            sink.tableCell_();
            sink.tableCell(this.bundle.getString("report.svn.changelog.bug_cell.width"));
            if (!entry.getMessage().getIssues().isEmpty()) {
                iterIssue = entry.getMessage().getIssues().iterator();
                while (iterIssue.hasNext()) {
                    issue = (Issue)iterIssue.next();
                    if (issue.getIssue() != null && !"".equals(issue.getIssue())) {
                        sink.link(this.doLinkIssue(issue.getIssue()));
                        sink.text(issue.getIssue());
                        sink.link_();
                    } else {
                        sink.text("");
                    }
                    sink.lineBreak();
                }
            }
            sink.tableCell_();
            sink.tableCell();
            String comment = entry.getMessage().getComment();
            if (comment != null) {
                StringTokenizer tokenizer = new StringTokenizer(comment, this.commentSeparator);
                while (tokenizer.hasMoreTokens()) {
                    sink.text(tokenizer.nextToken());
                    sink.lineBreak();
                }
            }
            sink.tableCell_();
            sink.tableCell(this.bundle.getString("report.svn.changelog.date_cell.width"));
            sink.text(this.formatTimestamp(entry.getDate()));
            sink.tableCell_();
            sink.tableCell(this.bundle.getString("report.svn.changelog.author_cell.width"));
            sink.text(entry.getAuthor());
            sink.tableCell_();
            sink.tableCell(this.bundle.getString("report.svn.changelog.revision_cell.width"));
            sink.text(entry.getRevision());
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
        sink.paragraph_();
    }

    protected String formatDate(Date date) {
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(this.dateFormat);
        }
        return simpleDateFormat.format(date);
    }

    protected String formatTimestamp(Date date) {
        if (simpleTimestampFormat == null) {
            simpleTimestampFormat = new SimpleDateFormat(this.timestampFormat);
        }
        return simpleTimestampFormat.format(date);
    }

    protected BugTrackLinker getBugTrackLinker() {
        if (this.bugLinker == null) {
            this.getLog().info((CharSequence)("Building bugLinker of type " + this.getTrackerType() + " with pattern " + this.trackerUrlPattern));
            this.bugLinker = BugTrackers.JIRA.equals(BugTrackers.valueOf(this.getTrackerType())) ? new JiraBugTrackLinker(this.trackerUrlPattern) : (BugTrackers.BUGZILLA.equals(BugTrackers.valueOf(this.getTrackerType())) ? new BugzillaBugTrackLinker(this.trackerUrlPattern) : (BugTrackers.XPLANNER.equals(BugTrackers.valueOf(this.getTrackerType())) ? new XPlannerBugTrackLinker(this.trackerUrlPattern) : new SourceforgeBugTrackLinker(this.trackerUrlPattern)));
        }
        return this.bugLinker;
    }

    protected String doLinkIssue(String issue) {
        return this.getBugTrackLinker().getLinkUrlForBug(issue);
    }

    protected String getTrackerType() {
        return this.trackerType.toLowerCase();
    }

    public String getConnectionUrl() {
        boolean requireDeveloperConnection;
        boolean bl = requireDeveloperConnection = !"connection".equals(this.connectionType.toLowerCase());
        if (StringUtils.isNotEmpty((String)this.connectionUrl) && !requireDeveloperConnection) {
            return this.connectionUrl;
        }
        if (StringUtils.isNotEmpty((String)this.developerConnectionUrl)) {
            return this.developerConnectionUrl;
        }
        if (requireDeveloperConnection) {
            throw new NullPointerException(this.bundle.getString("error.developer.connection.url"));
        }
        throw new NullPointerException(this.bundle.getString("error.connection.url"));
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public ScmManager getScmManager() {
        ScmAdapterFactory.registerProviders(this.manager, GrammarEnum.valueOf(this.grammar), this.getLog(), this.getPattern());
        return this.manager;
    }

    protected Pattern getPattern() {
        if (this.filter != null && !"".equals(this.filter)) {
            return Pattern.compile(this.filter);
        }
        return null;
    }

    public ScmFileSet getFileSet(String fileName) throws IOException {
        return new ScmFileSet(this.basedir, new File(fileName));
    }

    public ScmFileSet getFileSet(String includes, String excludes) throws IOException {
        if (includes != null || excludes != null) {
            return new ScmFileSet(this.basedir, includes, excludes);
        }
        return new ScmFileSet(this.basedir);
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(this.getConnectionUrl());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            if (!StringUtils.isEmpty((String)this.username)) {
                providerRepo.setUser(this.username);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)this.username)) {
                    repo.setUser(this.username);
                }
                if (!StringUtils.isEmpty((String)this.password)) {
                    repo.setPassword(this.password);
                }
                if (!StringUtils.isEmpty((String)this.privateKey)) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (!StringUtils.isEmpty((String)this.passphrase)) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            ScmAdapterFactory.setTagBase(repository, this.tagBase);
        }
        catch (ScmRepositoryException e) {
            if (!e.getValidationMessages().isEmpty()) {
                Iterator i = e.getValidationMessages().iterator();
                while (i.hasNext()) {
                    String message = (String)i.next();
                    this.getLog().error((CharSequence)message);
                }
            }
            throw new ScmException(this.bundle.getString("error.scm.provider"), (Throwable)e);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new ScmException(this.bundle.getString("error.scm.provider"), (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + this.bundle.getString(":") + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                if (this.username == null) {
                    this.username = server.getUsername();
                }
                if (this.password == null) {
                    this.password = server.getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = server.getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = server.getPassphrase();
                }
            }
        }
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)this.bundle.getString("error.provider"));
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)this.bundle.getString("command.output"));
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException(this.bundle.getString("error.command") + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }

    public void setLog(Log log) {
        if (this.isColorized()) {
            super.setLog((Log)new ColorConsoleLogger(log));
            this.logHasBeenColorized = true;
        } else {
            super.setLog(log);
        }
    }

    public Log getLog() {
        Log log = super.getLog();
        if (!this.logHasBeenColorized && this.isColorized()) {
            log = new ColorConsoleLogger(log);
            super.setLog(log);
            this.logHasBeenColorized = true;
        }
        return log;
    }

    private boolean isColorized() {
        return System.getProperty("colorized.console") != null;
    }
}

